/*
 * Decompiled with CFR 0.152.
 */
package org.jiuwo.fastel.util;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import org.jiuwo.fastel.Executable;
import org.jiuwo.fastel.exception.FastElException;
import org.jiuwo.fastel.util.ExecutableUtil;
import org.jiuwo.fastel.util.ReferenceUtil;
import org.jiuwo.fastel.util.ValueStackMap;

public class ValueStackUtil {
    public static <T> T wrapAsContext(Object context) {
        Map valueStack = context instanceof Map ? (Map)context : (context == null ? new ValueStackMap(Collections.emptyMap()) : new ValueStackMap(context));
        return (T)valueStack;
    }

    public static Object getValueStack(Map<String, Object> vs, Map<Object, Object> jsNodeList, Object key) {
        Object o = vs.get(key);
        if (o == null) {
            return jsNodeList.get(key);
        }
        return o;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object invoke(Map<String, Object> vs, Object arg1, Object[] arguments) {
        try {
            Object thiz;
            Executable executable = null;
            if (arg1 instanceof ReferenceUtil) {
                Object name;
                ReferenceUtil pv = (ReferenceUtil)arg1;
                thiz = pv.getBase();
                executable = ExecutableUtil.getExecutable(thiz, String.valueOf(name = pv.getName()), arguments);
                if (executable != null) return executable.invoke(thiz, arguments);
                arg1 = pv.getValue();
            } else {
                thiz = vs;
            }
            if (executable != null) return executable.invoke(thiz, arguments);
            if (arg1 instanceof Executable) {
                executable = (Executable)arg1;
                return executable.invoke(thiz, arguments);
            } else {
                if (!(arg1 instanceof Method)) throw new FastElException("\u5bf9\u8c61\u4e0d\u662f\u6709\u6548\u51fd\u6570:" + arg1);
                executable = ExecutableUtil.createProxy((Method)arg1);
            }
            return executable.invoke(thiz, arguments);
        }
        catch (Exception e) {
            throw new FastElException("\u65b9\u6cd5\u8c03\u7528\u5931\u8d25:" + arg1, e);
        }
    }
}

