/*
 * Decompiled with CFR 0.152.
 */
package org.jiuwo.fastel.util.function;

import com.alibaba.fastjson.JSON;
import java.io.UnsupportedEncodingException;
import org.jiuwo.fastel.contract.enums.ExpressionEnum;
import org.jiuwo.fastel.exception.FastElException;
import org.jiuwo.fastel.util.EncodingUtil;
import org.jiuwo.fastel.util.ObjectUtil;
import org.jiuwo.fastel.util.ParseUtil;

public class JsExpressionFunction {
    private final Number xNull;
    private final Number xNaN;
    private final Number yNaN;
    private final ExpressionEnum.JsToken jsToken;
    private final Object[] args;

    public JsExpressionFunction(Object[] args, ExpressionEnum.JsToken jsToken) {
        this.args = args;
        this.xNull = ObjectUtil.getNumberArg(args, 0, null);
        this.xNaN = ObjectUtil.getNumberArg(args, 0, Double.NaN);
        this.yNaN = args.length > 1 ? (Number)ObjectUtil.getNumberArg(args, 1, Double.NaN) : (Number)0;
        this.jsToken = jsToken;
    }

    public final boolean parseIsNaN() {
        if (this.xNull == null) {
            return false;
        }
        return Double.isNaN(this.xNull.doubleValue());
    }

    public final boolean parseIsFinite() {
        if (this.xNull == null) {
            return true;
        }
        return !Double.isNaN(this.xNull.doubleValue()) && !Double.isInfinite(this.xNull.doubleValue());
    }

    public final int parseInt() {
        return Integer.parseInt(this.xNaN.toString(), this.yNaN.intValue() == 0 ? 10 : this.yNaN.intValue());
    }

    public float parseFloat() {
        return this.xNaN.floatValue();
    }

    public final Object enOrDeCodeURI() {
        try {
            String text = String.valueOf(ObjectUtil.getArg(this.args, 0, "null"));
            String charset = String.valueOf(ObjectUtil.getArg(this.args, 1, "utf-8"));
            Object result = EncodingUtil.enOrDecode(1 == ((Integer)this.jsToken.getValue() & 0xF00) >> 8, 1 == ((Integer)this.jsToken.getValue() & 0xF0) >> 4, text, charset);
            return result;
        }
        catch (UnsupportedEncodingException ex) {
            throw new FastElException(ex);
        }
    }

    public final Number min() {
        if (Math.min(this.xNaN.doubleValue(), this.yNaN.doubleValue()) == this.xNaN.doubleValue()) {
            return this.xNaN;
        }
        return this.yNaN;
    }

    public final Number max() {
        if (Math.max(this.xNaN.doubleValue(), this.yNaN.doubleValue()) == this.xNaN.doubleValue()) {
            return this.xNaN;
        }
        return this.yNaN;
    }

    public final double abs() {
        return Math.abs(this.xNaN.doubleValue());
    }

    public final double acos() {
        return Math.acos(this.xNaN.doubleValue());
    }

    public final double asin() {
        return Math.asin(this.xNaN.doubleValue());
    }

    public final double atan() {
        return Math.atan(this.xNaN.doubleValue());
    }

    public final double atan2() {
        return Math.atan2(this.xNaN.doubleValue(), this.yNaN.doubleValue());
    }

    public final double ceil() {
        return Math.ceil(this.xNaN.doubleValue());
    }

    public final double cos() {
        return Math.cos(this.xNaN.doubleValue());
    }

    public final double exp() {
        return Math.exp(this.xNaN.doubleValue());
    }

    public final double floor() {
        return Math.floor(this.xNaN.doubleValue());
    }

    public final double log() {
        return Math.log(this.xNaN.doubleValue());
    }

    public final double pow() {
        return Math.pow(this.xNaN.doubleValue(), this.yNaN.doubleValue());
    }

    public final double random() {
        return Math.random();
    }

    public final long round() {
        return Math.round(this.xNaN.doubleValue());
    }

    public final double sin() {
        return Math.sin(this.xNaN.doubleValue());
    }

    public final double sqrt() {
        return Math.sqrt(this.xNaN.doubleValue());
    }

    public final double tan() {
        return Math.tan(this.xNaN.doubleValue());
    }

    public final Object parse() {
        String value = ObjectUtil.getStringArg(this.args, 0, null);
        Object result = JSON.parse((String)ParseUtil.parseToPrimitive(value, String.class).toString());
        return result;
    }

    public final Object stringify() {
        Object value = ObjectUtil.getArg(this.args, 0, null);
        String result = JSON.toJSONString((Object)value);
        return result;
    }
}

