/*
 * Decompiled with CFR 0.152.
 */
package org.jiuwo.fastel.util.function;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jiuwo.fastel.Executable;
import org.jiuwo.fastel.constant.map.MapConstant;
import org.jiuwo.fastel.contract.enums.ExpressionEnum;
import org.jiuwo.fastel.exception.FastElException;
import org.jiuwo.fastel.impl.ExpressionNode;
import org.jiuwo.fastel.impl.OperationStrategyImpl;
import org.jiuwo.fastel.util.NumberUtil;
import org.jiuwo.fastel.util.ObjectUtil;
import org.jiuwo.fastel.util.ParseUtil;
import org.jiuwo.fastel.util.ReferenceUtil;
import org.jiuwo.fastel.util.ReflectUtil;
import org.jiuwo.fastel.util.ValueStackUtil;

public class OperationStrategyFunction {
    private final ExpressionNode node;
    private final Map<String, Object> vs;
    private final OperationStrategyImpl strategy;

    public OperationStrategyFunction(ExpressionNode node, Map<String, Object> vs, OperationStrategyImpl strategy) {
        this.node = node;
        this.vs = vs;
        this.strategy = strategy;
    }

    private Object getArgLeft() {
        return this.strategy.evaluate(this.node.getLeft(), this.vs);
    }

    private Object getArgRight() {
        if ((this.node.getToken().getValue() & 0x300) > 0) {
            return this.strategy.evaluate(this.node.getRight(), this.vs);
        }
        return null;
    }

    public Object evaluateValueVar() {
        Object key = this.node.getParam();
        return ValueStackUtil.getValueStack(this.vs, MapConstant.getInstance(), key);
    }

    public Object evaluateValueConstants() {
        return this.node.getParam();
    }

    public Object evaluateValueList() {
        return new ArrayList();
    }

    public Object evaluateValueMap() {
        return new LinkedHashMap();
    }

    public Object evaluateOpInvoke() {
        Object key;
        Object base;
        Object[] arguments = this.node.getToken().equals((Object)ExpressionEnum.Token.OP_INVOKE) ? ((List)this.strategy.evaluate(this.node.getRight(), this.vs)).toArray() : (Object[])this.node.getParam();
        ExpressionNode left = this.node.getLeft();
        ExpressionEnum.Token token2 = this.node.getToken();
        if (token2.equals((Object)ExpressionEnum.Token.OP_GET)) {
            base = this.strategy.evaluate(left.getLeft(), this.vs);
            key = this.strategy.evaluate(left.getRight(), this.vs);
        } else if (token2 == ExpressionEnum.Token.OP_GET_STATIC) {
            base = this.strategy.evaluate(left.getLeft(), this.vs);
            key = left.getRight().getParam();
        } else {
            return ValueStackUtil.invoke(this.vs, this.strategy.evaluate(left, this.vs), arguments);
        }
        return ValueStackUtil.invoke(this.vs, new ReferenceUtil(base, key), arguments);
    }

    public Object evaluateOpGetStatic() {
        return ReflectUtil.getValue(this.getArgLeft(), this.node.getParam());
    }

    public Object evaluateOpGet() {
        Object argRight = this.strategy.evaluate(this.node.getRight(), this.vs);
        return ReflectUtil.getValue(this.getArgLeft(), argRight);
    }

    public Object evaluateOpAnd() {
        Object argLeft = this.getArgLeft();
        if (ParseUtil.parseToBoolean(argLeft)) {
            return this.strategy.evaluate(this.node.getRight(), this.vs);
        }
        return argLeft;
    }

    public Object evaluateOpOr() {
        Object argLeft = this.getArgLeft();
        if (ParseUtil.parseToBoolean(argLeft)) {
            return argLeft;
        }
        return this.strategy.evaluate(this.node.getRight(), this.vs);
    }

    public Object evaluateOpQuestionSelect() {
        ExpressionNode nodeLeft = (ExpressionNode)this.getArgLeft();
        if (ParseUtil.parseToBoolean(this.strategy.evaluate(nodeLeft.getLeft(), this.vs))) {
            return this.strategy.evaluate(nodeLeft.getRight(), this.vs);
        }
        return this.strategy.evaluate(this.node.getRight(), this.vs);
    }

    public Object evaluateOpQuestion() {
        return this.node.getToken();
    }

    public Object evaluateOpNot() {
        return !ParseUtil.parseToBoolean(this.getArgLeft());
    }

    public Object evaluateOpPos() {
        return ParseUtil.parseToNumber(this.getArgLeft());
    }

    public Object evaluateOpNeg() {
        return NumberUtil.subtract(0, ParseUtil.parseToNumber(this.getArgLeft()));
    }

    public Object evaluateOpAdd() {
        Object primitiveLeft = ParseUtil.parseToPrimitive(this.getArgLeft(), String.class);
        Object primitiveRight = ParseUtil.parseToPrimitive(this.getArgRight(), String.class);
        if (primitiveLeft instanceof String || primitiveLeft instanceof Character) {
            return primitiveLeft + ParseUtil.parseToString(primitiveRight);
        }
        if (primitiveRight instanceof String || primitiveRight instanceof Character) {
            return ParseUtil.parseToString(primitiveLeft) + primitiveRight;
        }
        return NumberUtil.plus(ParseUtil.parseToNumber(primitiveLeft), ParseUtil.parseToNumber(primitiveRight));
    }

    public Object evaluateOpSub() {
        return NumberUtil.subtract(ParseUtil.parseToNumber(this.getArgLeft()), ParseUtil.parseToNumber(this.getArgRight()));
    }

    public Object evaluateOpMul() {
        return NumberUtil.multiply(ParseUtil.parseToNumber(this.getArgLeft()), ParseUtil.parseToNumber(this.getArgRight()));
    }

    public Object evaluateOpDiv() {
        return NumberUtil.divide(ParseUtil.parseToNumber(this.getArgLeft()), ParseUtil.parseToNumber(this.getArgRight()));
    }

    public Object evaluateOpMod() {
        return NumberUtil.modulus(ParseUtil.parseToNumber(this.getArgLeft()), ParseUtil.parseToNumber(this.getArgRight()));
    }

    public Object evaluateOpEqStrict() {
        return ObjectUtil.isEquals(this.getArgLeft(), this.getArgRight(), true);
    }

    public Object evaluateOpEq() {
        return ObjectUtil.isEquals(this.getArgLeft(), this.getArgRight(), true);
    }

    public Object evaluateOpNe() {
        return !ObjectUtil.isEquals(this.getArgLeft(), this.getArgRight(), false);
    }

    public Object evaluateOpNeStrict() {
        return !ObjectUtil.isEquals(this.getArgLeft(), this.getArgRight(), true);
    }

    public Object evaluateOpGlteq() {
        return ObjectUtil.compare(this.getArgLeft(), this.getArgRight(), this.node.getToken());
    }

    public Object evaluateOpJoin() {
        Object argLeft = this.getArgLeft();
        ((List)argLeft).add(this.getArgRight());
        return argLeft;
    }

    public Object evaluateOpPut() {
        Object argLeft = this.getArgLeft();
        ((Map)argLeft).put(this.node.getParam(), this.getArgRight());
        return argLeft;
    }

    public Object evaluateOpIn() {
        return ObjectUtil.in(this.getArgLeft(), this.getArgRight());
    }

    public Object evaluateOpDefault() {
        Object argLeft = this.getArgLeft();
        Object argRight = this.getArgRight();
        int numberLeft = ParseUtil.parseToNumber(argLeft).intValue();
        int numberRight = ParseUtil.parseToNumber(argRight).intValue();
        switch (this.node.getToken()) {
            case OP_BIT_AND: {
                return numberLeft & numberRight;
            }
            case OP_BIT_XOR: {
                return numberLeft ^ numberRight;
            }
            case OP_BIT_OR: {
                return numberLeft | numberRight;
            }
            case OP_LSH: {
                return numberLeft << numberRight;
            }
            case OP_RSH: {
                return numberLeft >> numberRight;
            }
            case OP_URSH: {
                return numberLeft >>> numberRight;
            }
        }
        Object impl = MapConstant.getInstance().get((Object)this.node.getToken());
        if (impl != null) {
            Executable method = (Executable)impl;
            try {
                return method.invoke(null, argLeft, argRight);
            }
            catch (Exception e) {
                throw new FastElException("\u65b9\u6cd5\u8c03\u7528\u5931\u8d25:" + argLeft, e);
            }
        }
        throw new FastElException("\u4e0d\u652f\u6301\u7684\u64cd\u4f5c\u7b26" + (Object)((Object)this.node.getToken()));
    }
}

