/*
 * Decompiled with CFR 0.152.
 */
package org.jiuwo.graphql.client;

import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.jiuwo.graphql.client.contract.ExecutionResult;
import org.jiuwo.graphql.client.contract.GraphqlRequest;
import org.jiuwo.graphql.client.contract.ResultAttribute;
import org.jiuwo.graphql.client.enums.RequestTypeEnum;
import org.jiuwo.graphql.client.util.HttpUtil;
import org.jiuwo.graphql.client.util.JsonUtil;

public class GraphqlClient {
    private String url;
    private RequestTypeEnum requestType = RequestTypeEnum.QUERY;
    private Map<String, String> headers = new HashMap<String, String>();
    private int currentRequestIndex = 0;
    private Map<Integer, GraphqlRequest> requestMap = new HashMap<Integer, GraphqlRequest>();

    public static GraphqlClient build() {
        GraphqlClient graphqlClient = new GraphqlClient();
        return graphqlClient;
    }

    public ExecutionResult execute() {
        if (this.requestType.equals((Object)RequestTypeEnum.QUERY)) {
            return this.query();
        }
        return this.mutation();
    }

    public <T> ExecutionResult<T> executeSingle(Type type) {
        ExecutionResult executionResult = this.execute();
        Object firstValue = ((JSONObject)executionResult.getData()).values().stream().findFirst().orElse(null);
        if (firstValue == null) {
            executionResult.setDataSingle(null);
        } else {
            executionResult.setDataSingle(JsonUtil.toObject(JsonUtil.toJson(firstValue), type));
        }
        return executionResult;
    }

    private ExecutionResult query() {
        return HttpUtil.postJson(this.url, this.toString(), this.headers, ExecutionResult.class);
    }

    private ExecutionResult mutation() {
        return HttpUtil.postJson(this.url, this.toString(), this.headers, ExecutionResult.class);
    }

    public GraphqlClient url(String url) {
        this.url = url;
        return this;
    }

    public GraphqlClient addHeader(String key, String value) {
        this.headers.put(key, value);
        return this;
    }

    public GraphqlClient headers(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public GraphqlClient addRequest(GraphqlRequest request) {
        ++this.currentRequestIndex;
        this.requestMap.put(this.currentRequestIndex, request);
        return this;
    }

    public GraphqlClient requestType(RequestTypeEnum requestType) {
        this.requestType = requestType;
        return this;
    }

    private GraphqlRequest getRequest(int index) {
        return this.requestMap.get(index);
    }

    private GraphqlRequest getRequest() {
        return this.getRequest(this.currentRequestIndex);
    }

    public String toString() {
        String query = "{\"query\":\"%s{%s}\"}";
        StringBuilder requestBuilder = new StringBuilder();
        this.requestMap.forEach((k, v) -> {
            String parameters = v.getRequestParameter().toString();
            requestBuilder.append(v.getRequestName());
            requestBuilder.append(parameters);
            requestBuilder.append("{");
            requestBuilder.append(v.getResultAttributes().stream().map(ResultAttribute::toString).collect(Collectors.joining(" ")));
            requestBuilder.append("}");
        });
        return String.format(query, this.requestType.equals((Object)RequestTypeEnum.QUERY) ? "" : "mutation", requestBuilder.toString());
    }
}

