/*
 * Decompiled with CFR 0.152.
 */
package org.jiuwo.graphql.client.contract;

import java.util.ArrayList;
import java.util.List;
import org.jiuwo.graphql.client.contract.RequestParameter;
import org.jiuwo.graphql.client.contract.ResultAttribute;

public class GraphqlRequest {
    private String requestName;
    private RequestParameter requestParameter = RequestParameter.build();
    private List<ResultAttribute> resultAttributes = new ArrayList<ResultAttribute>();

    public GraphqlRequest(String requestName) {
        this.requestName = requestName;
    }

    public static GraphqlRequest build(String requestName) {
        return new GraphqlRequest(requestName);
    }

    public GraphqlRequest addParameter(String key, Object value) {
        this.requestParameter.addParameter(key, value);
        return this;
    }

    public GraphqlRequest parameter(RequestParameter requestParameter) {
        this.requestParameter = requestParameter;
        return this;
    }

    public GraphqlRequest addResultAttributes(String ... names) {
        if (names != null && names.length > 0) {
            for (String key : names) {
                this.resultAttributes.add(ResultAttribute.build().setName(key));
            }
        }
        return this;
    }

    public GraphqlRequest addResultAttribute(String rootName, String ... names) {
        this.resultAttributes.add(ResultAttribute.build().setName(rootName).addChildrenResultAttribute(names));
        return this;
    }

    public GraphqlRequest resultAttribute(List<ResultAttribute> resultAttributes) {
        this.resultAttributes = resultAttributes;
        return this;
    }

    public String getRequestName() {
        return this.requestName;
    }

    public RequestParameter getRequestParameter() {
        return this.requestParameter;
    }

    public List<ResultAttribute> getResultAttributes() {
        return this.resultAttributes;
    }
}

