/*
 * Decompiled with CFR 0.152.
 */
package org.jiuwo.graphql.client.util;

import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jiuwo.graphql.client.util.JsonUtil;

public class HttpUtil {
    private static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private static final String HTTPS = "https";
    private static OkHttpClient httpClient = null;
    private static OkHttpClient httpClientSsl = null;

    static TrustManager[] trustAllCerts() {
        return new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                X509Certificate[] x509Certificates = new X509Certificate[]{};
                return x509Certificates;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
    }

    static HostnameVerifier doNotVerify() {
        return new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
    }

    static X509TrustManager x509TrustManager() {
        return new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        };
    }

    public static OkHttpClient getOkHttpClient() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.connectTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).retryOnConnectionFailure(true);
        return builder.build();
    }

    public static OkHttpClient getOkHttpClientSSL() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.connectTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).retryOnConnectionFailure(true).sslSocketFactory(HttpUtil.getTrustedSSLSocketFactory(), HttpUtil.x509TrustManager()).hostnameVerifier(HttpUtil.doNotVerify());
        return builder.build();
    }

    private static SSLSocketFactory getTrustedSSLSocketFactory() {
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, HttpUtil.trustAllCerts(), new SecureRandom());
            return sc.getSocketFactory();
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OkHttpClient getHttpClientInstance() {
        if (httpClient != null) return httpClient;
        Class<OkHttpClient> clazz = OkHttpClient.class;
        synchronized (OkHttpClient.class) {
            if (httpClient != null) return httpClient;
            httpClient = HttpUtil.getOkHttpClient();
            // ** MonitorExit[var0] (shouldn't be in output)
            return httpClient;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OkHttpClient getHttpClientSslInstance() {
        if (httpClientSsl != null) return httpClientSsl;
        Class<OkHttpClient> clazz = OkHttpClient.class;
        synchronized (OkHttpClient.class) {
            if (httpClientSsl != null) return httpClientSsl;
            httpClientSsl = HttpUtil.getOkHttpClientSSL();
            // ** MonitorExit[var0] (shouldn't be in output)
            return httpClientSsl;
        }
    }

    public static OkHttpClient getHttpClient(String url) {
        if (!url.startsWith(HTTPS)) {
            return HttpUtil.getHttpClientInstance();
        }
        return HttpUtil.getHttpClientSslInstance();
    }

    private static void closeResponse(Response response) {
        if (response != null) {
            response.close();
        }
    }

    public static <T> T postJson(String url, String json, Map<String, String> headers, Class<T> clazz) {
        T t;
        Response response = null;
        try {
            RequestBody body = RequestBody.create((MediaType)JSON, (String)json);
            Request request = new Request.Builder().url(url).post(body).headers(Headers.of(headers)).build();
            response = HttpUtil.getHttpClient(url).newCall(request).execute();
            t = JsonUtil.toObject(response.body().string(), clazz);
        }
        catch (Exception ex) {
            try {
                throw new RuntimeException(ex);
            }
            catch (Throwable throwable) {
                HttpUtil.closeResponse(response);
                throw throwable;
            }
        }
        HttpUtil.closeResponse(response);
        return t;
    }
}

