/*
 * Decompiled with CFR 0.152.
 */
package org.jiuwo.graphql.client.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.JSONLibDataFormatSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.List;

public class JsonUtil {
    private static final SerializeConfig config;
    private static final SerializerFeature[] features;

    public static String toJson(Object object) {
        return JSON.toJSONString((Object)object, (SerializeConfig)config, (SerializerFeature[])features);
    }

    public static String toJsonNoFeatures(Object object) {
        return JSON.toJSONString((Object)object, (SerializeConfig)config, (SerializerFeature[])new SerializerFeature[0]);
    }

    public static Object toObject(String json) {
        return JSON.parse((String)json);
    }

    public static <T> T toObject(String json, Class<T> clazz) {
        return (T)JSON.parseObject((String)json, clazz);
    }

    public static <T> T toObject(String json, Type type) {
        return (T)JSON.parseObject((String)json, (Type)type, (Feature[])new Feature[0]);
    }

    public static <T> List<T> toList(String json, Class<T> clazz) {
        return JSON.parseArray((String)json, clazz);
    }

    static {
        features = new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullListAsEmpty, SerializerFeature.WriteNullNumberAsZero, SerializerFeature.WriteNullBooleanAsFalse, SerializerFeature.WriteNullStringAsEmpty};
        config = new SerializeConfig();
        config.put(Date.class, (ObjectSerializer)new JSONLibDataFormatSerializer());
        config.put(java.sql.Date.class, (ObjectSerializer)new JSONLibDataFormatSerializer());
    }
}

