/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.jlog;

import java.util.GregorianCalendar;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.jlab.jlog.LogItem;
import org.jlab.jlog.exception.LogRuntimeException;
import org.jlab.jlog.util.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

abstract class AdminExtension {
    final LogItem item;
    final Document doc;
    final Element root;
    final XPath xpath;
    XPathExpression authorExpression;
    XPathExpression createdExpression;

    public AdminExtension(LogItem item) {
        this.item = item;
        this.doc = item.getDocument();
        this.root = item.getRoot();
        this.xpath = item.getXPath();
        try {
            this.authorExpression = this.xpath.compile("/*/Author/username");
            this.createdExpression = this.xpath.compile("/*/created");
        }
        catch (XPathExpressionException e) {
            throw new LogRuntimeException("Unable to construct XML XPath query", e);
        }
    }

    public void setAuthor(String author) throws LogRuntimeException {
        Element authorElement = null;
        try {
            authorElement = (Element)this.authorExpression.evaluate(this.doc, XPathConstants.NODE);
            if (authorElement == null) {
                throw new LogRuntimeException("Element not found in XML DOM.");
            }
        }
        catch (XPathExpressionException e) {
            throw new LogRuntimeException("Unable to evaluate XPath query on XML DOM.", e);
        }
        catch (ClassCastException e) {
            throw new LogRuntimeException("Unexpected node type in XML DOM.", e);
        }
        authorElement.setTextContent(author);
    }

    public void setCreated(GregorianCalendar created) throws LogRuntimeException {
        if (created == null) {
            created = new GregorianCalendar();
        }
        Element createdElement = null;
        try {
            createdElement = (Element)this.createdExpression.evaluate(this.doc, XPathConstants.NODE);
            if (createdElement == null) {
                throw new LogRuntimeException("Element not found in XML DOM.");
            }
        }
        catch (XPathExpressionException e) {
            throw new LogRuntimeException("Unable to evaluate XPath query on XML DOM.", e);
        }
        catch (ClassCastException e) {
            throw new LogRuntimeException("Unexpected node type in XML DOM.", e);
        }
        createdElement.setTextContent(XMLUtil.toXMLFormat(created));
    }

    public void setLogNumber(long lognumber) throws LogRuntimeException {
        this.item.setLogNumber(lognumber);
    }
}

