/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.jlog;

import java.util.Properties;
import org.jlab.jlog.Body;
import org.jlab.jlog.Library;
import org.jlab.jlog.LogItem;
import org.jlab.jlog.exception.LogRuntimeException;

public class Comment
extends LogItem {
    public Comment(long lognumber, String content) throws LogRuntimeException {
        this(lognumber, new Body(Body.ContentType.TEXT, content));
    }

    public Comment(long lognumber, String content, Body.ContentType type) throws LogRuntimeException {
        this(lognumber, new Body(type, content));
    }

    public Comment(long lognumber, Body body) throws LogRuntimeException {
        super("Comment");
        this.setLogNumber(lognumber);
        this.setBody(body);
    }

    @Override
    String getSchemaURL() throws LogRuntimeException {
        Properties props = Library.getConfiguration();
        String url = props.getProperty("COMMENT_SCHEMA_URL");
        if (url == null) {
            throw new LogRuntimeException("Property COMMENT_SCHEMA_URL not found.");
        }
        return url;
    }
}

