/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.jlog;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.jlab.jlog.exception.LogRuntimeException;

public final class Library {
    private static final Properties defaultConfiguration;
    private static Properties userConfiguration;
    private static final Properties release;

    private Library() {
    }

    public static Properties getConfiguration() {
        return userConfiguration;
    }

    public static void setConfiguration(Properties configuration) {
        userConfiguration = configuration;
    }

    public static String getVersion() {
        return release.getProperty("VERSION");
    }

    public static String getReleaseDate() {
        return release.getProperty("RELEASE_DATE");
    }

    static {
        try (InputStream defaultIn = Library.class.getClassLoader().getResourceAsStream("jlog-default.properties");
             InputStream releaseIn = Library.class.getClassLoader().getResourceAsStream("release.properties");){
            defaultConfiguration = new Properties();
            release = new Properties();
            defaultConfiguration.load(defaultIn);
            release.load(releaseIn);
        }
        catch (IOException e) {
            throw new LogRuntimeException("Unable to load properties.", e);
        }
        userConfiguration = new Properties(defaultConfiguration);
        String home = System.getProperty("user.home");
        File userPropsFile = new File(home + "/jlog.properties");
        try (FileInputStream userIn2 = new FileInputStream(userPropsFile);){
            userConfiguration.load(userIn2);
        }
        catch (FileNotFoundException userIn2) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

