/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.jlog;

import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.jlab.jlog.Body;
import org.jlab.jlog.Library;
import org.jlab.jlog.LogItem;
import org.jlab.jlog.ProblemReport;
import org.jlab.jlog.ProblemReportType;
import org.jlab.jlog.Reference;
import org.jlab.jlog.exception.AttachmentSizeException;
import org.jlab.jlog.exception.InvalidXMLException;
import org.jlab.jlog.exception.LogException;
import org.jlab.jlog.exception.LogIOException;
import org.jlab.jlog.exception.LogRuntimeException;
import org.jlab.jlog.exception.MalformedXMLException;
import org.jlab.jlog.exception.SchemaUnavailableException;
import org.jlab.jlog.util.IOUtil;
import org.jlab.jlog.util.SecurityUtil;
import org.jlab.jlog.util.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class LogEntry
extends LogItem {
    final XPathExpression titleExpression;
    final XPathExpression logbooksExpression;
    final XPathExpression logbookListExpression;
    final XPathExpression entrymakersExpression;
    final XPathExpression usernameListExpression;
    final XPathExpression stickyExpression;
    final XPathExpression tagsExpression;
    final XPathExpression tagListExpression;
    final XPathExpression referencesExpression;
    final XPathExpression revisionReasonExpression;
    final XPathExpression problemReportExpression;

    public LogEntry(String title, String books) throws LogRuntimeException {
        super("Logentry");
        try {
            this.titleExpression = this.xpath.compile("/Logentry/title");
            this.logbooksExpression = this.xpath.compile("/Logentry/Logbooks");
            this.logbookListExpression = this.xpath.compile("/Logentry/Logbooks/logbook");
            this.entrymakersExpression = this.xpath.compile("/Logentry/Entrymakers");
            this.usernameListExpression = this.xpath.compile("/Logentry/Entrymakers/Entrymaker/username");
            this.stickyExpression = this.xpath.compile("/Logentry/sticky");
            this.tagsExpression = this.xpath.compile("/Logentry/Tags");
            this.tagListExpression = this.xpath.compile("/Logentry/Tags/tag");
            this.referencesExpression = this.xpath.compile("/Logentry/References");
            this.revisionReasonExpression = this.xpath.compile("/Logentry/revision_reason");
            this.problemReportExpression = this.xpath.compile("/Logentry/ProblemReport");
        }
        catch (XPathExpressionException e) {
            throw new LogRuntimeException("Unable to construct XML XPath query", e);
        }
        XMLUtil.appendElementWithText(this.doc, this.root, "title", title);
        Element logbooks = this.doc.createElement("Logbooks");
        this.root.appendChild(logbooks);
        XMLUtil.appendCommaDelimitedElementsWithText(this.doc, logbooks, "logbook", books);
    }

    public LogEntry(String filePath) throws SchemaUnavailableException, MalformedXMLException, InvalidXMLException, LogIOException, AttachmentSizeException, LogRuntimeException {
        try {
            this.titleExpression = this.xpath.compile("/Logentry/title");
            this.logbooksExpression = this.xpath.compile("/Logentry/Logbooks");
            this.logbookListExpression = this.xpath.compile("/Logentry/Logbooks/logbook");
            this.entrymakersExpression = this.xpath.compile("/Logentry/Entrymakers");
            this.usernameListExpression = this.xpath.compile("/Logentry/Entrymakers/Entrymaker/username");
            this.stickyExpression = this.xpath.compile("/Logentry/sticky");
            this.tagsExpression = this.xpath.compile("/Logentry/Tags");
            this.tagListExpression = this.xpath.compile("/Logentry/Tags/tag");
            this.referencesExpression = this.xpath.compile("/Logentry/References");
            this.revisionReasonExpression = this.xpath.compile("/Logentry/revision_reason");
            this.problemReportExpression = this.xpath.compile("/Logentry/ProblemReport");
        }
        catch (XPathExpressionException e) {
            throw new LogRuntimeException("Unable to construct XML XPath query", e);
        }
        this.parse(filePath);
        this.checkAndTallyAttachmentSize();
    }

    private void parse(String filePath) throws MalformedXMLException, LogIOException {
        Properties props = Library.getConfiguration();
        boolean ignoreServerCert = "true".equals(props.getProperty("IGNORE_SERVER_CERT_ERRORS"));
        try {
            if (ignoreServerCert) {
                try {
                    SecurityUtil.disableServerCertificateCheck();
                }
                catch (KeyManagementException | NoSuchAlgorithmException e) {
                    throw new LogRuntimeException("Unable to disable server certificate check", e);
                }
            }
            this.doc = this.builder.parse(filePath);
            this.root = this.doc.getDocumentElement();
            SecurityUtil.enableServerCertificateCheck();
        }
        catch (SAXException e) {
            throw new MalformedXMLException("File is not well formed XML.", e);
        }
        catch (IOException e) {
            throw new LogIOException("Unable to parse XML file.", e);
        }
        finally {
            SecurityUtil.enableServerCertificateCheck();
        }
    }

    public void setProblemReport(ProblemReport report) {
        Element problemReportElement = null;
        try {
            problemReportElement = (Element)this.problemReportExpression.evaluate(this.doc, XPathConstants.NODE);
        }
        catch (XPathExpressionException e) {
            throw new LogRuntimeException("Unable to evaluate XPath query on XML DOM.", e);
        }
        catch (ClassCastException e) {
            throw new LogRuntimeException("Unexpected node type in XML DOM.", e);
        }
        if (report == null) {
            if (problemReportElement == null) {
                this.doc.removeChild(problemReportElement);
            }
            return;
        }
        if (problemReportElement == null) {
            problemReportElement = this.doc.createElement("ProblemReport");
            this.root.appendChild(problemReportElement);
        }
        problemReportElement.setAttribute("type", report.getType().name());
        Element needsAttentionElement = XMLUtil.getChildElementByName(problemReportElement, "needs_attention");
        if (needsAttentionElement == null) {
            needsAttentionElement = this.doc.createElement("needs_attention");
            problemReportElement.appendChild(needsAttentionElement);
        }
        needsAttentionElement.setTextContent(report.isNeedsAttention() ? "1" : "0");
        Element systemIdElement = XMLUtil.getChildElementByName(problemReportElement, "system_id");
        if (systemIdElement == null) {
            systemIdElement = this.doc.createElement("system_id");
            problemReportElement.appendChild(systemIdElement);
        }
        systemIdElement.setTextContent(String.valueOf(report.getSystemId()));
        Element groupIdElement = XMLUtil.getChildElementByName(problemReportElement, "group_id");
        if (groupIdElement == null) {
            groupIdElement = this.doc.createElement("group_id");
            problemReportElement.appendChild(groupIdElement);
        }
        groupIdElement.setTextContent(String.valueOf(report.getGroupId()));
        Element componentsElement = XMLUtil.getChildElementByName(problemReportElement, "Components");
        if (report.getComponentId() == null) {
            if (componentsElement != null) {
                problemReportElement.removeChild(componentsElement);
            }
        } else {
            Element componentIdElement;
            if (componentsElement == null) {
                componentsElement = this.doc.createElement("Components");
                problemReportElement.appendChild(componentsElement);
            }
            if ((componentIdElement = XMLUtil.getChildElementByName(componentsElement, "component_id")) == null) {
                componentIdElement = this.doc.createElement("component_id");
                componentsElement.appendChild(componentIdElement);
            }
            componentIdElement.setTextContent(String.valueOf(report.getComponentId()));
        }
    }

    public ProblemReport getProblemReport() {
        Element problemReportElement = null;
        ProblemReport report = null;
        try {
            problemReportElement = (Element)this.problemReportExpression.evaluate(this.doc, XPathConstants.NODE);
        }
        catch (XPathExpressionException e) {
            throw new LogRuntimeException("Unable to evaluate XPath query on XML DOM.", e);
        }
        catch (ClassCastException e) {
            throw new LogRuntimeException("Unexpected node type in XML DOM.", e);
        }
        if (problemReportElement != null) {
            Element componentIdElement;
            int groupId;
            int systemId;
            ProblemReportType type = ProblemReportType.valueOf(problemReportElement.getAttribute("type"));
            Element needsAttentionElement = XMLUtil.getChildElementByName(problemReportElement, "needs_attention");
            if (needsAttentionElement == null) {
                throw new LogRuntimeException("Unexpected XML DOM structure; ProblemReport needsAttention element missing.");
            }
            boolean needsAttention = needsAttentionElement.getTextContent().equals("1");
            Element systemIdElement = XMLUtil.getChildElementByName(problemReportElement, "system_id");
            if (systemIdElement == null) {
                throw new LogRuntimeException("Unexpected XML DOM structure; ProblemReport system_id element missing.");
            }
            try {
                systemId = Integer.parseInt(systemIdElement.getTextContent());
            }
            catch (NumberFormatException e) {
                throw new LogRuntimeException("Unexpected XML DOM structure; ProblemReport system_id value is not an integer or is out-of-range", e);
            }
            Element groupIdElement = XMLUtil.getChildElementByName(problemReportElement, "group_id");
            if (groupIdElement == null) {
                throw new LogRuntimeException("Unexpected XML DOM structure; ProblemReport group_id element missing.");
            }
            try {
                groupId = Integer.parseInt(groupIdElement.getTextContent());
            }
            catch (NumberFormatException e) {
                throw new LogRuntimeException("Unexpected XML DOM structure; ProblemReport group_id value is not an integer or is out-of-range", e);
            }
            Element componentsElement = XMLUtil.getChildElementByName(problemReportElement, "Components");
            Integer componentId = null;
            if (componentsElement != null && (componentIdElement = XMLUtil.getChildElementByName(componentsElement, "component_id")) != null) {
                try {
                    componentId = Integer.parseInt(componentIdElement.getTextContent());
                }
                catch (NumberFormatException e) {
                    throw new LogRuntimeException("Unexpected XML DOM structure; ProblemReport component_id value is not an integer or is out-of-range", e);
                }
            }
            report = new ProblemReport(type, needsAttention, systemId, groupId, componentId);
        }
        return report;
    }

    public static LogEntry getLogEntry(long lognumber, String reason) throws SchemaUnavailableException, MalformedXMLException, InvalidXMLException, LogIOException, AttachmentSizeException, LogRuntimeException {
        String filePath = LogEntry.buildHttpGetUrl(lognumber);
        LogEntry entry = new LogEntry(filePath);
        entry.setRevisionReason(reason);
        return entry;
    }

    static String buildHttpGetUrl(long lognumber) throws LogRuntimeException {
        StringBuilder strBuilder = new StringBuilder();
        Properties props = Library.getConfiguration();
        String fetchURL = props.getProperty("FETCH_URL");
        if (fetchURL == null) {
            throw new LogRuntimeException("Property FETCH_URL not found.");
        }
        strBuilder.append(fetchURL);
        if (!fetchURL.endsWith("/")) {
            strBuilder.append("/");
        }
        strBuilder.append(lognumber);
        strBuilder.append("/xml");
        return strBuilder.toString();
    }

    void setRevisionReason(String reason) throws LogRuntimeException {
        Element revisionReasonElement = null;
        try {
            revisionReasonElement = (Element)this.revisionReasonExpression.evaluate(this.doc, XPathConstants.NODE);
        }
        catch (XPathExpressionException e) {
            throw new LogRuntimeException("Unable to evaluate XPath query on XML DOM.", e);
        }
        catch (ClassCastException e) {
            throw new LogRuntimeException("Unexpected node type in XML DOM.", e);
        }
        if (revisionReasonElement == null) {
            revisionReasonElement = this.doc.createElement("revision_reason");
            this.root.appendChild(revisionReasonElement);
        }
        revisionReasonElement.setTextContent(reason);
    }

    public void addLogboks(String[] books) throws LogRuntimeException {
        this.addLogbooks(IOUtil.arrayToCSV(books));
    }

    public void addLogbooks(String books) throws LogRuntimeException {
        if (books == null || books.isEmpty()) {
            return;
        }
        Element logbooksElement = null;
        try {
            logbooksElement = (Element)this.logbooksExpression.evaluate(this.doc, XPathConstants.NODE);
            if (logbooksElement == null) {
                throw new LogRuntimeException("Element not found in XML DOM.");
            }
        }
        catch (XPathExpressionException e) {
            throw new LogRuntimeException("Unable to evaluate XPath query on XML DOM.", e);
        }
        catch (ClassCastException e) {
            throw new LogRuntimeException("Unexpected node type in XML DOM.", e);
        }
        XMLUtil.appendCommaDelimitedElementsWithText(this.doc, logbooksElement, "logbook", books);
    }

    public void setLogbooks(String[] books) throws LogRuntimeException {
        this.setLogbooks(IOUtil.arrayToCSV(books));
    }

    public void setLogbooks(String books) throws LogRuntimeException {
        if (books == null) {
            books = "";
        }
        Element logbooksElement = null;
        try {
            logbooksElement = (Element)this.logbooksExpression.evaluate(this.doc, XPathConstants.NODE);
            if (logbooksElement == null) {
                throw new LogRuntimeException("Element not found in XML DOM.");
            }
        }
        catch (XPathExpressionException e) {
            throw new LogRuntimeException("Unable to evaluate XPath query on XML DOM.", e);
        }
        catch (ClassCastException e) {
            throw new LogRuntimeException("Unexpected node type in XML DOM.", e);
        }
        XMLUtil.removeChildren(logbooksElement);
        XMLUtil.appendCommaDelimitedElementsWithText(this.doc, logbooksElement, "logbook", books);
    }

    public String getLogbooksCSV() throws LogRuntimeException {
        return IOUtil.arrayToCSV(this.getLogbooks());
    }

    public String[] getLogbooks() throws LogRuntimeException {
        NodeList logbookElements = null;
        try {
            logbookElements = (NodeList)this.logbookListExpression.evaluate(this.doc, XPathConstants.NODESET);
            if (logbookElements == null) {
                throw new LogRuntimeException("Element not found in XML DOM.");
            }
        }
        catch (XPathExpressionException e) {
            throw new LogRuntimeException("Unable to evaluate XPath query on XML DOM.", e);
        }
        catch (ClassCastException e) {
            throw new LogRuntimeException("Unexpected node type in XML DOM.", e);
        }
        return XMLUtil.buildArrayFromText(logbookElements);
    }

    public void addTags(String[] tags) throws LogRuntimeException {
        this.addTags(IOUtil.arrayToCSV(tags));
    }

    public void addTags(String tags) throws LogRuntimeException {
        if (tags == null || tags.isEmpty()) {
            return;
        }
        Element tagsElement = null;
        try {
            tagsElement = (Element)this.tagsExpression.evaluate(this.doc, XPathConstants.NODE);
        }
        catch (XPathExpressionException e) {
            throw new LogRuntimeException("Unable to evaluate XPath query on XML DOM.", e);
        }
        catch (ClassCastException e) {
            throw new LogRuntimeException("Unexpected node type in XML DOM.", e);
        }
        if (tagsElement == null) {
            tagsElement = this.doc.createElement("Tags");
            this.root.appendChild(tagsElement);
        }
        XMLUtil.appendCommaDelimitedElementsWithText(this.doc, tagsElement, "tag", tags);
    }

    public void setTags(String[] tags) throws LogRuntimeException {
        this.setTags(IOUtil.arrayToCSV(tags));
    }

    public void setTags(String tags) throws LogRuntimeException {
        Element tagsElement = null;
        try {
            tagsElement = (Element)this.tagsExpression.evaluate(this.doc, XPathConstants.NODE);
        }
        catch (XPathExpressionException e) {
            throw new LogRuntimeException("Unable to evaluate XPath query on XML DOM.", e);
        }
        catch (ClassCastException e) {
            throw new LogRuntimeException("Unexpected node type in XML DOM.", e);
        }
        if (tagsElement == null) {
            if (tags != null && !tags.isEmpty()) {
                tagsElement = this.doc.createElement("Tags");
                this.root.appendChild(tagsElement);
            }
        } else {
            XMLUtil.removeChildren(tagsElement);
        }
        if (tags != null && !tags.isEmpty()) {
            XMLUtil.appendCommaDelimitedElementsWithText(this.doc, tagsElement, "tag", tags);
        }
    }

    public String getTagsCSV() throws LogRuntimeException {
        return IOUtil.arrayToCSV(this.getTags());
    }

    public String[] getTags() throws LogRuntimeException {
        NodeList tagElements = null;
        try {
            tagElements = (NodeList)this.tagListExpression.evaluate(this.doc, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            throw new LogRuntimeException("Unable to evaluate XPath query on XML DOM.", e);
        }
        catch (ClassCastException e) {
            throw new LogRuntimeException("Unexpected node type in XML DOM.", e);
        }
        String[] tags = tagElements != null ? XMLUtil.buildArrayFromText(tagElements) : new String[]{};
        return tags;
    }

    public void addReference(Reference ref) throws LogRuntimeException {
        if (ref == null) {
            return;
        }
        Element referencesElement = null;
        try {
            referencesElement = (Element)this.referencesExpression.evaluate(this.doc, XPathConstants.NODE);
        }
        catch (XPathExpressionException e) {
            throw new LogRuntimeException("Unable to evaluate XPath query on XML DOM.", e);
        }
        catch (ClassCastException e) {
            throw new LogRuntimeException("Unexpected node type in XML DOM.", e);
        }
        if (referencesElement == null) {
            referencesElement = this.doc.createElement("References");
            this.root.appendChild(referencesElement);
        }
        Element refElement = this.doc.createElement("reference");
        referencesElement.appendChild(refElement);
        refElement.setAttribute("type", ref.getType());
        refElement.setTextContent(ref.getId());
    }

    public Reference[] getReferences() throws LogRuntimeException {
        ArrayList<Reference> references = new ArrayList<Reference>();
        Element referencesElement = null;
        try {
            referencesElement = (Element)this.referencesExpression.evaluate(this.doc, XPathConstants.NODE);
        }
        catch (XPathExpressionException e) {
            throw new LogRuntimeException("Unable to evaluate XPath query on XML DOM.", e);
        }
        catch (ClassCastException e) {
            throw new LogRuntimeException("Unexpected node type in XML DOM.", e);
        }
        if (referencesElement != null) {
            NodeList children = referencesElement.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                if (!(children.item(i) instanceof Element)) {
                    throw new LogRuntimeException("Unexpected node type in XML DOM; expected reference element.");
                }
                Element refElement = (Element)children.item(i);
                String type = refElement.getAttribute("type");
                String id = refElement.getTextContent();
                references.add(new Reference(type, id));
            }
        }
        return references.toArray(new Reference[0]);
    }

    public void deleteReferences() throws LogRuntimeException {
        Element referencesElement = null;
        try {
            referencesElement = (Element)this.referencesExpression.evaluate(this.doc, XPathConstants.NODE);
        }
        catch (XPathExpressionException e) {
            throw new LogRuntimeException("Unable to evaluate XPath query on XML DOM.", e);
        }
        catch (ClassCastException e) {
            throw new LogRuntimeException("Unexpected node type in XML DOM.", e);
        }
        if (referencesElement != null) {
            this.root.removeChild(referencesElement);
        }
    }

    public void setTitle(String title) throws LogRuntimeException {
        Element titleElement = null;
        try {
            titleElement = (Element)this.titleExpression.evaluate(this.doc, XPathConstants.NODE);
            if (titleElement == null) {
                throw new LogRuntimeException("Element not found in XML DOM.");
            }
        }
        catch (XPathExpressionException e) {
            throw new LogRuntimeException("Unable to evaluate XPath query on XML DOM.", e);
        }
        catch (ClassCastException e) {
            throw new LogRuntimeException("Unexpected node type in XML DOM.", e);
        }
        titleElement.setTextContent(title);
    }

    public String getTitle() throws LogRuntimeException {
        Element titleElement = null;
        try {
            titleElement = (Element)this.titleExpression.evaluate(this.doc, XPathConstants.NODE);
            if (titleElement == null) {
                throw new LogRuntimeException("Element not found in XML DOM.");
            }
        }
        catch (XPathExpressionException e) {
            throw new LogRuntimeException("Unable to evaluate XPath query on XML DOM.", e);
        }
        catch (ClassCastException e) {
            throw new LogRuntimeException("Unexpected node type in XML DOM.", e);
        }
        return titleElement.getTextContent();
    }

    public void addEntryMakers(String[] entrymakers) throws LogRuntimeException {
        this.addEntryMakers(IOUtil.arrayToCSV(entrymakers));
    }

    public void addEntryMakers(String entrymakers) throws LogRuntimeException {
        Element entrymakersElement = null;
        try {
            entrymakersElement = (Element)this.entrymakersExpression.evaluate(this.doc, XPathConstants.NODE);
        }
        catch (XPathExpressionException e) {
            throw new LogRuntimeException("Unable to evaluate XPath query on XML DOM.", e);
        }
        catch (ClassCastException e) {
            throw new LogRuntimeException("Unexpected node type in XML DOM.", e);
        }
        if (entrymakersElement == null) {
            entrymakersElement = this.doc.createElement("Entrymakers");
            this.root.appendChild(entrymakersElement);
        }
        XMLUtil.appendCommaDelimitedElementsWithGrandchildAndText(this.doc, entrymakersElement, "Entrymaker", "username", entrymakers);
    }

    public void setEntryMakers(String[] entrymakers) throws LogRuntimeException {
        this.setEntryMakers(IOUtil.arrayToCSV(entrymakers));
    }

    public void setEntryMakers(String entrymakers) throws LogRuntimeException {
        if (entrymakers == null) {
            entrymakers = "";
        }
        Element entrymakersElement = null;
        try {
            entrymakersElement = (Element)this.entrymakersExpression.evaluate(this.doc, XPathConstants.NODE);
        }
        catch (XPathExpressionException e) {
            throw new LogRuntimeException("Unable to evaluate XPath query on XML DOM.", e);
        }
        catch (ClassCastException e) {
            throw new LogRuntimeException("Unexpected node type in XML DOM.", e);
        }
        if (entrymakersElement == null) {
            entrymakersElement = this.doc.createElement("Entrymakers");
            this.root.appendChild(entrymakersElement);
        } else {
            XMLUtil.removeChildren(entrymakersElement);
        }
        XMLUtil.appendCommaDelimitedElementsWithGrandchildAndText(this.doc, entrymakersElement, "Entrymaker", "username", entrymakers);
    }

    public String getEntryMakersCSV() throws LogRuntimeException {
        return IOUtil.arrayToCSV(this.getEntryMakers());
    }

    public String[] getEntryMakers() throws LogRuntimeException {
        NodeList usernameElements = null;
        try {
            usernameElements = (NodeList)this.usernameListExpression.evaluate(this.doc, XPathConstants.NODESET);
            if (usernameElements == null) {
                throw new LogRuntimeException("Element not found in XML DOM.");
            }
        }
        catch (XPathExpressionException e) {
            throw new LogRuntimeException("Unable to evaluate XPath query on XML DOM.", e);
        }
        catch (ClassCastException e) {
            throw new LogRuntimeException("Unexpected node type in XML DOM.", e);
        }
        return XMLUtil.buildArrayFromText(usernameElements);
    }

    public void setSticky(boolean sticky) throws LogRuntimeException {
        Element stickyElement = null;
        try {
            stickyElement = (Element)this.stickyExpression.evaluate(this.doc, XPathConstants.NODE);
        }
        catch (XPathExpressionException e) {
            throw new LogRuntimeException("Unable to evaluate XPath query on XML DOM.", e);
        }
        catch (ClassCastException e) {
            throw new LogRuntimeException("Unexpected node type in XML DOM.", e);
        }
        if (stickyElement == null && sticky) {
            stickyElement = this.doc.createElement("sticky");
            this.root.appendChild(stickyElement);
            stickyElement.setTextContent("1");
        } else if (sticky) {
            stickyElement.setTextContent("1");
        } else {
            this.root.removeChild(stickyElement);
        }
    }

    public boolean isSticky() throws LogRuntimeException {
        boolean sticky = false;
        Element stickyElement = null;
        try {
            stickyElement = (Element)this.stickyExpression.evaluate(this.doc, XPathConstants.NODE);
        }
        catch (XPathExpressionException e) {
            throw new LogRuntimeException("Unable to evaluate XPath query on XML DOM.", e);
        }
        catch (ClassCastException e) {
            throw new LogRuntimeException("Unexpected node type in XML DOM.", e);
        }
        if (stickyElement != null) {
            String value = stickyElement.getTextContent();
            try {
                int number = Integer.parseInt(value);
                if (number != 0) {
                    sticky = true;
                }
            }
            catch (NumberFormatException e) {
                throw new LogRuntimeException("Unable to obtain sticky due to non-numeric format.", e);
            }
        }
        return sticky;
    }

    @Override
    String getSchemaURL() throws LogRuntimeException {
        Properties props = Library.getConfiguration();
        String url = props.getProperty("LOG_ENTRY_SCHEMA_URL");
        if (url == null) {
            throw new LogRuntimeException("Property LOG_ENTRY_SCHEMA_URL not found.");
        }
        return url;
    }

    public void setBody(String content) {
        this.setBody(new Body(Body.ContentType.TEXT, content));
    }

    public void setBody(String content, Body.ContentType type) {
        this.setBody(new Body(type, content));
    }

    @Override
    public void setBody(Body body) throws LogRuntimeException {
        super.setBody(body);
    }

    public static void main(String[] args) throws Exception {
        String body;
        Method[] methods;
        ArrayList<String> possibleArgs = new ArrayList<String>();
        for (Method method : methods = LogEntry.class.getDeclaredMethods()) {
            Parameter[] methodParams;
            if (!method.getName().startsWith("set") || (methodParams = method.getParameters()) == null || methodParams.length != 1 || !methodParams[0].getType().equals(String.class)) continue;
            char[] c = method.getName().substring(3).toCharArray();
            c[0] = Character.toLowerCase(c[0]);
            String arg = new String(c);
            if (possibleArgs.contains(arg)) continue;
            possibleArgs.add(arg);
        }
        Properties mainArgs = new Properties();
        if (args != null) {
            for (String arg : args) {
                int firstEquals;
                if ("-help".equals(arg)) {
                    System.out.println(String.format("Usage: %s {args}", LogEntry.class.getName()));
                    System.out.println("Possible args:");
                    System.out.println("  -help: Print this message");
                    System.out.println("The rest of these args must be supplied in the form: -argName=argValue");
                    for (String possibleArg : possibleArgs) {
                        System.out.println(String.format("  -%s (string): The log entry's %s", possibleArg, possibleArg));
                    }
                    System.out.println(String.format("  -bodyType (string): The content type of the log entry's body.  Can be one of the following: %s", Arrays.asList(Body.ContentType.values())));
                    System.out.println(String.format("  -pemFilePath (string): The location of the client certificate/private key combination (PEM file) used for submitting the log entry to the server.  If not supplied, the system will attempt to use this default: %s", LogEntry.getDefaultCertificatePath()));
                    System.out.println(String.format("  -allowQueue (boolean): If submission to the server fails, allow the log entry to be queued to: %s", LogEntry.getQueuePath()));
                    System.exit(0);
                }
                if ((firstEquals = arg.indexOf("=")) <= -1) continue;
                String argName = arg.substring(0, firstEquals);
                String argValue = arg.substring(firstEquals + 1);
                if (argName == null || argValue == null) continue;
                mainArgs.put(argName, argValue);
            }
        }
        String title = mainArgs.getProperty("-title");
        String logbooks = mainArgs.getProperty("-logbooks");
        if (title == null || logbooks == null) {
            throw new LogException("Title and logbooks are required");
        }
        LogEntry entry = new LogEntry(title, logbooks.toUpperCase());
        String entryMakers = mainArgs.getProperty("-entryMakers");
        if (entryMakers != null) {
            entry.addEntryMakers(entryMakers);
        }
        if ((body = mainArgs.getProperty("-body")) != null) {
            String bodyType = mainArgs.getProperty("-bodyType");
            if (bodyType != null) {
                entry.setBody(body, Body.ContentType.valueOf(bodyType));
            } else {
                entry.setBody(body);
            }
        }
        String pemFilePath = mainArgs.getProperty("-pemFilePath");
        Boolean allowQueue = Boolean.parseBoolean(mainArgs.getProperty("-allowQueue"));
        Long entryId = null;
        if (pemFilePath != null) {
            entry.setClientCertificatePath(pemFilePath, true);
        }
        entryId = allowQueue != false ? entry.submit() : entry.submitNow();
        System.out.println(entryId);
    }
}

