/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.jlog;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.FileNameMap;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Properties;
import javax.naming.InvalidNameException;
import javax.net.ssl.HttpsURLConnection;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.jlab.jlog.Attachment;
import org.jlab.jlog.Body;
import org.jlab.jlog.Library;
import org.jlab.jlog.exception.AttachmentSizeException;
import org.jlab.jlog.exception.InvalidXMLException;
import org.jlab.jlog.exception.LogCertificateException;
import org.jlab.jlog.exception.LogException;
import org.jlab.jlog.exception.LogIOException;
import org.jlab.jlog.exception.LogRuntimeException;
import org.jlab.jlog.exception.SchemaUnavailableException;
import org.jlab.jlog.util.IOUtil;
import org.jlab.jlog.util.SecurityUtil;
import org.jlab.jlog.util.SystemUtil;
import org.jlab.jlog.util.XMLUtil;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

abstract class LogItem {
    private static final String PEM_FILE_NAME = ".elogcert";
    private static final FileNameMap mimeMap = URLConnection.getFileNameMap();
    LogException submitException = null;
    Document doc;
    Element root;
    DatatypeFactory typeFactory;
    DocumentBuilder builder;
    XPath xpath;
    XPathExpression lognumberExpression;
    XPathExpression lognumberTextExpression;
    XPathExpression createdExpression;
    XPathExpression bodyExpression;
    XPathExpression attachmentsExpression;
    XPathExpression authorTextExpression;
    XPathExpression notificationsExpression;
    XPathExpression notificationListExpression;
    XPathExpression responseStatusExpression;
    XPathExpression responseMessageExpression;
    XPathExpression responseLognumberExpression;
    long totalAttachmentBytes = 0L;

    public LogItem() throws LogRuntimeException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            this.builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new LogRuntimeException("Unable to obtain XML document builder.", e);
        }
        try {
            this.typeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new LogRuntimeException("Unable to obtain XML datatype factory.", e);
        }
        XPathFactory xpathFactory = XPathFactory.newInstance();
        this.xpath = xpathFactory.newXPath();
        try {
            this.lognumberExpression = this.xpath.compile("/*/lognumber");
            this.lognumberTextExpression = this.xpath.compile("/*/lognumber/text()");
            this.createdExpression = this.xpath.compile("/*/created");
            this.bodyExpression = this.xpath.compile("/*/body");
            this.attachmentsExpression = this.xpath.compile("/*/Attachments");
            this.authorTextExpression = this.xpath.compile("/*/Author/username/text()");
            this.notificationsExpression = this.xpath.compile("/*/Notifications");
            this.notificationListExpression = this.xpath.compile("/*/Notifications/email");
            this.responseStatusExpression = this.xpath.compile("/Response/@stat");
            this.responseMessageExpression = this.xpath.compile("/Response/msg/text()");
            this.responseLognumberExpression = this.xpath.compile("/Response/lognumber");
        }
        catch (XPathExpressionException e) {
            throw new LogRuntimeException("Unable to construct XML XPath query", e);
        }
    }

    public LogItem(String rootTagName) throws LogRuntimeException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            this.builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new LogRuntimeException("Unable to obtain XML document builder.", e);
        }
        try {
            this.typeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new LogRuntimeException("Unable to obtain XML datatype factory.", e);
        }
        XPathFactory xpathFactory = XPathFactory.newInstance();
        this.xpath = xpathFactory.newXPath();
        try {
            this.lognumberExpression = this.xpath.compile("/*/lognumber");
            this.lognumberTextExpression = this.xpath.compile("/*/lognumber/text()");
            this.createdExpression = this.xpath.compile("/*/created");
            this.bodyExpression = this.xpath.compile("/*/body");
            this.attachmentsExpression = this.xpath.compile("/*/Attachments");
            this.authorTextExpression = this.xpath.compile("/*/Author/username/text()");
            this.notificationsExpression = this.xpath.compile("/*/Notifications");
            this.notificationListExpression = this.xpath.compile("/*/Notifications/email");
            this.responseStatusExpression = this.xpath.compile("/Response/@stat");
            this.responseMessageExpression = this.xpath.compile("/Response/msg/text()");
            this.responseLognumberExpression = this.xpath.compile("/Response/lognumber");
        }
        catch (XPathExpressionException e) {
            throw new LogRuntimeException("Unable to construct XML XPath query", e);
        }
        this.doc = this.builder.newDocument();
        this.root = this.doc.createElement(rootTagName);
        this.doc.appendChild(this.root);
        XMLUtil.appendElementWithText(this.doc, this.root, "created", XMLUtil.toXMLFormat(new GregorianCalendar()));
        Element authorElement = this.doc.createElement("Author");
        this.root.appendChild(authorElement);
        XMLUtil.appendElementWithText(this.doc, authorElement, "username", System.getProperty("user.name"));
    }

    void checkAttachmentSize(long length) throws AttachmentSizeException, LogRuntimeException {
        Properties props = Library.getConfiguration();
        String singleFileLimitStr = props.getProperty("ATTACH_SINGLE_MAX_BYTES");
        if (singleFileLimitStr == null) {
            throw new LogRuntimeException("Property ATTACH_SINGLE_MAX_BYTES not found.");
        }
        long singleFileLimit = 0L;
        try {
            singleFileLimit = Long.parseLong(singleFileLimitStr);
        }
        catch (NumberFormatException e) {
            throw new LogRuntimeException("ATTACH_SINGLE_MAX_BYTES must be a number.", e);
        }
        if (length > singleFileLimit) {
            throw new AttachmentSizeException("The maximim attachment file size of " + singleFileLimit / 1024L / 1024L + " MB has been exceeded.");
        }
        String totalFileLimitStr = props.getProperty("ATTACH_TOTAL_MAX_BYTES");
        if (totalFileLimitStr == null) {
            throw new LogRuntimeException("Property ATTACH_TOTAL_MAX_BYTES not found.");
        }
        long totalFileLimit = 0L;
        try {
            totalFileLimit = Long.parseLong(totalFileLimitStr);
        }
        catch (NumberFormatException e) {
            throw new LogRuntimeException("ATTACH_TOTAL_MAX_BYTES must be a number.", e);
        }
        if (length + this.totalAttachmentBytes > totalFileLimit) {
            throw new AttachmentSizeException("The maximim total size for all attachments of " + totalFileLimit / 1024L / 1024L + " MB has been exceeded.");
        }
    }

    long getAttachmentLength(Attachment attachment) throws LogIOException {
        long length = 0L;
        String prefix = "jlogattachment";
        String suffix = ".tmp";
        File file = null;
        Properties props = Library.getConfiguration();
        boolean ignoreServerCert = "true".equals(props.getProperty("IGNORE_SERVER_CERT_ERRORS"));
        try {
            if (ignoreServerCert) {
                SecurityUtil.disableServerCertificateCheck();
            }
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new LogRuntimeException("Unable to disable server certificate check", e);
        }
        try (InputStream in = attachment.getData();){
            file = File.createTempFile(prefix, suffix);
            try (FileOutputStream out = new FileOutputStream(file);){
                IOUtil.copy(in, out);
            }
        }
        catch (IOException e) {
            try {
                throw new LogIOException("Unable to write attachment to tmp directory for length measurement.", e);
            }
            catch (Throwable throwable) {
                IOUtil.deleteQuietly(file);
                SecurityUtil.enableServerCertificateCheck();
                throw throwable;
            }
        }
        IOUtil.deleteQuietly(file);
        SecurityUtil.enableServerCertificateCheck();
        return length;
    }

    void checkAndTallyAttachmentSize() throws AttachmentSizeException, LogIOException {
        Attachment[] attachments;
        for (Attachment attachment : attachments = this.getAttachments()) {
            long length = this.getAttachmentLength(attachment);
            this.checkAttachmentSize(length);
            this.totalAttachmentBytes += length;
        }
    }

    public void addAttachment(String filepath) throws AttachmentSizeException, LogIOException, LogRuntimeException {
        this.addAttachment(filepath, "", mimeMap.getContentTypeFor(filepath));
    }

    public void addAttachment(String filepath, String caption) throws AttachmentSizeException, LogIOException, LogRuntimeException {
        this.addAttachment(filepath, caption, mimeMap.getContentTypeFor(filepath));
    }

    public void addAttachment(String filepath, String caption, String mimeType) throws AttachmentSizeException, LogIOException, LogRuntimeException {
        String data = null;
        Element attachmentsElement = null;
        File file = new File(filepath);
        this.checkAttachmentSize(file.length());
        try {
            data = IOUtil.encodeBase64(IOUtil.fileToBytes(file));
            attachmentsElement = (Element)this.attachmentsExpression.evaluate(this.doc, XPathConstants.NODE);
        }
        catch (IOException e) {
            throw new LogIOException("Unable to access attachment file.", e);
        }
        catch (XPathExpressionException e) {
            throw new LogRuntimeException("Unable to evaluate XPath query on XML DOM.", e);
        }
        catch (ClassCastException e) {
            throw new LogRuntimeException("Unexpected node type in XML DOM.", e);
        }
        if (attachmentsElement == null) {
            attachmentsElement = this.doc.createElement("Attachments");
            this.root.appendChild(attachmentsElement);
        }
        Element attachmentElement = this.doc.createElement("Attachment");
        attachmentsElement.appendChild(attachmentElement);
        XMLUtil.appendElementWithText(this.doc, attachmentElement, "caption", caption);
        XMLUtil.appendElementWithText(this.doc, attachmentElement, "filename", file.getName());
        XMLUtil.appendElementWithText(this.doc, attachmentElement, "type", mimeType);
        Element dataElement = XMLUtil.appendElementWithText(this.doc, attachmentElement, "data", data);
        dataElement.setAttribute("encoding", "base64");
        this.totalAttachmentBytes += file.length();
    }

    public Attachment[] getAttachments() throws LogRuntimeException {
        ArrayList<Attachment> attachments = new ArrayList<Attachment>();
        Element attachmentsElement = null;
        try {
            attachmentsElement = (Element)this.attachmentsExpression.evaluate(this.doc, XPathConstants.NODE);
        }
        catch (XPathExpressionException e) {
            throw new LogRuntimeException("Unable to evaluate XPath query on XML DOM.", e);
        }
        catch (ClassCastException e) {
            throw new LogRuntimeException("Unexpected node type in XML DOM.", e);
        }
        if (attachmentsElement != null) {
            NodeList children = attachmentsElement.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                if (!(children.item(i) instanceof Element)) continue;
                attachments.add(new Attachment((Element)children.item(i)));
            }
        }
        return attachments.toArray(new Attachment[0]);
    }

    public void deleteAttachments() throws LogRuntimeException {
        Element attachmentsElement = null;
        try {
            attachmentsElement = (Element)this.attachmentsExpression.evaluate(this.doc, XPathConstants.NODE);
        }
        catch (XPathExpressionException e) {
            throw new LogRuntimeException("Unable to evaluate XPath query on XML DOM.", e);
        }
        catch (ClassCastException e) {
            throw new LogRuntimeException("Unexpected node type in XML DOM.", e);
        }
        if (attachmentsElement != null) {
            XMLUtil.removeChildren(attachmentsElement);
        }
        this.totalAttachmentBytes = 0L;
    }

    public void setEmailNotify(String addresses) throws LogRuntimeException {
        Element notificationsElement = null;
        try {
            notificationsElement = (Element)this.notificationsExpression.evaluate(this.doc, XPathConstants.NODE);
        }
        catch (XPathExpressionException e) {
            throw new LogRuntimeException("Unable to evaluate XPath query on XML DOM.", e);
        }
        catch (ClassCastException e) {
            throw new LogRuntimeException("Unexpected node type in XML DOM.", e);
        }
        if (notificationsElement == null) {
            if (addresses != null && !addresses.isEmpty()) {
                notificationsElement = this.doc.createElement("Notifications");
                this.root.appendChild(notificationsElement);
            }
        } else {
            XMLUtil.removeChildren(notificationsElement);
        }
        if (addresses != null && !addresses.isEmpty()) {
            XMLUtil.appendCommaDelimitedElementsWithText(this.doc, notificationsElement, "email", addresses);
        }
    }

    public void setEmailNotify(String[] addresses) throws LogRuntimeException {
        this.setEmailNotify(IOUtil.arrayToCSV(addresses));
    }

    public String getEmailNotifyCSV() throws LogRuntimeException {
        return IOUtil.arrayToCSV(this.getEmailNotify());
    }

    public String[] getEmailNotify() throws LogRuntimeException {
        NodeList notificationElements = null;
        try {
            notificationElements = (NodeList)this.notificationListExpression.evaluate(this.doc, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            throw new LogRuntimeException("Unable to evaluate XPath query on XML DOM.", e);
        }
        catch (ClassCastException e) {
            throw new LogRuntimeException("Unexpected node type in XML DOM.", e);
        }
        String[] addresses = notificationElements != null ? XMLUtil.buildArrayFromText(notificationElements) : new String[]{};
        return addresses;
    }

    public String getAuthor() throws LogRuntimeException {
        String author = null;
        try {
            author = (String)this.authorTextExpression.evaluate(this.doc, XPathConstants.STRING);
        }
        catch (XPathExpressionException e) {
            throw new LogRuntimeException("Unable to evaluate XPath query on XML DOM.", e);
        }
        catch (ClassCastException e) {
            throw new LogRuntimeException("Unexpected node type in XML DOM.", e);
        }
        return author;
    }

    void setLogNumber(long lognumber) throws LogRuntimeException {
        Element lognumberElement = null;
        try {
            lognumberElement = (Element)this.lognumberExpression.evaluate(this.doc, XPathConstants.NODE);
        }
        catch (XPathExpressionException e) {
            throw new LogRuntimeException("Unable to evaluate XPath query on XML DOM.", e);
        }
        catch (ClassCastException e) {
            throw new LogRuntimeException("Unexpected node type in XML DOM.", e);
        }
        if (lognumberElement == null) {
            lognumberElement = this.doc.createElement("lognumber");
            this.root.appendChild(lognumberElement);
        }
        lognumberElement.setTextContent(String.valueOf(lognumber));
    }

    public Long getLogNumber() throws LogRuntimeException {
        Long lognumber = null;
        String lognumberStr = null;
        try {
            lognumberStr = (String)this.lognumberTextExpression.evaluate(this.doc, XPathConstants.STRING);
        }
        catch (XPathExpressionException e) {
            throw new LogRuntimeException("Unable to evaluate XPath query on XML DOM.", e);
        }
        catch (ClassCastException e) {
            throw new LogRuntimeException("Unexpected node type in XML DOM.", e);
        }
        if (lognumberStr != null && !lognumberStr.isEmpty()) {
            try {
                lognumber = Long.parseLong(lognumberStr);
            }
            catch (NumberFormatException e) {
                throw new LogRuntimeException("Unable to obtain log number due to non-numeric format.", e);
            }
        }
        return lognumber;
    }

    public GregorianCalendar getCreated() throws LogRuntimeException {
        Element createdElement = null;
        try {
            createdElement = (Element)this.createdExpression.evaluate(this.doc, XPathConstants.NODE);
            if (createdElement == null) {
                throw new LogRuntimeException("Element not found in XML DOM.");
            }
        }
        catch (XPathExpressionException e) {
            throw new LogRuntimeException("Unable to evaluate XPath query on XML DOM.", e);
        }
        catch (ClassCastException e) {
            throw new LogRuntimeException("Unexpected node type in XML DOM.", e);
        }
        String createdStr = createdElement.getTextContent();
        return XMLUtil.toGregorianCalendar(createdStr);
    }

    public Body getBody() throws LogRuntimeException {
        Body body = null;
        Element bodyElement = null;
        try {
            bodyElement = (Element)this.bodyExpression.evaluate(this.doc, XPathConstants.NODE);
        }
        catch (XPathExpressionException e) {
            throw new LogRuntimeException("Unable to traverse XML DOM.", e);
        }
        if (bodyElement != null) {
            String content = bodyElement.getTextContent();
            String typeStr = bodyElement.getAttribute("type");
            Body.ContentType type = Body.ContentType.TEXT;
            if (typeStr != null && !typeStr.isEmpty()) {
                try {
                    type = Body.ContentType.valueOf(typeStr.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    throw new LogRuntimeException("Unexpected ContentType in XML body.", e);
                }
            }
            body = new Body(type, content);
        }
        return body;
    }

    void setBody(Body body) throws LogRuntimeException {
        if (body == null) {
            body = new Body(Body.ContentType.TEXT, "");
        }
        Element bodyElement = null;
        try {
            bodyElement = (Element)this.bodyExpression.evaluate(this.doc, XPathConstants.NODE);
        }
        catch (XPathExpressionException e) {
            throw new LogRuntimeException("Unable to traverse XML DOM.", e);
        }
        catch (ClassCastException e) {
            throw new LogRuntimeException("Unexpected node type in XML DOM.", e);
        }
        if (bodyElement != null) {
            this.root.removeChild(bodyElement);
        }
        if (body.getContent() != null && !body.getContent().isEmpty()) {
            bodyElement = this.doc.createElement("body");
            this.root.appendChild(bodyElement);
            if (body.getType() == Body.ContentType.HTML) {
                bodyElement.setAttribute("type", "html");
            }
            CDATASection data = this.doc.createCDATASection(body.getContent());
            bodyElement.appendChild(data);
        }
    }

    public String getXML() throws LogRuntimeException {
        String xml = null;
        try {
            xml = XMLUtil.getXML(this.doc);
        }
        catch (TransformerConfigurationException e) {
            throw new LogRuntimeException("Unable to obtain XML document transformer.", e);
        }
        catch (TransformerException e) {
            throw new LogRuntimeException("Unable to transform XML document.", e);
        }
        return xml;
    }

    abstract String getSchemaURL() throws LogRuntimeException;

    void validate() throws SchemaUnavailableException, InvalidXMLException, LogIOException {
        Schema schema = null;
        Properties props = Library.getConfiguration();
        boolean ignoreServerCert = "true".equals(props.getProperty("IGNORE_SERVER_CERT_ERRORS"));
        try {
            if (ignoreServerCert) {
                try {
                    SecurityUtil.disableServerCertificateCheck();
                }
                catch (KeyManagementException | NoSuchAlgorithmException e) {
                    throw new LogRuntimeException("Unable to disable server certificate check", e);
                }
            }
            URL schemaURL = new URL(this.getSchemaURL());
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            schema = factory.newSchema(schemaURL);
        }
        catch (MalformedURLException e) {
            throw new SchemaUnavailableException("Schema URL malformed.", e);
        }
        catch (SAXException e) {
            throw new SchemaUnavailableException("Unable to parse schema.", e);
        }
        finally {
            SecurityUtil.enableServerCertificateCheck();
        }
        Validator validator = schema.newValidator();
        DOMSource source = new DOMSource(this.doc);
        try {
            validator.validate(source);
        }
        catch (SAXException e) {
            throw new InvalidXMLException("The XML failed to validate against the schema.", e);
        }
        catch (IOException e) {
            throw new LogIOException("Unable to validate XML.", e);
        }
    }

    long parseServerResponse(InputStream is) throws LogIOException, LogRuntimeException {
        long id;
        try {
            Document response = this.builder.parse(is);
            String status = (String)this.responseStatusExpression.evaluate(response, XPathConstants.STRING);
            String message = (String)this.responseMessageExpression.evaluate(response, XPathConstants.STRING);
            String lognumberStr = (String)this.responseLognumberExpression.evaluate(response, XPathConstants.STRING);
            if (status == null || status.isEmpty()) {
                throw new LogIOException("Unrecognized Response from server.");
            }
            if (!"ok".equals(status)) {
                throw new LogIOException("Submission Failed: " + message);
            }
            id = Long.parseLong(lognumberStr);
        }
        catch (IOException e) {
            throw new LogIOException("Unable to parse response.", e);
        }
        catch (SAXException e) {
            throw new LogIOException("Unable to parse response.", e);
        }
        catch (XPathExpressionException e) {
            throw new LogRuntimeException("Unable to evaluate XPath query on XML DOM.", e);
        }
        catch (ClassCastException e) {
            throw new LogRuntimeException("Unexpected node type in XML DOM.", e);
        }
        catch (NumberFormatException e) {
            throw new LogIOException("Log number not found in response.", e);
        }
        return id;
    }

    long performHttpPutToServer() throws LogIOException, LogCertificateException, LogRuntimeException {
        long id;
        String pemFilePath = this.getClientCertificatePath();
        String xml = this.getXML();
        Properties props = Library.getConfiguration();
        boolean ignoreServerCert = "true".equals(props.getProperty("IGNORE_SERVER_CERT_ERRORS"));
        try {
            String putUrl = this.buildHttpPutUrl();
            URL url = new URL(putUrl);
            HttpsURLConnection con = (HttpsURLConnection)url.openConnection();
            con.setSSLSocketFactory(SecurityUtil.getClientCertSocketFactoryPEM(pemFilePath, !ignoreServerCert));
            con.setRequestMethod("PUT");
            con.setDoOutput(true);
            con.setChunkedStreamingMode(0);
            con.setRequestProperty("Expect", "100-Continue");
            con.connect();
            try (OutputStream out = con.getOutputStream();
                 OutputStreamWriter writer = new OutputStreamWriter(out, StandardCharsets.UTF_8);){
                writer.write(xml);
            }
            try (InputStream error = con.getErrorStream();){
                if (error != null) {
                    String errorMsg = IOUtil.streamToString(error, "UTF-8");
                    throw new IOException(errorMsg);
                }
            }
            try (InputStream is = con.getInputStream();){
                id = this.parseServerResponse(is);
            }
        }
        catch (MalformedURLException e) {
            throw new LogIOException("Invalid submission URL: check config file.", e);
        }
        catch (IOException e) {
            throw new LogIOException("Unable to submit to ELOG server.", e);
        }
        catch (ClassCastException e) {
            throw new LogIOException("Expected HTTP URL; check config file.", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new LogCertificateException("Invalid SSL certificate algorithm.", e);
        }
        catch (CertificateException e) {
            throw new LogCertificateException("Unable to obtain SSL connection due to certificate error.", e);
        }
        catch (KeyStoreException e) {
            throw new LogCertificateException("Unable to obtain SSL connection due to certificate error.", e);
        }
        catch (KeyManagementException e) {
            throw new LogCertificateException("Unable to obtain SSL connection due to certificate error.", e);
        }
        catch (UnrecoverableKeyException e) {
            throw new LogCertificateException("Unable to obtain SSL connection due to certificate error.", e);
        }
        catch (InvalidKeySpecException e) {
            throw new LogCertificateException("Unable to obtain SSL connection due to certificate error.", e);
        }
        return id;
    }

    Document getDocument() {
        return this.doc;
    }

    Element getRoot() {
        return this.root;
    }

    XPath getXPath() {
        return this.xpath;
    }

    String buildHttpPutUrl() throws LogRuntimeException {
        StringBuilder strBuilder = new StringBuilder();
        Properties props = Library.getConfiguration();
        String submitURL = props.getProperty("SUBMIT_URL");
        if (submitURL == null) {
            throw new LogRuntimeException("Property SUBMIT_URL not found.");
        }
        strBuilder.append(submitURL);
        if (!submitURL.endsWith("/")) {
            strBuilder.append("/");
        }
        strBuilder.append(this.generateXMLFilename());
        return strBuilder.toString();
    }

    public String getClientCertificatePath() {
        Properties props = Library.getConfiguration();
        String certificatePath = props.getProperty("CLIENT_CERTIFICATE_PATH");
        if (certificatePath == null || certificatePath.isEmpty()) {
            certificatePath = LogItem.getDefaultCertificatePath();
        }
        return certificatePath;
    }

    public void setClientCertificatePath(String certificatePath, boolean updateAuthor) throws LogException {
        Properties props = Library.getConfiguration();
        props.setProperty("CLIENT_CERTIFICATE_PATH", certificatePath);
        if (updateAuthor) {
            this.setAuthorToCertUser(certificatePath);
        }
    }

    private void setAuthorToCertUser(String certificatePath) throws LogException {
        try {
            Node authorNode;
            X509Certificate cert = SecurityUtil.fetchCertificateFromPEM(IOUtil.fileToBytes(new File(certificatePath)));
            String commonName = SecurityUtil.getCommonNameFromCertificate(cert);
            if (commonName != null && (authorNode = (Node)this.authorTextExpression.evaluate(this.doc, XPathConstants.NODE)) != null) {
                authorNode.setNodeValue(commonName);
            }
        }
        catch (IOException | CertificateException | InvalidNameException | XPathExpressionException e) {
            throw new LogException("Unable to set author to certificate user", e);
        }
    }

    static String getDefaultCertificatePath() {
        return new File(System.getProperty("user.home"), PEM_FILE_NAME).getAbsolutePath();
    }

    public long submit() throws InvalidXMLException, LogIOException {
        long id = 0L;
        try {
            id = this.performHttpPutToServer();
        }
        catch (Exception e) {
            this.submitException = e instanceof LogException ? (LogException)e : new LogException(e.getMessage(), e);
            this.queue();
        }
        return id;
    }

    public long submitNow() throws LogIOException, LogCertificateException, LogRuntimeException {
        return this.performHttpPutToServer();
    }

    String generateXMLFilename() {
        String hostname;
        StringBuilder filenameBuilder = new StringBuilder();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy_MM_dd_HHmmss_");
        String date = formatter.format(new Date());
        Integer pid = SystemUtil.getJVMProcessId();
        if (pid == null) {
            pid = 0;
        }
        if ((hostname = SystemUtil.getHostname()) == null) {
            hostname = "unknown";
        }
        int random = (int)(Math.random() * 10000.0);
        filenameBuilder.append(date);
        filenameBuilder.append(pid);
        filenameBuilder.append("_");
        filenameBuilder.append(hostname);
        filenameBuilder.append("_");
        filenameBuilder.append(random);
        filenameBuilder.append(".xml");
        return filenameBuilder.toString();
    }

    static String getQueuePath() {
        Properties props = Library.getConfiguration();
        String queuePath = props.getProperty("QUEUE_PATH");
        if (queuePath == null || queuePath.isEmpty()) {
            queuePath = SystemUtil.isWindows() ? props.getProperty("DEFAULT_WINDOWS_QUEUE_PATH") : props.getProperty("DEFAULT_UNIX_QUEUE_PATH");
        }
        if (queuePath == null || queuePath.isEmpty()) {
            throw new LogRuntimeException("The QUEUE_PATH property and the DEFAULT_-OS-_QUEUE_PATH property are both undefined.");
        }
        return queuePath;
    }

    public LogException whyQueued() {
        return this.submitException;
    }

    void queue() throws InvalidXMLException, LogIOException {
        String filename = this.generateXMLFilename();
        String filepath = new File(LogItem.getQueuePath(), filename).getAbsolutePath();
        this.queue(filepath);
    }

    void queue(String filepath) throws InvalidXMLException, LogIOException {
        String xml = this.getXML();
        try (FileOutputStream out = new FileOutputStream(filepath);
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8);){
            writer.write(xml);
        }
        catch (IOException e) {
            throw new LogIOException("Unable to write XML file to queue.", e);
        }
    }
}

