/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.jlog.util;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Base64;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class IOUtil {
    private static final Logger logger = Logger.getLogger(IOUtil.class.getName());

    private IOUtil() {
    }

    public static void closeQuietly(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Unable to close resource.", e);
            }
        }
    }

    public static void deleteQuietly(File file) {
        boolean success;
        if (file != null && !(success = file.delete())) {
            logger.log(Level.WARNING, "Unable to delete temporary file: {0}", file.getName());
        }
    }

    public static byte[] fileToBytes(File file) throws IOException {
        byte[] bytes = new byte[(int)file.length()];
        try (FileInputStream fis = new FileInputStream(file);
             DataInputStream dis = new DataInputStream(fis);){
            dis.readFully(bytes);
        }
        return bytes;
    }

    public static long copy(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[4096];
        long count = 0L;
        int n = 0;
        while (-1 != (n = in.read(buffer))) {
            out.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static String streamToString(InputStream is, String encoding) {
        String str = "";
        Scanner scan = new Scanner(is, encoding).useDelimiter("\\A");
        if (scan.hasNext()) {
            str = scan.next();
        }
        return str;
    }

    public static String arrayToCSV(String[] values) {
        StringBuilder builder = new StringBuilder();
        if (values != null && values.length > 0) {
            for (String s : values) {
                builder.append(s);
                builder.append(",");
            }
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }

    public static String[] csvToArray(String values) {
        return values.split("\\s*,\\s*");
    }

    public static String encodeBase64(byte[] data) {
        return Base64.getMimeEncoder().encodeToString(data);
    }

    public static byte[] decodeBase64(String data) {
        return Base64.getMimeDecoder().decode(data);
    }
}

