/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.jlog.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.jlab.jlog.util.IOUtil;

public final class SecurityUtil {
    private static final Logger logger = Logger.getLogger(SecurityUtil.class.getName());
    private static final SSLSocketFactory defaultFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
    private static final HostnameVerifier defaultVerifier = HttpsURLConnection.getDefaultHostnameVerifier();

    private SecurityUtil() {
    }

    public static void disableServerCertificateCheck() throws NoSuchAlgorithmException, KeyManagementException {
        SSLSocketFactory factory = SecurityUtil.getTrustySocketFactory();
        HttpsURLConnection.setDefaultSSLSocketFactory(factory);
        HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String s, SSLSession sslSession) {
                return true;
            }
        });
    }

    public static void enableServerCertificateCheck() {
        HttpsURLConnection.setDefaultSSLSocketFactory(defaultFactory);
        HttpsURLConnection.setDefaultHostnameVerifier(defaultVerifier);
    }

    public static SSLSocketFactory getTrustySocketFactory() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(null, new TrustManager[]{new TrustyTrustManager()}, null);
        return context.getSocketFactory();
    }

    public static SSLSocketFactory getClientCertSocketFactoryPEM(String pemPath, boolean verifyPeer) throws NoSuchAlgorithmException, FileNotFoundException, IOException, KeyStoreException, CertificateException, UnrecoverableKeyException, KeyManagementException, InvalidKeySpecException {
        SSLContext context = SSLContext.getInstance("TLS");
        byte[] certAndKey = IOUtil.fileToBytes(new File(pemPath));
        X509Certificate cert = SecurityUtil.fetchCertificateFromPEM(certAndKey);
        RSAPrivateKey key = SecurityUtil.fetchPrivateKeyFromPEM(certAndKey);
        KeyStore keystore = KeyStore.getInstance("JKS");
        keystore.load(null);
        keystore.setCertificateEntry("cert-alias", cert);
        keystore.setKeyEntry("key-alias", key, "changeit".toCharArray(), new Certificate[]{cert});
        logger.log(Level.FINEST, "Keystore entry count: {0}", keystore.size());
        logger.log(Level.FINEST, "Client Certificate: {0}", keystore.getCertificate("cert-alias"));
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
        kmf.init(keystore, "changeit".toCharArray());
        KeyManager[] km = kmf.getKeyManagers();
        TrustManager[] tm = null;
        if (!verifyPeer) {
            tm = new TrustManager[]{new TrustyTrustManager()};
        }
        context.init(km, tm, null);
        return context.getSocketFactory();
    }

    public static SSLSocketFactory getSocketFactoryPKCS12(String p12Path) throws NoSuchAlgorithmException, KeyStoreException, FileNotFoundException, IOException, CertificateException, UnrecoverableKeyException, KeyManagementException {
        SSLContext context = SSLContext.getInstance("TLS");
        KeyStore keystore = KeyStore.getInstance("PKCS12");
        keystore.load(new FileInputStream(p12Path), "changeit".toCharArray());
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
        kmf.init(keystore, "changeit".toCharArray());
        KeyManager[] km = kmf.getKeyManagers();
        TrustManager[] tm = null;
        context.init(km, tm, null);
        return context.getSocketFactory();
    }

    public static SSLSocketFactory getSocketFactoryJKS(String keystorePath) throws NoSuchAlgorithmException, KeyStoreException, FileNotFoundException, IOException, CertificateException, UnrecoverableKeyException, KeyManagementException {
        SSLContext context = SSLContext.getInstance("TLS");
        KeyStore keystore = KeyStore.getInstance("JKS");
        keystore.load(new FileInputStream(keystorePath), "changeit".toCharArray());
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
        kmf.init(keystore, "changeit".toCharArray());
        KeyManager[] km = kmf.getKeyManagers();
        TrustManager[] tm = null;
        context.init(km, tm, null);
        return context.getSocketFactory();
    }

    public static byte[] parseDERFromPEM(byte[] pem, String beginDelimiter, String endDelimiter) {
        String data = new String(pem, StandardCharsets.UTF_8);
        String[] tokens = data.split(beginDelimiter);
        tokens = tokens[1].split(endDelimiter);
        return IOUtil.decodeBase64(tokens[0]);
    }

    public static X509Certificate fetchCertificateFromPEM(byte[] pem) throws CertificateException {
        String data = new String(pem, StandardCharsets.UTF_8);
        String[] tokens = data.split("-----BEGIN CERTIFICATE-----");
        tokens = tokens[1].split("-----END CERTIFICATE-----");
        byte[] certBytes = IOUtil.decodeBase64(tokens[0]);
        X509Certificate cert = SecurityUtil.generateX509CertificateFromDER(certBytes);
        return cert;
    }

    public static RSAPrivateKey fetchPrivateKeyFromPEM(byte[] pem) throws InvalidKeySpecException, NoSuchAlgorithmException {
        String data = new String(pem, StandardCharsets.UTF_8);
        String[] tokens = data.split("-----BEGIN PRIVATE KEY-----");
        tokens = tokens[1].split("-----END PRIVATE KEY-----");
        byte[] keyBytes = IOUtil.decodeBase64(tokens[0]);
        RSAPrivateKey key = SecurityUtil.generateRSAPrivateKeyFromDER(keyBytes);
        return key;
    }

    public static RSAPrivateKey generateRSAPrivateKeyFromDER(byte[] keyBytes) throws InvalidKeySpecException, NoSuchAlgorithmException {
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory factory = KeyFactory.getInstance("RSA");
        return (RSAPrivateKey)factory.generatePrivate(spec);
    }

    public static X509Certificate generateX509CertificateFromDER(byte[] certBytes) throws CertificateException {
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        return (X509Certificate)factory.generateCertificate(new ByteArrayInputStream(certBytes));
    }

    public static String getCommonNameFromCertificate(X509Certificate cert) throws InvalidNameException {
        String commonName = null;
        LdapName ln = new LdapName(cert.getSubjectX500Principal().getName("RFC2253"));
        for (Rdn rdn : ln.getRdns()) {
            if (!rdn.getType().equalsIgnoreCase("CN")) continue;
            commonName = String.valueOf(rdn.getValue());
            break;
        }
        return commonName;
    }

    public static class TrustyTrustManager
    implements X509TrustManager {
        @Override
        public void checkClientTrusted(X509Certificate[] xcs, String string) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] xcs, String string) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }
}

