/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.jlog.util;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jlab.jlog.util.IOUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class XMLUtil {
    private static final DatatypeFactory typeFactory;

    private XMLUtil() {
    }

    public static String toXMLFormat(GregorianCalendar calendar) {
        return typeFactory.newXMLGregorianCalendar(calendar).normalize().toXMLFormat();
    }

    public static GregorianCalendar toGregorianCalendar(String xmlDateTime) {
        return typeFactory.newXMLGregorianCalendar(xmlDateTime).normalize().toGregorianCalendar();
    }

    public static Element appendElementWithText(Document doc, Element parent, String tagName, String text) {
        Element child = doc.createElement(tagName);
        parent.appendChild(child);
        child.setTextContent(text);
        return child;
    }

    public static void appendCommaDelimitedElementsWithText(Document doc, Element parent, String tagName, String list) {
        String[] tokens;
        for (String token : tokens = IOUtil.csvToArray(list)) {
            XMLUtil.appendElementWithText(doc, parent, tagName, token);
        }
    }

    public static void appendCommaDelimitedElementsWithGrandchildAndText(Document doc, Element parent, String childTagName, String grandchildTagName, String list) {
        String[] tokens;
        for (String token : tokens = IOUtil.csvToArray(list)) {
            Element child = doc.createElement(childTagName);
            parent.appendChild(child);
            XMLUtil.appendElementWithText(doc, child, grandchildTagName, token);
        }
    }

    public static String buildCommaDelimitedFromText(NodeList nodes) {
        StringBuilder csvBuilder = new StringBuilder();
        if (nodes.getLength() > 0) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                csvBuilder.append(nodes.item(i).getTextContent());
                csvBuilder.append(",");
            }
            csvBuilder.deleteCharAt(csvBuilder.length() - 1);
        }
        return csvBuilder.toString();
    }

    public static String[] buildArrayFromText(NodeList nodes) {
        ArrayList<String> values = new ArrayList<String>();
        if (nodes.getLength() > 0) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                values.add(nodes.item(i).getTextContent());
            }
        }
        return values.toArray(new String[0]);
    }

    public static void removeChildren(Element parent) {
        while (parent.hasChildNodes()) {
            parent.removeChild(parent.getFirstChild());
        }
    }

    public static Element getChildElementByName(Node parent, String tagName) {
        Element child = null;
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Element candidate;
            if (!(children.item(i) instanceof Element) || !(candidate = (Element)children.item(i)).getTagName().equals(tagName)) continue;
            child = candidate;
            break;
        }
        return child;
    }

    public static String getXML(Document doc) throws TransformerConfigurationException, TransformerException {
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        DOMSource source = new DOMSource(doc);
        transformer.transform(source, result);
        return writer.toString();
    }

    static {
        try {
            typeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new IllegalStateException("Unable to initialize a DatatypeFactory.", e);
        }
    }
}

