/*
 * Decompiled with CFR 0.152.
 */
package org.jline.terminal.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.IntConsumer;
import org.jline.terminal.Cursor;
import org.jline.terminal.Terminal;
import org.jline.terminal.impl.CursorSupport;
import org.jline.terminal.impl.LineDisciplineTerminal;

public class ExternalTerminal
extends LineDisciplineTerminal {
    protected final AtomicBoolean closed = new AtomicBoolean();
    protected final InputStream masterInput;
    protected final Object lock = new Object();
    protected boolean paused = true;
    protected Thread pumpThread;

    public ExternalTerminal(String name, String type, InputStream masterInput, OutputStream masterOutput, Charset encoding) throws IOException {
        this(name, type, masterInput, masterOutput, encoding, Terminal.SignalHandler.SIG_DFL);
    }

    public ExternalTerminal(String name, String type, InputStream masterInput, OutputStream masterOutput, Charset encoding, Terminal.SignalHandler signalHandler) throws IOException {
        this(name, type, masterInput, masterOutput, encoding, signalHandler, false);
    }

    public ExternalTerminal(String name, String type, InputStream masterInput, OutputStream masterOutput, Charset encoding, Terminal.SignalHandler signalHandler, boolean paused) throws IOException {
        super(name, type, masterOutput, encoding, signalHandler);
        this.masterInput = masterInput;
        if (!paused) {
            this.resume();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            this.pause();
            super.close();
        }
    }

    @Override
    public boolean canPauseResume() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause() {
        Object object = this.lock;
        synchronized (object) {
            this.paused = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause(boolean wait) throws InterruptedException {
        Thread p;
        Object object = this.lock;
        synchronized (object) {
            this.paused = true;
            p = this.pumpThread;
        }
        if (p != null) {
            p.interrupt();
            p.join();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() {
        Object object = this.lock;
        synchronized (object) {
            this.paused = false;
            if (this.pumpThread == null) {
                this.pumpThread = new Thread(this::pump, this.toString() + " input pump thread");
                this.pumpThread.setDaemon(true);
                this.pumpThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean paused() {
        Object object = this.lock;
        synchronized (object) {
            return this.paused;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void pump() {
        try {
            while (true) {
                int c;
                if ((c = this.masterInput.read()) >= 0) {
                    this.processInputByte((char)c);
                }
                if (c >= 0 && !this.closed.get()) {
                    Object object = this.lock;
                    synchronized (object) {
                        if (this.paused) {
                            this.pumpThread = null;
                            return;
                        }
                    }
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            this.processIOException(e);
        }
        finally {
            Object object = this.lock;
            synchronized (object) {
                this.pumpThread = null;
            }
        }
        try {
            this.slaveInput.close();
            return;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public Cursor getCursorPosition(IntConsumer discarded) {
        return CursorSupport.getCursorPosition(this, discarded);
    }
}

