/*
 * Decompiled with CFR 0.152.
 */
package org.jmmo.testing;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.TestClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JUnitFactoryRunner
extends ParentRunner<Runner> {
    private final ArrayList<Runner> runners = new ArrayList();

    public JUnitFactoryRunner(Class<?> clazz) throws Throwable {
        super(clazz);
        for (FrameworkMethod each : this.getFactoryMethods(this.getTestClass())) {
            this.getChildren().add((Runner)new TestClassRunner(each.getMethod()));
        }
    }

    protected List<Runner> getChildren() {
        return this.runners;
    }

    protected Description describeChild(Runner child) {
        return child.getDescription();
    }

    protected void runChild(Runner child, RunNotifier notifier) {
        child.run(notifier);
    }

    protected Iterable<FrameworkMethod> getFactoryMethods(TestClass testClass) throws Exception {
        List methods = testClass.getAnnotatedMethods(JUnitFactory.class);
        for (FrameworkMethod each : methods) {
            Method method = each.getMethod();
            int modifiers = method.getModifiers();
            if (!Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) {
                throw new Exception("No public static factory method " + each.getName() + " on class " + testClass.getName());
            }
            Class<?> returnType = method.getReturnType();
            if (returnType.equals(Void.TYPE) || returnType.equals(Void.class)) {
                throw new Exception("Method " + each.getName() + " annotated with JUnitFactory annotation must has something to return on class " + testClass.getName());
            }
            if (method.getParameterTypes().length <= 0) continue;
            throw new Exception("Method " + each.getName() + " annotated with JUnitFactory annotation must has no parameters on class " + testClass.getName());
        }
        return methods;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TestClassRunner
    extends BlockJUnit4ClassRunner {
        private final Method createTestMethod;

        TestClassRunner(Method createTestMethod) throws InitializationError {
            super(createTestMethod.getReturnType());
            this.createTestMethod = createTestMethod;
        }

        public Object createTest() throws Exception {
            return this.createTestMethod.invoke(null, new Object[0]);
        }

        protected void validateConstructor(List<Throwable> errors) {
        }

        protected Annotation[] getRunnerAnnotations() {
            return new Annotation[0];
        }
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface JUnitFactory {
    }
}

