/*
 * Decompiled with CFR 0.152.
 */
package org.jmmo;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class Option<T>
implements Serializable,
Iterable<T> {
    public static final Option<?> None = new None();

    public static <V> Option<V> some(V value) {
        return new Some<V>(value);
    }

    public static <V> Option<V> none() {
        return None;
    }

    public static <V> Option<V> option(V value) {
        return value == null ? Option.none() : Option.some(value);
    }

    public abstract boolean isEmpty();

    public boolean isDefined() {
        return !this.isEmpty();
    }

    public T getOrElse(T defaultValue) {
        return this.isEmpty() ? defaultValue : this.get();
    }

    public T getOrNull() {
        return this.getOrElse(null);
    }

    public T getOrException(RuntimeException e) {
        if (this.isDefined()) {
            return this.get();
        }
        throw e;
    }

    @Override
    public Iterator<T> iterator() {
        return this.isEmpty() ? Collections.emptyList().iterator() : Collections.singletonList(this.get()).iterator();
    }

    public abstract T get();

    private static final class None
    extends Option<Object> {
        private static final long serialVersionUID = -4496938325844728235L;

        private None() {
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public Object get() {
            throw new NoSuchElementException("None.get");
        }

        public String toString() {
            return "None";
        }
    }

    private static final class Some<T>
    extends Option<T> {
        private static final long serialVersionUID = -6594285056904344306L;
        private final T value;

        public Some(T value) {
            this.value = value;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public T get() {
            return this.value;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Some other = (Some)obj;
            return !(this.get() != null ? !this.get().equals(other.get()) : other.get() != null);
        }

        public int hashCode() {
            return this.get() != null ? this.get().hashCode() : 0;
        }

        public String toString() {
            return "Some{" + this.get() + "}";
        }
    }
}

