/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.integration.junit4;

import java.lang.reflect.Field;
import java.util.List;
import org.jmock.Mockery;
import org.jmock.auto.internal.Mockomatic;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.AllDeclaredFields;
import org.junit.Assert;
import org.junit.rules.MethodRule;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

public class JUnitRuleMockery
extends JUnit4Mockery
implements MethodRule {
    private final Mockomatic mockomatic = new Mockomatic((Mockery)this);

    public Statement apply(final Statement base, FrameworkMethod method, final Object target) {
        return new Statement(){

            public void evaluate() throws Throwable {
                this.prepare(target);
                base.evaluate();
                JUnitRuleMockery.this.assertIsSatisfied();
            }

            private void prepare(Object target2) {
                List allFields = AllDeclaredFields.in(target2.getClass());
                this.assertOnlyOneJMockContextIn(allFields);
                this.fillInAutoMocks(target2, allFields);
            }

            private void assertOnlyOneJMockContextIn(List<Field> allFields) {
                Field contextField = null;
                for (Field field : allFields) {
                    if (!JUnitRuleMockery.class.isAssignableFrom(field.getType())) continue;
                    if (null != contextField) {
                        Assert.fail((String)("Test class should only have one JUnitRuleMockery field, found " + contextField.getName() + " and " + field.getName()));
                    }
                    contextField = field;
                }
            }

            private void fillInAutoMocks(Object target2, List<Field> allFields) {
                JUnitRuleMockery.this.mockomatic.fillIn(target2, allFields);
            }
        };
    }
}

