/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.attach.spi;

import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.AttachPermission;
import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;

public abstract class AttachProvider {
    private static final Object lock = new Object();
    private static List<AttachProvider> providers = null;

    protected AttachProvider() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AttachPermission("createAttachProvider"));
        }
    }

    public abstract String name();

    public abstract String type();

    public abstract VirtualMachine attachVirtualMachine(String var1) throws AttachNotSupportedException, IOException;

    public VirtualMachine attachVirtualMachine(VirtualMachineDescriptor vmd) throws AttachNotSupportedException, IOException {
        if (vmd.provider() != this) {
            throw new AttachNotSupportedException("provider mismatch");
        }
        return this.attachVirtualMachine(vmd.id());
    }

    public abstract List<VirtualMachineDescriptor> listVirtualMachines();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<AttachProvider> providers() {
        Object object = lock;
        synchronized (object) {
            if (providers == null) {
                providers = new ArrayList<AttachProvider>();
                ServiceLoader<AttachProvider> providerLoader = ServiceLoader.load(AttachProvider.class, AttachProvider.class.getClassLoader());
                Iterator<AttachProvider> i = providerLoader.iterator();
                while (i.hasNext()) {
                    try {
                        providers.add(i.next());
                    }
                    catch (Throwable t) {
                        if (t instanceof ThreadDeath) {
                            ThreadDeath td = (ThreadDeath)t;
                            throw td;
                        }
                        System.err.println(t);
                    }
                }
            }
            return Collections.unmodifiableList(providers);
        }
    }
}

