/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.modification;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.coverage.Metrics;
import mockit.coverage.data.CoverageData;
import mockit.coverage.data.FileCoverageData;
import mockit.coverage.lines.BranchCoverageData;
import mockit.coverage.lines.LineCoverageData;
import mockit.coverage.lines.PerFileLineCoverage;
import mockit.coverage.modification.VisitInterruptedException;
import mockit.coverage.paths.MethodCoverageData;
import mockit.coverage.paths.NodeBuilder;
import mockit.external.asm.AnnotationVisitor;
import mockit.external.asm.ClassReader;
import mockit.external.asm.ClassVisitor;
import mockit.external.asm.ClassWriter;
import mockit.external.asm.FieldVisitor;
import mockit.external.asm.Label;
import mockit.external.asm.MethodVisitor;
import mockit.external.asm.MethodWriter;

final class CoverageModifier
extends ClassVisitor {
    private static final Map<String, CoverageModifier> INNER_CLASS_MODIFIERS = new HashMap<String, CoverageModifier>();
    private static final int FIELD_MODIFIERS_TO_IGNORE = 4112;
    private static final int MAX_CONDITIONS = Integer.getInteger("jmockit-coverage-maxConditions", 10);
    private static final boolean WITH_PATH_OR_DATA_COVERAGE = Metrics.PathCoverage.active || Metrics.DataCoverage.active;
    @Nonnull
    private final ClassWriter cw;
    @Nullable
    private String internalClassName;
    @Nullable
    private String simpleClassName;
    @Nonnull
    private String sourceFileName;
    @Nullable
    private FileCoverageData fileData;
    @Nullable
    private final BitSet linesReprocessed;
    private boolean cannotModify;
    private final boolean forInnerClass;
    private boolean forEnumClass;
    @Nullable
    private String kindOfTopLevelType;
    private int currentLine;

    @Nullable
    static byte[] recoverModifiedByteCodeIfAvailable(@Nonnull String innerClassName) {
        CoverageModifier modifier = INNER_CLASS_MODIFIERS.remove(innerClassName);
        return modifier == null ? null : modifier.toByteArray();
    }

    @Nullable
    static ClassReader createClassReader(@Nonnull Class<?> aClass) {
        return CoverageModifier.createClassReader(aClass.getClassLoader(), aClass.getName().replace('.', '/'));
    }

    @Nullable
    private static ClassReader createClassReader(@Nonnull ClassLoader cl, @Nonnull String internalClassName) {
        String classFileName = internalClassName + ".class";
        InputStream classFile = cl.getResourceAsStream(classFileName);
        if (classFile == null) {
            return null;
        }
        try {
            return new ClassReader(classFile);
        }
        catch (IOException ignore) {
            return null;
        }
    }

    CoverageModifier(@Nonnull ClassReader cr, boolean forReloadedClass) {
        this(cr, false, forReloadedClass ? new BitSet(65536) : null);
    }

    private CoverageModifier(@Nonnull ClassReader cr, boolean forInnerClass, @Nullable BitSet linesReprocessed) {
        super(new ClassWriter(cr));
        this.cw = (ClassWriter)this.cv;
        this.sourceFileName = "";
        this.linesReprocessed = linesReprocessed;
        this.forInnerClass = forInnerClass;
    }

    private CoverageModifier(@Nonnull ClassReader cr, @Nonnull CoverageModifier other, @Nullable String simpleClassName) {
        this(cr, true, other.linesReprocessed);
        this.sourceFileName = other.sourceFileName;
        this.fileData = other.fileData;
        this.internalClassName = other.internalClassName;
        this.simpleClassName = simpleClassName;
    }

    @Override
    public void visit(int version, int access, @Nonnull String name, @Nullable String signature, String superName, @Nullable String[] interfaces) {
        boolean nestedType;
        if ((access & 0x1000) != 0) {
            throw new VisitInterruptedException();
        }
        boolean bl = nestedType = name.indexOf(36) > 0;
        if (!nestedType && this.kindOfTopLevelType == null) {
            this.kindOfTopLevelType = CoverageModifier.getKindOfJavaType(access, superName);
        }
        boolean bl2 = this.forEnumClass = (access & 0x4000) != 0;
        if (!this.forInnerClass) {
            this.internalClassName = name;
            int p = name.lastIndexOf(47);
            if (p < 0) {
                this.simpleClassName = name;
                this.sourceFileName = "";
            } else {
                this.simpleClassName = name.substring(p + 1);
                this.sourceFileName = name.substring(0, p + 1);
            }
            boolean bl3 = this.cannotModify = (access & 0x2000) != 0;
            if (!this.forEnumClass && (access & 0x20) != 0 && nestedType) {
                INNER_CLASS_MODIFIERS.put(name.replace('/', '.'), this);
            }
        }
        this.cw.visit(version, access, name, signature, superName, interfaces);
    }

    @Nonnull
    private static String getKindOfJavaType(int typeModifiers, @Nonnull String superName) {
        if ((typeModifiers & 0x2000) != 0) {
            return "annotation";
        }
        if ((typeModifiers & 0x200) != 0) {
            return "interface";
        }
        if ((typeModifiers & 0x4000) != 0) {
            return "enum";
        }
        if ((typeModifiers & 0x400) != 0) {
            return "abstractClass";
        }
        if (superName.endsWith("Exception") || superName.endsWith("Error")) {
            return "exception";
        }
        return "class";
    }

    @Override
    public void visitSource(@Nullable String file, @Nullable String debug) {
        if (file == null || !file.endsWith(".java")) {
            throw VisitInterruptedException.INSTANCE;
        }
        if (!this.forInnerClass) {
            if (this.cannotModify) {
                throw VisitInterruptedException.INSTANCE;
            }
            this.sourceFileName = this.sourceFileName + file;
            this.fileData = CoverageData.instance().getOrAddFile(this.sourceFileName, this.kindOfTopLevelType);
        }
        this.cw.visitSource(file, debug);
    }

    @Override
    public void visitInnerClass(@Nonnull String internalName, @Nullable String outerName, @Nullable String innerName, int access) {
        this.cw.visitInnerClass(internalName, outerName, innerName, access);
        if (this.forInnerClass || CoverageModifier.isSyntheticOrEnumClass(access) || !this.isNestedInsideClassBeingModified(outerName)) {
            return;
        }
        String innerClassName = internalName.replace('/', '.');
        if (INNER_CLASS_MODIFIERS.containsKey(innerClassName)) {
            return;
        }
        ClassReader innerCR = CoverageModifier.createClassReader(CoverageModifier.class.getClassLoader(), internalName);
        if (innerCR != null) {
            CoverageModifier innerClassModifier = new CoverageModifier(innerCR, this, innerName);
            innerCR.accept(innerClassModifier, 4);
            INNER_CLASS_MODIFIERS.put(innerClassName, innerClassModifier);
        }
    }

    private static boolean isSyntheticOrEnumClass(int access) {
        return (access & 0x1000) != 0 || access == 16392;
    }

    private boolean isNestedInsideClassBeingModified(@Nullable String outerName) {
        if (outerName == null) {
            return false;
        }
        int p = outerName.indexOf(36);
        String outerClassName = p < 0 ? outerName : outerName.substring(0, p);
        return outerClassName.equals(this.internalClassName);
    }

    @Override
    public FieldVisitor visitField(int access, @Nonnull String name, @Nonnull String desc, @Nullable String signature, @Nullable Object value) {
        if (this.fileData != null && this.simpleClassName != null && (access & 0x1010) == 0 && Metrics.DataCoverage.active) {
            this.fileData.dataCoverageInfo.addField(this.simpleClassName, name, (access & 8) != 0);
        }
        return this.cw.visitField(access, name, desc, signature, value);
    }

    @Override
    public MethodVisitor visitMethod(int access, @Nonnull String name, @Nonnull String desc, @Nullable String signature, @Nullable String[] exceptions) {
        MethodWriter mw = this.cw.visitMethod(access, name, desc, signature, exceptions);
        if (this.fileData == null || (access & 0x1000) != 0) {
            return mw;
        }
        if (name.charAt(0) == '<') {
            if (name.charAt(1) == 'c') {
                return this.forEnumClass ? mw : new StaticBlockModifier(mw);
            }
            if (WITH_PATH_OR_DATA_COVERAGE) {
                return new ConstructorModifier(mw);
            }
        }
        return WITH_PATH_OR_DATA_COVERAGE ? new MethodModifier(mw) : new BaseMethodModifier(mw);
    }

    private final class StaticBlockModifier
    extends BaseMethodModifier {
        StaticBlockModifier(MethodWriter mw) {
            super(mw);
        }

        @Override
        public void visitMethodInsn(int opcode, @Nonnull String owner, @Nonnull String name, @Nonnull String desc, boolean itf) {
            if (opcode == 182 && "java/lang/Class".equals(owner) && "desiredAssertionStatus".equals(name)) {
                this.assertFoundInCurrentLine = true;
                this.ignoreUntilNextLabel = true;
            }
            super.visitMethodInsn(opcode, owner, name, desc, itf);
        }
    }

    private final class ConstructorModifier
    extends MethodOrConstructorModifier {
        ConstructorModifier(MethodWriter mw) {
            super(mw);
        }
    }

    private final class MethodModifier
    extends MethodOrConstructorModifier {
        MethodModifier(MethodWriter mw) {
            super(mw);
        }

        @Override
        public AnnotationVisitor visitAnnotation(@Nonnull String desc, boolean visible) {
            boolean isTestMethod;
            boolean bl = isTestMethod = desc.startsWith("Lorg/junit/") || desc.startsWith("Lorg/testng/");
            if (isTestMethod) {
                throw VisitInterruptedException.INSTANCE;
            }
            return this.mw.visitAnnotation(desc, visible);
        }
    }

    private class MethodOrConstructorModifier
    extends BaseMethodModifier {
        @Nullable
        private NodeBuilder nodeBuilder;
        @Nullable
        private Label entryPoint;
        private int jumpCount;

        MethodOrConstructorModifier(MethodWriter mw) {
            super(mw);
            this.nodeBuilder = new NodeBuilder();
        }

        @Override
        public final void visitLabel(@Nonnull Label label) {
            if (this.nodeBuilder == null || this.ignoreUntilNextSwitch > 0) {
                super.visitLabel(label);
                return;
            }
            int line = label.line;
            if (this.entryPoint == null) {
                this.entryPoint = new Label();
                this.mw.visitLabel(this.entryPoint);
                this.mw.visitLineNumber(line, this.entryPoint);
                this.nodeBuilder.handleEntry(line);
                this.generateCallToRegisterNodeReached(0);
            }
            super.visitLabel(label);
            int newNodeIndex = this.nodeBuilder.handleJumpTarget(label, line > 0 ? line : CoverageModifier.this.currentLine);
            this.generateCallToRegisterNodeReached(newNodeIndex);
        }

        private void generateCallToRegisterNodeReached(int nodeIndex) {
            if (nodeIndex >= 0) {
                assert (this.nodeBuilder != null);
                this.mw.visitLdcInsn(CoverageModifier.this.sourceFileName);
                this.mw.visitLdcInsn(this.nodeBuilder.firstLine);
                this.mw.visitIntInsn(17, nodeIndex);
                this.mw.visitMethodInsn(184, "mockit/coverage/TestRun", "nodeReached", "(Ljava/lang/String;II)V", false);
            }
        }

        @Override
        public final void visitJumpInsn(int opcode, @Nonnull Label label) {
            if (this.nodeBuilder == null || this.entryPoint == null || this.ignoreUntilNextSwitch > 0 || this.visitedLabels.contains(label)) {
                super.visitJumpInsn(opcode, label);
                return;
            }
            boolean conditional = this.isConditionalJump(opcode);
            if (conditional && ++this.jumpCount > MAX_CONDITIONS) {
                this.nodeBuilder = null;
            } else {
                int nodeIndex = this.nodeBuilder.handleJump(label, CoverageModifier.this.currentLine, conditional);
                this.generateCallToRegisterNodeReached(nodeIndex);
            }
            super.visitJumpInsn(opcode, label);
        }

        @Override
        public final void visitInsn(int opcode) {
            if (this.nodeBuilder != null) {
                if (opcode >= 172 && opcode <= 177 || opcode == 191) {
                    int newNodeIndex = this.nodeBuilder.handleExit(CoverageModifier.this.currentLine);
                    this.generateCallToRegisterNodeReached(newNodeIndex);
                } else {
                    this.handleRegularInstruction(opcode);
                }
            }
            super.visitInsn(opcode);
        }

        private void handleRegularInstruction(int opcode) {
            if (this.nodeBuilder != null && this.ignoreUntilNextSwitch == 0) {
                int nodeIndex = this.nodeBuilder.handleRegularInstruction(CoverageModifier.this.currentLine, opcode);
                this.generateCallToRegisterNodeReached(nodeIndex);
            }
        }

        @Override
        public final void visitIntInsn(int opcode, int operand) {
            super.visitIntInsn(opcode, operand);
            this.handleRegularInstruction(opcode);
        }

        @Override
        public final void visitIincInsn(int varIndex, int increment) {
            super.visitIincInsn(varIndex, increment);
            this.handleRegularInstruction(132);
        }

        @Override
        public final void visitLdcInsn(@Nonnull Object cst) {
            super.visitLdcInsn(cst);
            this.handleRegularInstruction(18);
        }

        @Override
        public final void visitTypeInsn(int opcode, @Nonnull String desc) {
            super.visitTypeInsn(opcode, desc);
            this.handleRegularInstruction(opcode);
        }

        @Override
        public final void visitVarInsn(int opcode, int varIndex) {
            super.visitVarInsn(opcode, varIndex);
            this.handleRegularInstruction(opcode);
        }

        @Override
        public final void visitFieldInsn(int opcode, @Nonnull String owner, @Nonnull String name, @Nonnull String desc) {
            if (!Metrics.DataCoverage.active) {
                super.visitFieldInsn(opcode, owner, name, desc);
                return;
            }
            boolean getField = opcode == 178 || opcode == 180;
            boolean isStatic = opcode == 179 || opcode == 178;
            char fieldType = desc.charAt(0);
            boolean size2 = fieldType == 'J' || fieldType == 'D';
            String classAndFieldNames = null;
            boolean fieldHasData = false;
            if (!owner.startsWith("java/")) {
                classAndFieldNames = owner.substring(owner.lastIndexOf(47) + 1) + '.' + name;
                assert (CoverageModifier.this.fileData != null);
                fieldHasData = ((CoverageModifier)CoverageModifier.this).fileData.dataCoverageInfo.isFieldWithCoverageData(classAndFieldNames);
                if (fieldHasData && !isStatic) {
                    this.generateCodeToSaveInstanceReferenceOnTheStack(getField, size2);
                }
            }
            super.visitFieldInsn(opcode, owner, name, desc);
            if (fieldHasData) {
                this.generateCallToRegisterFieldCoverage(getField, isStatic, size2, classAndFieldNames);
            }
            this.handleRegularInstruction(opcode);
        }

        private void generateCodeToSaveInstanceReferenceOnTheStack(boolean getField, boolean size2) {
            if (getField) {
                this.mw.visitInsn(89);
            } else if (size2) {
                this.mw.visitInsn(93);
                this.mw.visitInsn(88);
                this.mw.visitInsn(91);
                this.mw.visitInsn(91);
                this.mw.visitInsn(87);
            } else {
                this.mw.visitInsn(90);
                this.mw.visitInsn(87);
                this.mw.visitInsn(90);
                this.mw.visitInsn(90);
                this.mw.visitInsn(87);
            }
        }

        private void generateCallToRegisterFieldCoverage(boolean getField, boolean isStatic, boolean size2, @Nonnull String classAndFieldNames) {
            if (!isStatic && getField) {
                if (size2) {
                    this.mw.visitInsn(93);
                    this.mw.visitInsn(88);
                } else {
                    this.mw.visitInsn(90);
                    this.mw.visitInsn(87);
                }
            }
            this.mw.visitLdcInsn(CoverageModifier.this.sourceFileName);
            this.mw.visitLdcInsn(classAndFieldNames);
            String methodToCall = getField ? "fieldRead" : "fieldAssigned";
            String methodDesc = isStatic ? "(Ljava/lang/String;Ljava/lang/String;)V" : "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;)V";
            this.mw.visitMethodInsn(184, "mockit/coverage/TestRun", methodToCall, methodDesc, false);
        }

        @Override
        public final void visitMethodInsn(int opcode, @Nonnull String owner, @Nonnull String name, @Nonnull String desc, boolean itf) {
            super.visitMethodInsn(opcode, owner, name, desc, itf);
            this.handleRegularInstruction(opcode);
        }

        @Override
        public final void visitTryCatchBlock(@Nonnull Label start, @Nonnull Label end, @Nonnull Label handler, @Nullable String type) {
            super.visitTryCatchBlock(start, end, handler, type);
            this.handleRegularInstruction(0);
        }

        @Override
        public final void visitLookupSwitchInsn(@Nonnull Label dflt, @Nonnull int[] keys, @Nonnull Label[] labels) {
            if (this.ignoreUntilNextSwitch == 1) {
                this.ignoreUntilNextSwitch = 2;
            } else if (this.nodeBuilder != null) {
                int nodeIndex = this.nodeBuilder.handleForwardJumpsToNewTargets(dflt, labels, CoverageModifier.this.currentLine);
                this.generateCallToRegisterNodeReached(nodeIndex);
                this.ignoreUntilNextSwitch = 0;
            }
            super.visitLookupSwitchInsn(dflt, keys, labels);
        }

        @Override
        public final void visitTableSwitchInsn(int min, int max, @Nonnull Label dflt, Label ... labels) {
            if (this.nodeBuilder != null && this.ignoreUntilNextSwitch == 0) {
                int nodeIndex = this.nodeBuilder.handleForwardJumpsToNewTargets(dflt, labels, CoverageModifier.this.currentLine);
                this.generateCallToRegisterNodeReached(nodeIndex);
            }
            super.visitTableSwitchInsn(min, max, dflt, labels);
        }

        @Override
        public final void visitMultiANewArrayInsn(String desc, int dims) {
            super.visitMultiANewArrayInsn(desc, dims);
            this.handleRegularInstruction(197);
        }

        @Override
        public final void visitEnd() {
            if (CoverageModifier.this.currentLine > 0 && this.nodeBuilder != null && this.nodeBuilder.hasNodes() && CoverageModifier.this.fileData != null) {
                MethodCoverageData methodData = new MethodCoverageData();
                methodData.buildPaths(CoverageModifier.this.currentLine, this.nodeBuilder);
                CoverageModifier.this.fileData.addMethod(methodData);
            }
        }
    }

    private class BaseMethodModifier
    extends MethodVisitor {
        static final String DATA_RECORDING_CLASS = "mockit/coverage/TestRun";
        @Nonnull
        protected final MethodWriter mw;
        @Nonnull
        protected final List<Label> visitedLabels;
        @Nonnull
        private final List<Label> jumpTargetsForCurrentLine;
        @Nonnull
        private final List<Integer> pendingBranches;
        @Nonnull
        private final PerFileLineCoverage lineCoverageInfo;
        private int lineExpectingInstructionAfterJump;
        protected boolean assertFoundInCurrentLine;
        protected boolean ignoreUntilNextLabel;
        private boolean foundPotentialAssertFalse;
        private int foundPotentialBooleanExpressionValue;
        protected int ignoreUntilNextSwitch;

        BaseMethodModifier(MethodWriter mw) {
            super(mw);
            this.mw = mw;
            this.visitedLabels = new ArrayList<Label>();
            this.jumpTargetsForCurrentLine = new ArrayList<Label>(4);
            this.pendingBranches = new ArrayList<Integer>(6);
            assert (CoverageModifier.this.fileData != null);
            this.lineCoverageInfo = CoverageModifier.this.fileData.getLineCoverageData();
        }

        @Override
        public void visitLineNumber(int line, @Nonnull Label start) {
            if (!this.pendingBranches.isEmpty()) {
                this.pendingBranches.clear();
            }
            boolean reprocessing = false;
            if (CoverageModifier.this.linesReprocessed != null && !CoverageModifier.this.linesReprocessed.get(line)) {
                CoverageModifier.this.linesReprocessed.set(line);
                reprocessing = true;
            }
            this.lineCoverageInfo.addLine(line, reprocessing);
            CoverageModifier.this.currentLine = line;
            this.jumpTargetsForCurrentLine.clear();
            this.generateCallToRegisterLineExecution();
            this.mw.visitLineNumber(line, start);
        }

        private void generateCallToRegisterLineExecution() {
            assert (CoverageModifier.this.fileData != null);
            this.mw.visitIntInsn(17, ((CoverageModifier)CoverageModifier.this).fileData.index);
            this.pushCurrentLineOnTheStack();
            this.mw.visitMethodInsn(184, DATA_RECORDING_CLASS, "lineExecuted", "(II)V", false);
        }

        private void pushCurrentLineOnTheStack() {
            if (CoverageModifier.this.currentLine <= Short.MAX_VALUE) {
                this.mw.visitIntInsn(17, CoverageModifier.this.currentLine);
            } else {
                this.mw.visitLdcInsn(CoverageModifier.this.currentLine);
            }
        }

        @Override
        public void visitJumpInsn(int opcode, @Nonnull Label label) {
            if (CoverageModifier.this.currentLine == 0 || this.ignoreUntilNextLabel || this.ignoreUntilNextSwitch > 0 || this.visitedLabels.contains(label) || !this.isConditionalJump(opcode)) {
                this.assertFoundInCurrentLine = false;
                this.mw.visitJumpInsn(opcode, label);
                if (opcode == 167 && this.foundPotentialBooleanExpressionValue == 1) {
                    this.foundPotentialBooleanExpressionValue = 2;
                }
                return;
            }
            Label jumpingFrom = this.mw.currentBlock;
            assert (jumpingFrom != null);
            jumpingFrom.info = CoverageModifier.this.currentLine;
            if (!this.jumpTargetsForCurrentLine.contains(label)) {
                this.jumpTargetsForCurrentLine.add(label);
            }
            LineCoverageData lineData = this.lineCoverageInfo.getOrCreateLineData(CoverageModifier.this.currentLine);
            int sourceBranchIndex = lineData.addBranchingPoint(jumpingFrom, label);
            this.pendingBranches.add(sourceBranchIndex);
            if (this.assertFoundInCurrentLine) {
                BranchCoverageData branchData = this.lineCoverageInfo.getBranchData(CoverageModifier.this.currentLine, sourceBranchIndex + 1);
                branchData.markAsUnreachable();
            }
            this.mw.visitJumpInsn(opcode, label);
            this.lineExpectingInstructionAfterJump = 0;
            this.generateCallToRegisterBranchTargetExecutionIfPending();
            this.lineExpectingInstructionAfterJump = CoverageModifier.this.currentLine;
        }

        protected final boolean isConditionalJump(int opcode) {
            return opcode != 167 && opcode != 168;
        }

        private void generateCallToRegisterBranchTargetExecutionIfPending() {
            if (this.ignoreUntilNextLabel || this.ignoreUntilNextSwitch > 0) {
                return;
            }
            this.foundPotentialAssertFalse = false;
            this.foundPotentialBooleanExpressionValue = 0;
            if (!this.pendingBranches.isEmpty()) {
                for (Integer pendingBranchIndex : this.pendingBranches) {
                    this.generateCallToRegisterBranchTargetExecution(pendingBranchIndex);
                }
                this.pendingBranches.clear();
            }
            if (this.lineExpectingInstructionAfterJump > 0) {
                if (CoverageModifier.this.currentLine > this.lineExpectingInstructionAfterJump) {
                    this.lineCoverageInfo.markLastLineSegmentAsEmpty(this.lineExpectingInstructionAfterJump);
                }
                this.lineExpectingInstructionAfterJump = 0;
            }
        }

        private void generateCallToRegisterBranchTargetExecution(int branchIndex) {
            assert (CoverageModifier.this.fileData != null);
            this.mw.visitIntInsn(17, ((CoverageModifier)CoverageModifier.this).fileData.index);
            this.pushCurrentLineOnTheStack();
            this.mw.visitIntInsn(17, branchIndex);
            this.mw.visitMethodInsn(184, DATA_RECORDING_CLASS, "branchExecuted", "(III)V", false);
        }

        @Override
        public void visitLabel(@Nonnull Label label) {
            if (this.ignoreUntilNextLabel || this.ignoreUntilNextSwitch > 0) {
                this.mw.visitLabel(label);
                this.ignoreUntilNextLabel = false;
                return;
            }
            this.visitedLabels.add(label);
            this.mw.visitLabel(label);
            int jumpTargetIndex = this.jumpTargetsForCurrentLine.indexOf(label);
            if (jumpTargetIndex >= 0) {
                label.info = label.line > 0 ? label.line : CoverageModifier.this.currentLine;
                int targetBranchIndex = 2 * jumpTargetIndex + 1;
                this.pendingBranches.add(targetBranchIndex);
                this.assertFoundInCurrentLine = false;
            }
            this.foundPotentialBooleanExpressionValue = 0;
        }

        @Override
        public void visitInsn(int opcode) {
            if ((opcode == 3 || opcode == 4) && this.foundPotentialBooleanExpressionValue == 0) {
                this.generateCallToRegisterBranchTargetExecutionIfPending();
                this.foundPotentialBooleanExpressionValue = 1;
            } else {
                this.generateCallToRegisterBranchTargetExecutionIfPending();
            }
            this.mw.visitInsn(opcode);
        }

        @Override
        public void visitIntInsn(int opcode, int operand) {
            this.generateCallToRegisterBranchTargetExecutionIfPending();
            this.mw.visitIntInsn(opcode, operand);
        }

        @Override
        public void visitVarInsn(int opcode, int varIndex) {
            this.generateCallToRegisterBranchTargetExecutionIfPending();
            this.mw.visitVarInsn(opcode, varIndex);
        }

        @Override
        public void visitTypeInsn(int opcode, @Nonnull String desc) {
            this.generateCallToRegisterBranchTargetExecutionIfPending();
            this.mw.visitTypeInsn(opcode, desc);
        }

        @Override
        public void visitFieldInsn(int opcode, @Nonnull String owner, @Nonnull String name, @Nonnull String desc) {
            this.generateCallToRegisterBranchTargetExecutionIfPending();
            this.mw.visitFieldInsn(opcode, owner, name, desc);
            if (opcode == 178 && "$assertionsDisabled".equals(name)) {
                this.assertFoundInCurrentLine = true;
                this.ignoreUntilNextLabel = true;
            }
            this.foundPotentialAssertFalse = true;
        }

        @Override
        public void visitMethodInsn(int opcode, @Nonnull String owner, @Nonnull String name, @Nonnull String desc, boolean itf) {
            this.generateCallToRegisterBranchTargetExecutionIfPending();
            this.mw.visitMethodInsn(opcode, owner, name, desc, itf);
            if (opcode == 182 && "hashCode".equals(name) && "java/lang/String".equals(owner) && this.ignoreUntilNextSwitch == 0) {
                this.ignoreUntilNextSwitch = 1;
            }
        }

        @Override
        public void visitLdcInsn(@Nonnull Object cst) {
            this.generateCallToRegisterBranchTargetExecutionIfPending();
            this.mw.visitLdcInsn(cst);
        }

        @Override
        public void visitIincInsn(int varIndex, int increment) {
            this.generateCallToRegisterBranchTargetExecutionIfPending();
            this.mw.visitIincInsn(varIndex, increment);
        }

        @Override
        public void visitTryCatchBlock(@Nonnull Label start, @Nonnull Label end, @Nonnull Label handler, @Nullable String type) {
            this.generateCallToRegisterBranchTargetExecutionIfPending();
            this.mw.visitTryCatchBlock(start, end, handler, type);
        }

        @Override
        public void visitLookupSwitchInsn(@Nonnull Label dflt, @Nonnull int[] keys, @Nonnull Label[] labels) {
            this.generateCallToRegisterBranchTargetExecutionIfPending();
            this.mw.visitLookupSwitchInsn(dflt, keys, labels);
        }

        @Override
        public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
            this.generateCallToRegisterBranchTargetExecutionIfPending();
            this.mw.visitTableSwitchInsn(min, max, dflt, labels);
        }

        @Override
        public void visitMultiANewArrayInsn(String desc, int dims) {
            this.generateCallToRegisterBranchTargetExecutionIfPending();
            this.mw.visitMultiANewArrayInsn(desc, dims);
        }
    }
}

