/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.reporting.lineCoverage;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.coverage.CallPoint;
import mockit.coverage.lines.BranchCoverageData;
import mockit.coverage.lines.LineCoverageData;
import mockit.coverage.lines.LineSegmentData;
import mockit.coverage.reporting.ListOfCallPoints;
import mockit.coverage.reporting.parsing.LineElement;
import mockit.coverage.reporting.parsing.LineParser;

final class LineSegmentsFormatter {
    @Nullable
    private final ListOfCallPoints listOfCallPoints;
    @Nonnull
    private final StringBuilder formattedLine;
    private int lineNumber;
    private int segmentIndex;
    private LineSegmentData segmentData;
    @Nullable
    private LineElement element;

    LineSegmentsFormatter(boolean withCallPoints, @Nonnull StringBuilder formattedLine) {
        this.listOfCallPoints = withCallPoints ? new ListOfCallPoints() : null;
        this.formattedLine = formattedLine;
    }

    void formatSegments(@Nonnull LineParser lineParser, @Nonnull LineCoverageData lineData) {
        this.lineNumber = lineParser.getNumber();
        List<BranchCoverageData> branchData = lineData.getBranches();
        int numSegments = lineData.getNumberOfSegments();
        this.element = lineParser.getInitialElement().appendUntilNextCodeElement(this.formattedLine);
        this.segmentIndex = 0;
        this.segmentData = lineData;
        this.appendUntilNextBranchingPoint();
        while (this.element != null && this.segmentIndex < numSegments) {
            this.segmentData = this.segmentIndex == 0 ? lineData : (LineSegmentData)branchData.get(this.segmentIndex - 1);
            this.element = this.element.appendUntilNextCodeElement(this.formattedLine);
            this.appendUntilNextBranchingPoint();
        }
        if (this.element != null) {
            this.element.appendAllBefore(this.formattedLine, null);
        }
        this.formattedLine.append("</pre>");
        if (this.listOfCallPoints != null) {
            this.formattedLine.append(this.listOfCallPoints.getContents());
        }
    }

    private void appendUntilNextBranchingPoint() {
        if (this.element != null) {
            LineElement firstElement = this.element;
            this.element = this.element.findNextBranchingPoint();
            this.appendToFormattedLine(firstElement);
            if (this.element != null && this.element.isBranchingElement()) {
                this.formattedLine.append(this.element.getText());
                this.element = this.element.getNext();
            }
        }
    }

    private void appendToFormattedLine(@Nonnull LineElement firstElement) {
        if (firstElement != this.element) {
            this.appendStartTag();
            firstElement.appendAllBefore(this.formattedLine, this.element);
            this.appendEndTag();
            ++this.segmentIndex;
        }
    }

    private void appendStartTag() {
        this.formattedLine.append("<span id='l").append(this.lineNumber).append('s').append(this.segmentIndex);
        this.formattedLine.append("' title='Executions: ").append(this.segmentData.getExecutionCount()).append("' ");
        if (this.segmentData.isCovered()) {
            if (this.segmentData.containsCallPoints()) {
                this.formattedLine.append("class='covered cp' onclick='showHide(this,").append(this.segmentIndex).append(")'>");
            } else {
                this.formattedLine.append("class='covered'>");
            }
        } else {
            this.formattedLine.append("class='uncovered'>");
        }
    }

    private void appendEndTag() {
        int i = this.formattedLine.length() - 1;
        while (Character.isWhitespace(this.formattedLine.charAt(i))) {
            --i;
        }
        this.formattedLine.insert(i + 1, "</span>");
        if (this.listOfCallPoints != null) {
            List<CallPoint> callPoints = this.segmentData.getCallPoints();
            this.listOfCallPoints.insertListOfCallPoints(callPoints);
        }
    }
}

