/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.standalone;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.annotation.Nonnull;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.PersistentMBean;
import javax.management.StandardMBean;
import mockit.coverage.CodeCoverage;
import mockit.coverage.Configuration;
import mockit.coverage.standalone.CoverageControlMBean;
import mockit.coverage.standalone.Description;

public final class CoverageControl
extends StandardMBean
implements CoverageControlMBean,
PersistentMBean {
    static void create() {
        MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            CoverageControl mxBean = new CoverageControl();
            mbeanServer.registerMBean(mxBean, new ObjectName("JMockit Coverage:type=CoverageControl"));
        }
        catch (JMException e) {
            throw new RuntimeException(e);
        }
    }

    public CoverageControl() throws NotCompliantMBeanException, MBeanException {
        super(CoverageControlMBean.class);
        this.load();
    }

    @Override
    @Nonnull
    protected String getDescription(MBeanInfo info) {
        return CoverageControlMBean.class.getAnnotation(Description.class).value();
    }

    @Override
    @Nonnull
    protected String getParameterName(MBeanOperationInfo op, MBeanParameterInfo param, int sequence) {
        return "resetState";
    }

    @Override
    protected String getDescription(@Nonnull MBeanAttributeInfo info) {
        return CoverageControl.getDescription("get" + info.getName());
    }

    @Nonnull
    private static String getDescription(@Nonnull String methodName) {
        return CoverageControl.getMethod(methodName).getAnnotation(Description.class).value();
    }

    @Nonnull
    private static Method getMethod(@Nonnull String methodName) {
        for (Method method : CoverageControlMBean.class.getDeclaredMethods()) {
            if (!method.getName().equals(methodName)) continue;
            return method;
        }
        throw new IllegalStateException("Required method not found in class CoverageControlMBean: " + methodName);
    }

    @Override
    protected String getDescription(@Nonnull MBeanOperationInfo info) {
        return CoverageControl.getDescription(info.getName());
    }

    @Override
    protected String getDescription(@Nonnull MBeanOperationInfo op, MBeanParameterInfo param, int sequence) {
        Method method = CoverageControl.getMethod(op.getName());
        Description desc = (Description)method.getParameterAnnotations()[sequence][0];
        return desc.value();
    }

    @Override
    protected int getImpact(MBeanOperationInfo info) {
        return 1;
    }

    @Override
    @Nonnull
    public String getOutput() {
        return CoverageControl.getProperty("output", "html").replace("-nocp", "");
    }

    @Override
    public void setOutput(@Nonnull String output) {
        String validValues = "html serial serial-append html,serial html,serial-append serial,html serial-append,html";
        this.modifyConfigurationProperty("output", "html".equals(output = CoverageControl.validateNewPropertyValue("Output", validValues, output)) ? "html-nocp" : output);
    }

    @Nonnull
    private static String validateNewPropertyValue(@Nonnull String propertyName, @Nonnull String validValues, @Nonnull String newValue) {
        String valueWithNoSpaces = newValue.replace(" ", "");
        if (validValues.contains(valueWithNoSpaces)) {
            return valueWithNoSpaces;
        }
        throw new IllegalArgumentException("Invalid value for \"" + propertyName + "\" property: " + newValue);
    }

    @Override
    @Nonnull
    public String getWorkingDir() {
        return new File(".").getAbsoluteFile().getParent();
    }

    @Override
    @Nonnull
    public String getOutputDir() {
        return CoverageControl.getProperty("outputDir");
    }

    @Override
    public void setOutputDir(@Nonnull String outputDir) {
        this.modifyConfigurationProperty("outputDir", outputDir);
    }

    @Override
    @Nonnull
    public String getSrcDirs() {
        return CoverageControl.getProperty("srcDirs");
    }

    @Override
    public void setSrcDirs(@Nonnull String srcDirs) {
        this.modifyConfigurationProperty("srcDirs", srcDirs);
    }

    @Override
    @Nonnull
    public String getClasses() {
        return CoverageControl.getProperty("classes");
    }

    @Override
    public void setClasses(@Nonnull String classes) {
        this.modifyConfigurationProperty("classes", classes);
    }

    @Override
    @Nonnull
    public String getExcludes() {
        return CoverageControl.getProperty("excludes");
    }

    @Override
    public void setExcludes(@Nonnull String excludes) {
        this.modifyConfigurationProperty("excludes", excludes);
    }

    @Override
    @Nonnull
    public String getMetrics() {
        return CoverageControl.getProperty("metrics", "line");
    }

    @Override
    public void setMetrics(@Nonnull String metrics) {
        if (metrics.isEmpty()) {
            throw new IllegalArgumentException("Please select a valid value for the \"Metrics\" property");
        }
        metrics = CoverageControl.validateNewPropertyValue("Metrics", "all line path line,path", metrics);
        this.modifyConfigurationProperty("metrics", metrics);
    }

    @Nonnull
    private static String getProperty(@Nonnull String property) {
        return CoverageControl.getProperty(property, "");
    }

    @Nonnull
    private static String getProperty(@Nonnull String property, @Nonnull String defaultValue) {
        return Configuration.getProperty(CoverageControl.propertyNameSuffix(property), defaultValue);
    }

    @Nonnull
    private static String propertyNameSuffix(@Nonnull String name) {
        return Character.toLowerCase(name.charAt(0)) + name.substring(1);
    }

    private void modifyConfigurationProperty(@Nonnull String name, @Nonnull String value) {
        CoverageControl.setConfigurationProperty(name, value);
        CodeCoverage.resetConfiguration();
        this.store();
    }

    private static void setConfigurationProperty(@Nonnull String name, @Nonnull String value) {
        Configuration.setProperty(CoverageControl.propertyNameSuffix(name), value);
    }

    @Override
    public void generateOutput(boolean resetState) {
        CodeCoverage.generateOutput(resetState);
    }

    @Override
    public void load() throws MBeanException {
        Preferences preferences = Preferences.userNodeForPackage(CoverageControl.class);
        try {
            for (String property : preferences.keys()) {
                String commandLineValue = CoverageControl.getProperty(property);
                if (!commandLineValue.isEmpty()) continue;
                String value = preferences.get(property, "");
                CoverageControl.setConfigurationProperty(property, value);
            }
        }
        catch (BackingStoreException e) {
            throw new MBeanException(e);
        }
    }

    @Override
    public void store() {
        Preferences preferences = Preferences.userNodeForPackage(CoverageControl.class);
        for (MBeanAttributeInfo info : this.getMBeanInfo().getAttributes()) {
            String property = info.getName();
            String value = CoverageControl.getProperty(property);
            preferences.put(property, value);
        }
        try {
            preferences.flush();
        }
        catch (BackingStoreException e) {
            throw new RuntimeException(e);
        }
    }
}

