/*
 * Decompiled with CFR 0.152.
 */
package org.jmockring.utils.dbunit;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.dbunit.IDatabaseTester;
import org.dbunit.IOperationListener;
import org.dbunit.JdbcDatabaseTester;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.CompositeDataSet;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.xml.FlatXmlDataSetBuilder;
import org.dbunit.operation.DatabaseOperation;
import org.jmockring.utils.dbunit.DbUnitPostExecutor;
import org.jmockring.utils.dbunit.DbUnitTuner;
import org.jmockring.utils.dbunit.PropertyUtil;
import org.junit.rules.ExternalResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbUnitRule
extends ExternalResource
implements IOperationListener {
    private static final Logger log = LoggerFactory.getLogger(DbUnitRule.class);
    private String[] dataSetFileNames;
    private IDatabaseTester databaseTester;
    private boolean debugOnExit;
    private CompositeDataSet loadedDataSet;
    private DbUnitPostExecutor postExecutor;
    private DatabaseOperation setupOperation = DatabaseOperation.CLEAN_INSERT;
    private DatabaseOperation tearDownOperation = DatabaseOperation.DELETE_ALL;
    private DbUnitTuner tuner;

    public DbUnitRule(String propertiesFileName, String ... dataSetFileNames) {
        Properties properties = new Properties();
        try {
            String fileName = PropertyUtil.configurePlaceholders(propertiesFileName);
            properties.load(DbUnitRule.class.getResourceAsStream((fileName.startsWith("/") ? "" : "/") + fileName));
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        this.init(properties, dataSetFileNames);
    }

    public DbUnitRule(Properties properties, String ... dataSetFileNames) {
        this.init(properties, dataSetFileNames);
    }

    public void connectionRetrieved(IDatabaseConnection connection) {
        if (this.tuner != null) {
            this.tuner.tune(connection);
        }
    }

    public DbUnitRule debugOnExit() {
        this.debugOnExit = true;
        return this;
    }

    public void operationSetUpFinished(IDatabaseConnection connection) {
        this.closeConnection(connection);
    }

    public void operationTearDownFinished(IDatabaseConnection connection) {
        this.closeConnection(connection);
        if (this.postExecutor != null) {
            this.postExecutor.execute(connection);
        }
    }

    public IDatabaseTester getDatabaseTester() {
        return this.databaseTester;
    }

    public DbUnitRule withPostExecutor(DbUnitPostExecutor postExecutor) {
        this.postExecutor = postExecutor;
        return this;
    }

    public DbUnitRule withSetupOperation(DatabaseOperation setupOperation) {
        this.setupOperation = setupOperation;
        return this;
    }

    public DbUnitRule withTearDownOperation(DatabaseOperation tearDownOperation) {
        this.tearDownOperation = tearDownOperation;
        return this;
    }

    public DbUnitRule withTuner(DbUnitTuner tuner) {
        this.tuner = tuner;
        return this;
    }

    protected void before() throws Throwable {
        this.loadedDataSet = new CompositeDataSet(this.buildDataSets(this.dataSetFileNames));
        this.databaseTester.setDataSet((IDataSet)this.loadedDataSet);
        this.databaseTester.onSetup();
    }

    protected void after() {
        try {
            if (this.debugOnExit) {
                this.debug(this.databaseTester.getConnection().getConnection());
            }
            this.databaseTester.onTearDown();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private void debug(Connection connection) throws SQLException {
        ResultSet rs = connection.getMetaData().getTables(null, null, null, new String[]{"TABLE", "VIEW"});
        StringBuilder sb = new StringBuilder();
        while (rs.next()) {
            String tableName = rs.getString("TABLE_NAME");
            sb.append("\n" + tableName);
            ResultSet rr = connection.createStatement().executeQuery("SHOW COLUMNS FROM " + tableName);
            while (rr.next()) {
                sb.append("\n\t" + rr.getString(1) + "  |  " + rr.getString(2));
            }
        }
        System.out.println(sb);
    }

    private IDataSet[] buildDataSets(String[] dataSetFileNames) throws DataSetException {
        IDataSet[] dataSets = new IDataSet[dataSetFileNames.length];
        int i = 0;
        FlatXmlDataSetBuilder flatXmlDataSetBuilder = new FlatXmlDataSetBuilder();
        flatXmlDataSetBuilder.setColumnSensing(true);
        for (String fileName : dataSetFileNames) {
            dataSets[i++] = flatXmlDataSetBuilder.build(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(fileName));
        }
        return dataSets;
    }

    private void closeConnection(IDatabaseConnection connection) {
        try {
            connection.close();
        }
        catch (SQLException e) {
            log.warn("Exception while closing the connection: " + e, (Throwable)e);
        }
    }

    private void init(Properties properties, String ... dataSetFileNames) {
        this.dataSetFileNames = dataSetFileNames;
        try {
            this.databaseTester = new JdbcDatabaseTester(PropertyUtil.getProperty(properties, "dbunit.driver"), PropertyUtil.getProperty(properties, "dbunit.connectionUrl"), PropertyUtil.getProperty(properties, "dbunit.user"), PropertyUtil.getProperty(properties, "dbunit.password")){

                protected DatabaseOperation getSetUpOperation() {
                    return DbUnitRule.this.setupOperation;
                }

                protected DatabaseOperation getTearDownOperation() {
                    return DbUnitRule.this.tearDownOperation;
                }
            };
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
        this.databaseTester.setOperationListener((IOperationListener)this);
    }
}

