/*
 * Decompiled with CFR 0.152.
 */
package org.jmockring.utils.hamcrest;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.beanutils.NestedNullException;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;

public class CollectionIntrospectMatcher
extends BaseMatcher<Collection> {
    List<Introspect> introspects = new ArrayList<Introspect>();
    private int expectedSize = -1;
    private boolean nullValueDetected;
    private int realSize;

    public static CollectionIntrospectMatcher collectionWithSize(int expectedSize) {
        return new CollectionIntrospectMatcher().hasSize(expectedSize);
    }

    public CollectionIntrospectMatcher andWhere(String property, Matcher matcher) {
        if (this.introspects.size() == 0) {
            throw new IllegalStateException("No introspects yet. Call #hasElementWith() at least once");
        }
        this.introspects.get(this.introspects.size() - 1).add(property, matcher);
        return this;
    }

    public CollectionIntrospectMatcher andWith(String property, Object value) {
        if (this.introspects.size() == 0) {
            throw new IllegalStateException("No introspects yet. Call #hasElementWith() at least once");
        }
        this.introspects.get(this.introspects.size() - 1).add(property, value);
        return this;
    }

    public void describeMismatch(Object item, Description description) {
        super.describeMismatch((Object)this.convertToString((Collection)item), description);
    }

    public void describeTo(Description description) {
        if (this.nullValueDetected) {
            description.appendText("Non-null collection");
        } else if (this.expectedSize >= 0 && this.expectedSize != this.realSize) {
            description.appendText(String.format("Size of [%s], but real size was [%s]", this.expectedSize, this.realSize));
        } else {
            description.appendText("\n");
            for (Introspect introspect : this.introspects) {
                description.appendValue((Object)introspect);
                description.appendText(introspect.matched ? " >> Matched \n" : " >> Unmatched \n");
                if (introspect.failedValues == null) continue;
                description.appendText("\t> Failed values: ");
                for (Object failedValue : introspect.failedValues) {
                    description.appendText("\n \t\t > " + failedValue);
                }
                description.appendText("\n");
            }
        }
    }

    public final CollectionIntrospectMatcher hasElementWhere(String property, Matcher matcher) {
        this.introspects.add(new Introspect(property, matcher));
        return this;
    }

    public final CollectionIntrospectMatcher hasElementWith(String property, Object value) {
        this.introspects.add(new Introspect(property, value));
        return this;
    }

    private CollectionIntrospectMatcher hasSize(int expectedSize) {
        if (expectedSize < 0) {
            throw new IllegalArgumentException("Illegal value for collection size: " + expectedSize);
        }
        if (this.expectedSize >= 0) {
            throw new IllegalStateException("Expected collection size already specified: " + expectedSize + ". Did you call #hasSize() twice?");
        }
        this.expectedSize = expectedSize;
        return this;
    }

    public boolean matches(Object input) {
        if (this.expectedSize >= 0 && this.expectedSize < this.introspects.size()) {
            throw new IllegalStateException(String.format("Expected size [%s] is less than the defined number of introspections [%s]. Must be equal(ideally) or greater.", this.expectedSize, this.introspects.size()));
        }
        if (this.introspects.size() == 0) {
            throw new IllegalStateException("No introspections defined. If only collection size is asserted, consider using the standard hamcrest matchers which provide better error feedback.");
        }
        this.nullValueDetected = input == null;
        if (this.nullValueDetected) {
            return false;
        }
        Collection collection = (Collection)input;
        this.realSize = collection.size();
        if (this.expectedSize >= 0 && this.realSize != this.expectedSize) {
            return false;
        }
        PropertyUtilsBean propertyBean = new PropertyUtilsBean();
        for (Introspect introspect : this.introspects) {
            introspect.matched = false;
            ArrayList<Object> failedValues = new ArrayList<Object>();
            propertyBean.clearDescriptors();
            for (Object item : collection) {
                boolean introspectMatched = true;
                for (Map.Entry<String, Object> entry : introspect.fields.entrySet()) {
                    String propertyName = entry.getKey();
                    Object expectedValue = entry.getValue();
                    try {
                        Object realValue = this.getRealValue(propertyBean, item, propertyName);
                        if (expectedValue instanceof Matcher) {
                            Matcher matcher = (Matcher)expectedValue;
                            if (matcher.matches(realValue)) continue;
                            failedValues.add(realValue);
                            introspectMatched = false;
                            break;
                        }
                        if ((expectedValue != null || realValue == null) && (expectedValue == null || expectedValue.equals(realValue))) continue;
                        failedValues.add(realValue);
                        introspectMatched = false;
                        break;
                    }
                    catch (NoSuchFieldException e) {
                        throw new IllegalArgumentException(String.format("No public property or accessors for '%s' found in class '%s'", propertyName, item.getClass().getName()), e);
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("Illegal method call", e);
                    }
                }
                if (!introspectMatched) continue;
                introspect.matched = true;
                break;
            }
            if (introspect.matched) continue;
            introspect.failedValues = failedValues;
        }
        return (this.expectedSize < 0 || this.expectedSize == this.realSize) && Iterables.all(this.introspects, (Predicate)new Predicate<Introspect>(){

            public boolean apply(@Nullable Introspect input) {
                assert (input != null);
                return input.matched;
            }
        });
    }

    private String convertToString(Collection elements) {
        if (elements == null) {
            return "NULL";
        }
        StringBuilder sb = new StringBuilder("Collection of type: ").append(elements.getClass().getName()).append(" [");
        int i = 0;
        for (Object elt : elements) {
            sb.append(++i).append(". ").append(elt == null ? null : elt.toString()).append("\n");
        }
        return sb.append("]").toString();
    }

    private Object getRealValue(PropertyUtilsBean propertyBean, Object item, String propertyName) throws IllegalAccessException, InvocationTargetException, NoSuchFieldException {
        Object realValue;
        block4: {
            realValue = null;
            try {
                realValue = propertyBean.getProperty(item, propertyName);
            }
            catch (NestedNullException e) {
                return realValue;
            }
            catch (NoSuchMethodException e) {
                String[] nestedFieldNames = propertyName.split("\\.");
                if (nestedFieldNames.length < 1) break block4;
                Field publicField = item.getClass().getField(nestedFieldNames[0]);
                realValue = publicField.get(item);
                if (nestedFieldNames.length == 2) {
                    Field publicField2 = realValue.getClass().getField(nestedFieldNames[1]);
                    realValue = publicField2.get(realValue);
                }
                if (nestedFieldNames.length <= 2) break block4;
                throw new UnsupportedOperationException("Double-nested public fields not supported", e);
            }
        }
        return realValue;
    }

    static final class Introspect {
        public List<Object> failedValues;
        Map<String, Object> fields = new HashMap<String, Object>();
        boolean matched = false;

        private Introspect(String property, Object value) {
            this.fields.put(property, value);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Introspect");
            sb.append("{fields=").append(this.fields);
            sb.append('}');
            return sb.toString();
        }

        private Introspect add(String property, Object value) {
            this.fields.put(property, value);
            return this;
        }
    }
}

