/*
 * Decompiled with CFR 0.152.
 */
package org.jmolecules.annotation.processor.aptk.tools;

import java.util.HashSet;
import java.util.Set;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Types;
import org.jmolecules.annotation.processor.aptk.tools.ProcessingEnvironmentUtils;
import org.jmolecules.annotation.processor.aptk.tools.generics.GenericType;
import org.jmolecules.annotation.processor.aptk.tools.generics.GenericTypeKind;
import org.jmolecules.annotation.processor.aptk.tools.generics.GenericTypeParameter;
import org.jmolecules.annotation.processor.aptk.tools.generics.GenericTypeWildcard;

public final class TypeUtils {
    private TypeUtils() {
    }

    public static Types getTypes() {
        return ProcessingEnvironmentUtils.getTypes();
    }

    public static final class Generics {
        public static <T extends GenericTypeParameter> GenericType createGenericType(TypeMirror rawType, T ... typeParameters) {
            return new GenericType(rawType, typeParameters);
        }

        public static <T extends GenericTypeParameter> GenericType createGenericType(Class<?> rawType, T ... typeParameters) {
            return Generics.createGenericType((TypeMirror)TypeRetrieval.getTypeMirror(rawType), typeParameters);
        }

        public static <T extends GenericTypeParameter> GenericType createGenericType(String rawType, T ... typeParameters) {
            return Generics.createGenericType((TypeMirror)TypeRetrieval.getTypeMirror(rawType), typeParameters);
        }

        public static GenericTypeWildcard createWildcardWithExtendsBound(GenericType extendsBound) {
            return GenericTypeWildcard.createExtendsWildcard(extendsBound);
        }

        public static GenericTypeWildcard createWildcardWithSuperBound(GenericType superBound) {
            return GenericTypeWildcard.createSuperWildcard(superBound);
        }

        public static GenericTypeWildcard createPureWildcard() {
            return GenericTypeWildcard.createPureWildcard();
        }

        public static boolean genericTypeEquals(TypeMirror typeMirror, GenericType genericType) {
            if (typeMirror == null || genericType == null) {
                return false;
            }
            return Generics.compareGenericTypesRecursively(typeMirror, genericType);
        }

        private static boolean compareGenericTypesRecursively(TypeMirror typeMirror, GenericType genericType) {
            TypeMirror typeMirrorToCompareWith = genericType.getRawType();
            if (typeMirrorToCompareWith == null) {
                return false;
            }
            if (!TypeComparison.isErasedTypeEqual(typeMirror, typeMirrorToCompareWith)) {
                return false;
            }
            if (!(typeMirror instanceof DeclaredType)) {
                return false;
            }
            DeclaredType tmDeclaredType = (DeclaredType)typeMirror;
            if (tmDeclaredType.getTypeArguments().size() != genericType.getTypeParameters().length) {
                return false;
            }
            if (genericType.getTypeParameters().length > 0) {
                for (int i = 0; i < genericType.getTypeParameters().length; ++i) {
                    TypeMirror currentTypeParameter = tmDeclaredType.getTypeArguments().get(i);
                    GenericTypeParameter currentGenericTypeParameter = genericType.getTypeParameters()[i];
                    if (!(currentTypeParameter instanceof WildcardType ? !Generics.compareGenericTypeWildcardRecursively((WildcardType)currentTypeParameter, currentGenericTypeParameter) : currentTypeParameter instanceof DeclaredType && !Generics.compareGenericTypeDeclaredTypeRecursively((DeclaredType)currentTypeParameter, currentGenericTypeParameter))) continue;
                    return false;
                }
            }
            return true;
        }

        protected static boolean compareGenericTypeWildcardRecursively(WildcardType wildcardType, GenericTypeParameter genericTypeParameter) {
            if (genericTypeParameter.getType() != GenericTypeKind.WILDCARD) {
                return false;
            }
            GenericTypeWildcard wc = (GenericTypeWildcard)genericTypeParameter;
            if (wc.isPureWildcard()) {
                if (wildcardType.getExtendsBound() != null && wildcardType.getSuperBound() != null) {
                    return false;
                }
            } else {
                if (wildcardType.getExtendsBound() != null ? !wc.hasExtendsBound() || !Generics.compareGenericTypesRecursively(wildcardType.getExtendsBound(), wc.getExtendsBound()) : wc.hasExtendsBound()) {
                    return false;
                }
                if (wildcardType.getSuperBound() != null ? !wc.hasSuperBound() || !Generics.compareGenericTypesRecursively(wildcardType.getSuperBound(), wc.getSuperBound()) : wc.hasSuperBound()) {
                    return false;
                }
            }
            return true;
        }

        private static boolean compareGenericTypeDeclaredTypeRecursively(DeclaredType declaredType, GenericTypeParameter genericTypeParameter) {
            if (genericTypeParameter == null || genericTypeParameter.getType() != GenericTypeKind.GENERIC_TYPE) {
                return false;
            }
            GenericType genericType = (GenericType)genericTypeParameter;
            return declaredType == null || Generics.compareGenericTypesRecursively(declaredType, genericType);
        }

        public static boolean genericIsAssignableTo(TypeElement typeElement, GenericType genericType) {
            return typeElement != null && genericType != null && Generics.genericIsAssignableTo(typeElement.asType(), genericType);
        }

        public static boolean genericIsAssignableTo(TypeMirror typeMirror, GenericType genericType) {
            if (typeMirror == null || genericType == null) {
                return false;
            }
            TypeMirror typeMirrorToCompareWith = genericType.getRawType();
            if (typeMirrorToCompareWith == null) {
                return false;
            }
            if (!TypeComparison.isAssignableTo(TypeUtils.getTypes().erasure(typeMirror), TypeUtils.getTypes().erasure(typeMirrorToCompareWith))) {
                return false;
            }
            return Generics.isAssignableToGenericTypeRecursively(typeMirror, genericType);
        }

        private static boolean isAssignableToGenericTypeRecursively(TypeMirror typeMirror, GenericType genericType) {
            if (genericType.getTypeParameters().length > 0) {
                if (!(typeMirror instanceof DeclaredType)) {
                    return false;
                }
                DeclaredType tmDeclaredType = (DeclaredType)typeMirror;
                if (tmDeclaredType.getTypeArguments().size() != genericType.getTypeParameters().length) {
                    return false;
                }
                for (int i = 0; i < genericType.getTypeParameters().length; ++i) {
                    TypeMirror currentTypeParameter = tmDeclaredType.getTypeArguments().get(i);
                    GenericTypeParameter currentGenericTypeParameter = genericType.getTypeParameters()[i];
                    if (!(currentTypeParameter instanceof WildcardType ? !Generics.isAssignableToGenericTypeHandleWildcardTypeRecursively((WildcardType)currentTypeParameter, currentGenericTypeParameter) : currentTypeParameter instanceof DeclaredType && !Generics.isAssignableToGenericTypeHandleDeclaredTypeRecursively((DeclaredType)currentTypeParameter, currentGenericTypeParameter))) continue;
                    return false;
                }
            }
            return true;
        }

        private static boolean isAssignableToGenericTypeHandleWildcardTypeRecursively(WildcardType wildcardType, GenericTypeParameter genericTypeParameter) {
            if (wildcardType == null || genericTypeParameter == null) {
                return false;
            }
            if (genericTypeParameter.getType() == GenericTypeKind.GENERIC_TYPE) {
                return false;
            }
            if (wildcardType.getExtendsBound() == null && wildcardType.getSuperBound() == null) {
                return ((GenericTypeWildcard)genericTypeParameter).isPureWildcard();
            }
            if (wildcardType.getExtendsBound() != null) {
                if (((GenericTypeWildcard)genericTypeParameter).isPureWildcard()) {
                    return true;
                }
                if (((GenericTypeWildcard)genericTypeParameter).hasExtendsBound()) {
                    GenericTypeWildcard wildcard = (GenericTypeWildcard)genericTypeParameter;
                    if (!TypeComparison.isAssignableTo(TypeUtils.getTypes().erasure(wildcardType.getExtendsBound()), TypeUtils.getTypes().erasure(wildcard.getExtendsBound().getRawType()))) {
                        return false;
                    }
                    return Generics.isAssignableToGenericTypeRecursively(wildcardType.getExtendsBound(), wildcard.getExtendsBound());
                }
                return false;
            }
            if (((GenericTypeWildcard)genericTypeParameter).isPureWildcard()) {
                return true;
            }
            if (((GenericTypeWildcard)genericTypeParameter).hasSuperBound()) {
                GenericTypeWildcard wildcard = (GenericTypeWildcard)genericTypeParameter;
                if (!TypeComparison.isAssignableTo(TypeUtils.getTypes().erasure(wildcard.getSuperBound().getRawType()), TypeUtils.getTypes().erasure(wildcardType.getSuperBound()))) {
                    return false;
                }
                return Generics.isAssignableToGenericTypeRecursively(wildcardType.getSuperBound(), wildcard.getSuperBound());
            }
            return false;
        }

        private static boolean isAssignableToGenericTypeHandleDeclaredTypeRecursively(DeclaredType declaredType, GenericTypeParameter genericTypeParameter) {
            if (genericTypeParameter.getType() == GenericTypeKind.WILDCARD) {
                GenericTypeWildcard wildcard = (GenericTypeWildcard)genericTypeParameter;
                if (wildcard.isPureWildcard()) {
                    return true;
                }
                if (wildcard.hasSuperBound()) {
                    if (!TypeComparison.isAssignableTo(TypeUtils.getTypes().erasure(wildcard.getSuperBound().getRawType()), TypeUtils.getTypes().erasure(declaredType))) {
                        return false;
                    }
                    return Generics.isAssignableToGenericTypeRecursively(declaredType, wildcard.getSuperBound());
                }
                if (!TypeComparison.isAssignableTo(TypeUtils.getTypes().erasure(declaredType), TypeUtils.getTypes().erasure(wildcard.getExtendsBound().getRawType()))) {
                    return false;
                }
                return Generics.isAssignableToGenericTypeRecursively(declaredType, wildcard.getExtendsBound());
            }
            GenericType genericType = (GenericType)genericTypeParameter;
            if (!TypeComparison.isErasedTypeEqual(TypeUtils.getTypes().erasure(declaredType), TypeUtils.getTypes().erasure(genericType.getRawType()))) {
                return false;
            }
            return Generics.isAssignableToGenericTypeRecursively(declaredType, genericType);
        }
    }

    public static final class Arrays {
        private Arrays() {
        }

        public static boolean isArray(TypeMirror typeMirror) {
            return typeMirror != null && typeMirror.getKind().equals((Object)TypeKind.ARRAY);
        }

        public static TypeMirror getArraysComponentType(TypeMirror typeMirror) {
            return typeMirror != null && CheckTypeKind.isArray(typeMirror) ? ((ArrayType)typeMirror).getComponentType() : null;
        }

        public static boolean isArrayOfType(TypeMirror typeMirror, Class<?> type) {
            return type != null && Arrays.isArrayOfType(typeMirror, TypeRetrieval.getTypeMirror(type));
        }

        public static boolean isArrayOfType(TypeMirror typeMirror, String fullQualifiedClassName) {
            return fullQualifiedClassName != null && Arrays.isArrayOfType(typeMirror, TypeRetrieval.getTypeMirror(fullQualifiedClassName));
        }

        public static boolean isArrayOfType(TypeMirror typeMirror, TypeMirror componentType) {
            return typeMirror != null && componentType != null && CheckTypeKind.isArray(typeMirror) && TypeComparison.isTypeEqual(Arrays.getArraysComponentType(typeMirror), componentType);
        }

        public static boolean isArrayOfType(TypeMirror typeMirror, GenericType genericType) {
            return typeMirror != null && genericType != null && CheckTypeKind.isArray(typeMirror) && TypeComparison.isTypeEqual(Arrays.getArraysComponentType(typeMirror), genericType);
        }

        public static boolean isArrayAssignableTo(TypeMirror typeMirror, Class<?> type) {
            return type != null && Arrays.isArrayAssignableTo(typeMirror, TypeRetrieval.getTypeMirror(type));
        }

        public static boolean isArrayAssignableTo(TypeMirror typeMirror, String fullQualifiedClassName) {
            return fullQualifiedClassName != null && Arrays.isArrayAssignableTo(typeMirror, TypeRetrieval.getTypeMirror(fullQualifiedClassName));
        }

        public static boolean isArrayAssignableTo(TypeMirror typeMirror, TypeMirror componentType) {
            return typeMirror != null && componentType != null && CheckTypeKind.isArray(typeMirror) && TypeComparison.isAssignableTo(Arrays.getArraysComponentType(typeMirror), componentType);
        }

        public static boolean isArrayAssignableTo(TypeMirror typeMirror, GenericType genericType) {
            return typeMirror != null && genericType != null && CheckTypeKind.isArray(typeMirror) && TypeComparison.isAssignableTo(Arrays.getArraysComponentType(typeMirror), genericType);
        }

        public static boolean isErasedArrayAssignableTo(TypeMirror typeMirror1, TypeMirror typeMirror2) {
            return typeMirror1 != null && typeMirror2 != null && TypeComparison.isAssignableTo(TypeUtils.getTypes().erasure(Arrays.getArraysComponentType(typeMirror1)), TypeUtils.getTypes().erasure(typeMirror2));
        }
    }

    public static final class TypeComparison {
        private TypeComparison() {
        }

        public static boolean isAssignableTo(TypeElement typeElement, Class<?> type) {
            return TypeComparison.isAssignableTo(typeElement, ProcessingEnvironmentUtils.getElements().getTypeElement(type.getCanonicalName()).asType());
        }

        public static boolean isAssignableTo(TypeElement typeElement, TypeMirror typeMirror) {
            return typeElement != null && TypeComparison.isAssignableTo(typeElement.asType(), typeMirror);
        }

        public static boolean isAssignableTo(TypeElement typeElement1, TypeElement typeElement2) {
            return TypeComparison.isAssignableTo(typeElement1, typeElement2.asType());
        }

        public static boolean isAssignableTo(TypeMirror typeMirror1, Class<?> type) {
            return TypeComparison.isAssignableTo(typeMirror1, TypeRetrieval.getTypeMirror(type));
        }

        public static boolean isAssignableTo(TypeMirror typeMirror1, TypeMirror typeMirror2) {
            return typeMirror1 != null && typeMirror2 != null && ProcessingEnvironmentUtils.getTypes().isAssignable(typeMirror1, typeMirror2);
        }

        public static boolean isAssignableTo(TypeElement typeElement, GenericType genericType) {
            return typeElement != null && genericType != null && TypeComparison.isAssignableTo(typeElement.asType(), genericType);
        }

        public static boolean isAssignableTo(TypeMirror typeMirror, GenericType genericType) {
            return typeMirror != null && genericType != null && Generics.genericIsAssignableTo(typeMirror, genericType);
        }

        public static boolean isTypeEqual(TypeElement typeElement, Class<?> type) {
            if (typeElement == null || type == null) {
                return false;
            }
            TypeElement secondTypeElement = TypeRetrieval.getTypeElement(type);
            return secondTypeElement != null && TypeComparison.isErasedTypeEqual(typeElement.asType(), secondTypeElement.asType());
        }

        public static boolean isTypeEqual(TypeElement typeElement, TypeMirror typeMirror) {
            return typeElement != null && typeMirror != null && ProcessingEnvironmentUtils.getTypes().isSameType(typeElement.asType(), typeMirror);
        }

        public static boolean isTypeEqual(TypeElement typeElement1, TypeElement typeElement2) {
            return typeElement1 != null && typeElement2 != null && TypeComparison.isTypeEqual(typeElement1, typeElement2.asType());
        }

        public static boolean isTypeEqual(TypeMirror typeMirror, Class<?> type) {
            return typeMirror != null && type != null && TypeComparison.isErasedTypeEqual(typeMirror, TypeRetrieval.getTypeMirror(type));
        }

        public static boolean isTypeEqual(TypeMirror typeMirror1, TypeMirror typeMirror2) {
            return typeMirror1 != null && typeMirror2 != null && TypeUtils.getTypes().isSameType(typeMirror1, typeMirror2);
        }

        public static boolean isTypeEqual(TypeMirror typeMirror, GenericType genericType) {
            return Generics.genericTypeEquals(typeMirror, genericType);
        }

        public static boolean isErasedTypeEqual(TypeMirror typeMirror1, TypeMirror typeMirror2) {
            return typeMirror1 != null && typeMirror2 != null && TypeUtils.getTypes().isSameType(TypeUtils.getTypes().erasure(typeMirror1), TypeUtils.getTypes().erasure(typeMirror2));
        }
    }

    public static final class TypeRetrieval {
        private static final Set<String> primitiveTypeNameSet = new HashSet<String>();

        private TypeRetrieval() {
        }

        public static TypeElement getTypeElement(String fullQualifiedClassName) {
            if (fullQualifiedClassName == null) {
                return null;
            }
            return ProcessingEnvironmentUtils.getElements().getTypeElement(fullQualifiedClassName);
        }

        public static TypeElement getTypeElement(TypeMirror typeMirror) {
            if (typeMirror == null) {
                return null;
            }
            if (CheckTypeKind.isDeclared(typeMirror)) {
                DeclaredType declaredType = (DeclaredType)typeMirror;
                return (TypeElement)declaredType.asElement();
            }
            return null;
        }

        public static TypeMirror getTypeMirror(String fullQualifiedClassName) {
            if (fullQualifiedClassName == null) {
                return null;
            }
            if (primitiveTypeNameSet.contains(fullQualifiedClassName)) {
                return ProcessingEnvironmentUtils.getTypes().getPrimitiveType(TypeKind.valueOf(fullQualifiedClassName.toUpperCase()));
            }
            if (fullQualifiedClassName.endsWith("[]")) {
                return ProcessingEnvironmentUtils.getTypes().getArrayType(TypeRetrieval.getTypeMirror(fullQualifiedClassName.substring(0, fullQualifiedClassName.length() - 2)));
            }
            TypeElement typeElement = TypeRetrieval.getTypeElement(fullQualifiedClassName);
            return typeElement != null ? typeElement.asType() : null;
        }

        public static TypeElement getTypeElement(Class<?> type) {
            TypeMirror typeMirror = TypeRetrieval.getTypeMirror(type);
            return typeMirror == null ? null : (TypeElement)ProcessingEnvironmentUtils.getTypes().asElement(typeMirror);
        }

        public static TypeMirror getTypeMirror(Class<?> type) {
            if (type == null || type.isAnonymousClass()) {
                return null;
            }
            if (type.isArray()) {
                return ProcessingEnvironmentUtils.getTypes().getArrayType(TypeRetrieval.getTypeMirror(type.getComponentType()));
            }
            if (type.isPrimitive()) {
                return TypeRetrieval.getPrimitiveTypeMirror(type);
            }
            return ProcessingEnvironmentUtils.getElements().getTypeElement(type.getCanonicalName()).asType();
        }

        public static TypeMirror getErasedTypeMirror(Class<?> type) {
            return ProcessingEnvironmentUtils.getTypes().erasure(TypeRetrieval.getTypeMirror(type));
        }

        public static TypeMirror getPrimitiveTypeMirror(Class<?> primitiveType) {
            if (primitiveType == null || !primitiveType.isPrimitive()) {
                return null;
            }
            if (Boolean.TYPE.equals(primitiveType)) {
                return TypeUtils.getTypes().getPrimitiveType(TypeKind.BOOLEAN);
            }
            if (Byte.TYPE.equals(primitiveType)) {
                return TypeUtils.getTypes().getPrimitiveType(TypeKind.BYTE);
            }
            if (Character.TYPE.equals(primitiveType)) {
                return TypeUtils.getTypes().getPrimitiveType(TypeKind.CHAR);
            }
            if (Double.TYPE.equals(primitiveType)) {
                return TypeUtils.getTypes().getPrimitiveType(TypeKind.DOUBLE);
            }
            if (Float.TYPE.equals(primitiveType)) {
                return TypeUtils.getTypes().getPrimitiveType(TypeKind.FLOAT);
            }
            if (Integer.TYPE.equals(primitiveType)) {
                return TypeUtils.getTypes().getPrimitiveType(TypeKind.INT);
            }
            if (Long.TYPE.equals(primitiveType)) {
                return TypeUtils.getTypes().getPrimitiveType(TypeKind.LONG);
            }
            if (Short.TYPE.equals(primitiveType)) {
                return TypeUtils.getTypes().getPrimitiveType(TypeKind.SHORT);
            }
            return null;
        }

        static {
            primitiveTypeNameSet.add("short");
            primitiveTypeNameSet.add("int");
            primitiveTypeNameSet.add("long");
            primitiveTypeNameSet.add("float");
            primitiveTypeNameSet.add("double");
            primitiveTypeNameSet.add("char");
            primitiveTypeNameSet.add("byte");
            primitiveTypeNameSet.add("boolean");
        }
    }

    public static final class TypeConversion {
        private TypeConversion() {
        }

        public static String convertToFqn(TypeMirror typeMirror) {
            TypeMirror erasedTypeMirror = TypeUtils.getTypes().erasure(typeMirror);
            return erasedTypeMirror.toString();
        }
    }

    public static final class CheckTypeKind {
        private CheckTypeKind() {
        }

        public static boolean isVoid(TypeMirror typeMirror) {
            return CheckTypeKind.isOfTypeKind(typeMirror, TypeKind.VOID);
        }

        public static boolean isArray(TypeMirror typeMirror) {
            return CheckTypeKind.isOfTypeKind(typeMirror, TypeKind.ARRAY);
        }

        public static boolean isPrimitive(TypeMirror typeMirror) {
            return typeMirror != null && typeMirror.getKind().isPrimitive();
        }

        public static boolean isDeclared(TypeMirror typeMirror) {
            return CheckTypeKind.isOfTypeKind(typeMirror, TypeKind.DECLARED);
        }

        public static boolean isTypeVar(TypeMirror typeMirror) {
            return CheckTypeKind.isOfTypeKind(typeMirror, TypeKind.TYPEVAR);
        }

        public static boolean isExecutable(TypeMirror typeMirror) {
            return CheckTypeKind.isOfTypeKind(typeMirror, TypeKind.EXECUTABLE);
        }

        public static boolean isWildcard(TypeMirror typeMirror) {
            return CheckTypeKind.isOfTypeKind(typeMirror, TypeKind.WILDCARD);
        }

        public static boolean isError(TypeMirror typeMirror) {
            return CheckTypeKind.isOfTypeKind(typeMirror, TypeKind.ERROR);
        }

        public static boolean isOfTypeKind(TypeMirror typeMirror, TypeKind kind) {
            return typeMirror != null && kind != null && kind.equals((Object)typeMirror.getKind());
        }
    }
}

