/*
 * Decompiled with CFR 0.152.
 */
package org.jmolecules.annotation.processor.aptk.templating.templateblocks;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jmolecules.annotation.processor.aptk.templating.ModelPathResolver;
import org.jmolecules.annotation.processor.aptk.templating.ParseUtilities;
import org.jmolecules.annotation.processor.aptk.templating.TemplateProcessor;
import org.jmolecules.annotation.processor.aptk.templating.templateblocks.TemplateBlock;
import org.jmolecules.annotation.processor.aptk.templating.templateblocks.TemplateBlockType;

public class IncludeTemplateBlock
implements TemplateBlock {
    static final String ATTRIBUTE_NAME_RESOURCE = "resource";
    static final String ATTRIBUTE_NAME_MODEL = "model";
    private final String modelDefinitionString;
    private final String modelAccessPath;
    private final String templateResource;
    private final String templateString;

    public IncludeTemplateBlock(String attributeString, String modelDefinitionString) {
        if (attributeString == null || attributeString.trim().isEmpty()) {
            throw new IllegalArgumentException("include command has no attribute string.");
        }
        Map<String, String> attributeMap = ParseUtilities.parseNamedAttributes(attributeString);
        this.templateResource = attributeMap.get(ATTRIBUTE_NAME_RESOURCE);
        if (this.templateResource == null) {
            throw new IllegalArgumentException("you must set resource at include control block");
        }
        try {
            this.templateString = ParseUtilities.readResourceToString(this.templateResource);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Didn't found included template resource file : " + this.templateResource, e);
        }
        this.modelAccessPath = attributeMap.get(ATTRIBUTE_NAME_MODEL);
        this.modelDefinitionString = modelDefinitionString.trim();
        if (!this.modelDefinitionString.isEmpty() && this.modelAccessPath != null) {
            throw new IllegalArgumentException("INCLUDE: Please use either model attribute or model configuration via INCLUDE command content block.");
        }
    }

    @Override
    public TemplateBlockType getTemplateBlockType() {
        return TemplateBlockType.INCLUDE;
    }

    @Override
    public String getContent(Map<String, Object> variables) {
        Map<String, Object> model;
        if (this.modelAccessPath != null) {
            Object values = ModelPathResolver.resolveModelPath(variables, this.modelAccessPath).getValue();
            model = new HashMap<String, Object>();
            model.put(ATTRIBUTE_NAME_MODEL, values);
        } else {
            model = !this.modelDefinitionString.isEmpty() ? ParseUtilities.extractModelFromString(variables, this.modelDefinitionString) : variables;
        }
        return TemplateProcessor.processTemplate(this.templateString, model);
    }

    public String getModelDefinitionString() {
        return this.modelDefinitionString;
    }

    public String getTemplateResource() {
        return this.templateResource;
    }

    public String getTemplateString() {
        return this.templateString;
    }

    public String getModelAccessPath() {
        return this.modelAccessPath;
    }
}

