/*
 * Decompiled with CFR 0.152.
 */
package org.jmolecules.annotation.processor.aptk.tools;

import java.util.Arrays;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import org.jmolecules.annotation.processor.aptk.api.AnnotationToClassMapper;
import org.jmolecules.annotation.processor.aptk.tools.TypeMirrorWrapper;
import org.jmolecules.annotation.processor.aptk.tools.corematcher.AptkCoreMatchers;
import org.jmolecules.annotation.processor.aptk.tools.corematcher.ValidationMessage;
import org.jmolecules.annotation.processor.aptk.tools.wrapper.AnnotationMirrorWrapper;
import org.jmolecules.annotation.processor.aptk.tools.wrapper.AnnotationValueWrapper;
import org.jmolecules.annotation.processor.aptk.tools.wrapper.ElementWrapper;
import org.jmolecules.annotation.processor.aptk.tools.wrapper.ExecutableElementWrapper;
import org.jmolecules.annotation.processor.aptk.tools.wrapper.TypeElementWrapper;

public class AnnotationToClassMapperHelper {
    private final ElementWrapper<?> elementWrapper;
    private final AnnotationMirrorWrapper annotation;

    private AnnotationToClassMapperHelper(ElementWrapper<?> elementWrapper, AnnotationMirrorWrapper annotation) {
        this.elementWrapper = elementWrapper;
        this.annotation = annotation;
    }

    public static AnnotationToClassMapperHelper getInstance(ElementWrapper<?> elementWrapper, AnnotationMirrorWrapper annotation) {
        return new AnnotationToClassMapperHelper(elementWrapper, annotation);
    }

    AnnotationToClassMapperWrapper getValidatorAnnotation() {
        return AnnotationToClassMapperWrapper.wrap(this.annotation).get();
    }

    AnnotationMirrorWrapper getAnnotationMirrorWrapper() {
        return this.annotation;
    }

    private boolean isLocaleVariableName(String name) {
        return name.matches("[{].*[}]");
    }

    private String getLocalVariableName(String name) {
        Pattern pattern = Pattern.compile("[{](.*)[}]");
        Matcher matcher = pattern.matcher(name);
        return matcher.matches() ? matcher.group(1) : null;
    }

    public boolean validate() {
        AnnotationToClassMapperWrapper mapperAnnotation = this.getValidatorAnnotation();
        TypeMirrorWrapper mappedTypeMirror = mapperAnnotation.mappedClass();
        String[] attributeNamesToConstructorParameterMapping = mapperAnnotation.mappedAttributeNames();
        if (attributeNamesToConstructorParameterMapping.length > 0) {
            String[] invalidNames = (String[])Arrays.stream(attributeNamesToConstructorParameterMapping).filter(e -> !e.isEmpty() && !this.isLocaleVariableName((String)e) && !this.annotation.hasAttribute((String)e)).toArray(String[]::new);
            if (invalidNames.length > 0) {
                this.elementWrapper.compilerMessage(this.annotation.unwrap()).asError().write(InternalValidationMessages.ERROR_BROKEN_VALIDATOR_ATTRIBUTE_NAME_MISMATCH, this.annotation.asElement().getSimpleName(), invalidNames);
                return false;
            }
            block0: for (ExecutableElementWrapper constructor : mappedTypeMirror.getTypeElement().get().getConstructors(Modifier.PUBLIC)) {
                if (constructor.getParameters().size() != attributeNamesToConstructorParameterMapping.length) continue;
                int i = 0;
                for (String attributeName : attributeNamesToConstructorParameterMapping) {
                    if (!this.isLocaleVariableName(attributeName)) {
                        TypeMirrorWrapper attribute;
                        if (attributeName.isEmpty()) {
                            if (!this.elementWrapper.isMethodParameter()) {
                                this.elementWrapper.compilerMessage(this.annotation.unwrap()).asError().write(InternalValidationMessages.ERROR_BROKEN_VALIDATOR_INCORRECT_METHOD_PARAMETER_MAPPING, new Object[0]);
                                return false;
                            }
                            attribute = this.elementWrapper.asType();
                        } else {
                            attribute = this.annotation.getAttributeTypeMirror(attributeName).get();
                        }
                        if (!attribute.isAssignableTo(constructor.getParameters().get(i).asType())) continue block0;
                    }
                    ++i;
                }
                return true;
            }
            this.elementWrapper.compilerMessage(this.annotation.unwrap()).asError().write(InternalValidationMessages.ERROR_BROKEN_VALIDATOR_CONSTRUCTOR_PARAMETER_MAPPING, mappedTypeMirror.getSimpleName());
            return false;
        }
        TypeElementWrapper validatorImplTypeElement = mappedTypeMirror.getTypeElement().get();
        boolean hasNoargConstructor = validatorImplTypeElement.filterEnclosedElements().applyFilter(AptkCoreMatchers.IS_CONSTRUCTOR).applyFilter(AptkCoreMatchers.HAS_NO_PARAMETERS).getResult().size() == 1;
        boolean hasJustDefaultConstructor = validatorImplTypeElement.filterEnclosedElements().applyFilter(AptkCoreMatchers.IS_CONSTRUCTOR).hasSize(0);
        if (!hasNoargConstructor && !hasJustDefaultConstructor) {
            this.elementWrapper.compilerMessage(this.annotation.unwrap()).asError().write(InternalValidationMessages.ERROR_BROKEN_VALIDATOR_MISSING_NOARG_CONSTRUCTOR, validatorImplTypeElement.getSimpleName());
            return false;
        }
        return true;
    }

    public String createInstanceInitializationCommand() {
        StringBuilder stringBuilder = new StringBuilder();
        String genericTypeString = "";
        if (this.getValidatorAnnotation().mappedClass().getTypeElement().get().hasTypeParameters()) {
            TypeMirrorWrapper annotatedElementsTypeMirror = this.elementWrapper.asType();
            genericTypeString = annotatedElementsTypeMirror.isCollection() || annotatedElementsTypeMirror.isIterable() || annotatedElementsTypeMirror.isArray() ? "<" + annotatedElementsTypeMirror.getWrappedComponentType().getTypeDeclaration() + ">" : "<" + annotatedElementsTypeMirror.getTypeDeclaration() + ">";
        }
        stringBuilder.append("new ").append(this.getValidatorAnnotation().mappedClass().getQualifiedName()).append(genericTypeString).append("(").append(this.getMappedAttributeValues()).append(")");
        return stringBuilder.toString();
    }

    public String getMappedAttributeValues() {
        return Arrays.stream(this.getValidatorAnnotation().mappedAttributeNames()).map(e -> {
            if (e.isEmpty()) {
                return this.elementWrapper.getSimpleName();
            }
            if (this.isLocaleVariableName((String)e)) {
                return this.getLocalVariableName((String)e);
            }
            return this.getValidatorExpressionAttributeValueStringRepresentation(this.annotation.getAttributeWithDefault((String)e), this.annotation.getAttributeTypeMirror((String)e).get());
        }).collect(Collectors.joining(", "));
    }

    String getValidatorExpressionAttributeValueStringRepresentation(AnnotationValueWrapper annotationValueWrapper, TypeMirrorWrapper annotationAttributeTypeMirror) {
        if (annotationValueWrapper.isArray()) {
            return annotationValueWrapper.getArrayValue().stream().map(e -> this.getValidatorExpressionAttributeValueStringRepresentation((AnnotationValueWrapper)e, annotationAttributeTypeMirror.getWrappedComponentType())).collect(Collectors.joining(", ", "new " + annotationAttributeTypeMirror.getWrappedComponentType().getQualifiedName() + "[]{", "}"));
        }
        if (annotationValueWrapper.isString()) {
            return "\"" + annotationValueWrapper.getStringValue() + "\"";
        }
        if (annotationValueWrapper.isClass()) {
            return annotationValueWrapper.getClassValue().getQualifiedName() + ".class";
        }
        if (annotationValueWrapper.isInteger()) {
            return annotationValueWrapper.getIntegerValue().toString();
        }
        if (annotationValueWrapper.isLong()) {
            return annotationValueWrapper.getLongValue() + "L";
        }
        if (annotationValueWrapper.isBoolean()) {
            return annotationValueWrapper.getBooleanValue().toString();
        }
        if (annotationValueWrapper.isFloat()) {
            return annotationValueWrapper.getFloatValue() + "f";
        }
        if (annotationValueWrapper.isDouble()) {
            return annotationValueWrapper.getDoubleValue().toString();
        }
        if (annotationValueWrapper.isEnum()) {
            return TypeElementWrapper.toTypeElement(annotationValueWrapper.getEnumValue().getEnclosingElement().get()).getQualifiedName() + "." + annotationValueWrapper.getEnumValue().getSimpleName();
        }
        throw new IllegalStateException("Got unsupported annotation attribute type : USUALLY THIS CANNOT HAPPEN.");
    }

    public String getStringRepresentationOfAnnotation() {
        return this.annotation.getStringRepresentation();
    }

    static class AnnotationToClassMapperWrapper {
        AnnotationMirrorWrapper annotation;

        private AnnotationToClassMapperWrapper(AnnotationMirrorWrapper annotation) {
            this.annotation = annotation;
        }

        TypeMirrorWrapper mappedClass() {
            return this.annotation.getAttribute("mappedClass").get().getClassValue();
        }

        String[] mappedAttributeNames() {
            return this.annotation.getAttributeWithDefault("mappedAttributeNames").getArrayValue().stream().map(e -> e.getStringValue()).collect(Collectors.toList()).toArray(new String[0]);
        }

        static Optional<AnnotationToClassMapperWrapper> wrap(AnnotationMirrorWrapper annotation) {
            if (annotation != null && annotation.asElement().hasAnnotation(AnnotationToClassMapper.class)) {
                return Optional.of(new AnnotationToClassMapperWrapper(annotation.asElement().getAnnotationMirror(AnnotationToClassMapper.class).get()));
            }
            return Optional.empty();
        }

        static boolean hasAnnotation(AnnotationMirrorWrapper annotation) {
            return AnnotationToClassMapperWrapper.wrap(annotation).isPresent();
        }
    }

    static enum InternalValidationMessages implements ValidationMessage
    {
        ERROR_BROKEN_VALIDATOR_ATTRIBUTE_NAME_MISMATCH("INVALID_ATTRIBUTE_NAME", "Passed attribute names '{}' for annotation '{}' aren't valid: {}"),
        ERROR_BROKEN_VALIDATOR_CONSTRUCTOR_PARAMETER_MAPPING("NO_MATCHING_CONSTRUCTOR", "No matching constructor could be found for class : {}"),
        ERROR_BROKEN_VALIDATOR_MISSING_NOARG_CONSTRUCTOR("MISSING_NOARG_CONSTRUCTOR", "Haven't found a noarg constructor for class: {}"),
        ERROR_BROKEN_VALIDATOR_INCORRECT_METHOD_PARAMETER_MAPPING("INCORRECT_METHOD_PARAMETER_MAPPING", "Empty attributeNames can only be used if annotated element represents a method parameter");

        private final String code;
        private final String message;

        private InternalValidationMessages(String code, String message) {
            this.code = code;
            this.message = message;
        }

        @Override
        public String getCode() {
            return this.code;
        }

        @Override
        public String getMessage() {
            return this.message;
        }
    }
}

