/*
 * Decompiled with CFR 0.152.
 */
package org.jmolecules.annotation.processor;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.Completion;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.jmolecules.annotation.processor.aptk.common.ToolingProvider;
import org.jmolecules.annotation.processor.aptk.tools.TypeMirrorWrapper;
import org.jmolecules.annotation.processor.aptk.tools.fluentfilter.FluentElementFilter;
import org.jmolecules.annotation.processor.aptk.tools.wrapper.AnnotationMirrorWrapper;
import org.jmolecules.annotation.processor.aptk.tools.wrapper.ElementWrapper;
import org.jmolecules.annotation.processor.aptk.tools.wrapper.ExecutableElementWrapper;
import org.jmolecules.annotation.processor.aptk.tools.wrapper.PackageElementWrapper;
import org.jmolecules.annotation.processor.aptk.tools.wrapper.TypeElementWrapper;
import org.jmolecules.annotation.processor.aptk.tools.wrapper.VariableElementWrapper;
import org.jmolecules.annotation.processor.net.minidev.json.JSONObject;
import org.jmolecules.stereotype.api.Stereotype;
import org.jmolecules.stereotype.catalog.StereotypeDefinition;
import org.jmolecules.stereotype.catalog.support.DefaultStereotypeDefinition;
import org.jmolecules.stereotype.support.AnnotationConfiguredStereotype;

public class JMoleculesProcessor
implements Processor {
    private final List<Verification> verifications = new ArrayList<Verification>();
    private final Set<String> packagesToCheck = new HashSet<String>();
    private final List<StereotypeDefinition> definitions = new ArrayList<StereotypeDefinition>();

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Collections.singleton("*");
    }

    @Override
    public Set<String> getSupportedOptions() {
        return Collections.emptySet();
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public Iterable<? extends Completion> getCompletions(Element element, AnnotationMirror annotation, ExecutableElement member, String userText) {
        return Collections.emptyList();
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        ToolingProvider.setTooling(processingEnv);
        if (JMoleculesDddVerification.isAvailable()) {
            this.verifications.add(new JMoleculesDddVerification());
        }
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (!roundEnv.processingOver()) {
            Set elements = roundEnv.getRootElements().stream().map(ElementWrapper::wrap).collect(Collectors.toSet());
            for (ElementWrapper rootElement : elements) {
                PackageElementWrapper packageElementWrapper = rootElement.unwrap() instanceof TypeElement ? rootElement.getPackage() : PackageElementWrapper.toPackageElement(rootElement);
                this.packagesToCheck.add(packageElementWrapper.getQualifiedName());
                if (!rootElement.isTypeElement()) continue;
                this.detectStereotype(rootElement);
            }
        } else {
            this.packagesToCheck.stream().flatMap(fqn -> JMoleculesProcessor.getTypesInPackage(fqn)).forEach(it -> this.verifications.stream().forEach(verification -> verification.verify((TypeElementWrapper)it)));
            try {
                this.writeStereotypeFile();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return false;
    }

    private static Stream<TypeElementWrapper> getTypesInPackage(String name) {
        List result = PackageElementWrapper.getByFqn(name).map(ElementWrapper::filterFlattenedEnclosedElementTree).map(FluentElementFilter::getResult).orElseGet(Collections::emptyList).stream().filter(TypeElement.class::isInstance).map(TypeElement.class::cast).collect(Collectors.toList());
        return result.stream().map(TypeElementWrapper::wrap);
    }

    private static TypeMirror getTypeMirror(String fqn) {
        return TypeMirrorWrapper.wrap(fqn).erasure().unwrap();
    }

    private static boolean hasMetaAnnotation(TypeMirrorWrapper element, TypeMirror mirror) {
        return TypeElementWrapper.getByTypeMirror(element.unwrap()).map(it -> JMoleculesProcessor.hasMetaAnnotation((ElementWrapper<? extends Element>)it, mirror)).orElse(false);
    }

    private static boolean hasMetaAnnotation(ElementWrapper<? extends Element> element, TypeMirror mirror) {
        return JMoleculesProcessor.hasMetaAnnotation(element, TypeMirrorWrapper.getQualifiedName(mirror));
    }

    private static boolean hasMetaAnnotation(ElementWrapper<? extends Element> element, String fqn) {
        if (element.hasAnnotation(fqn)) {
            return true;
        }
        return element.getAnnotationMirrors().stream().filter(JMoleculesProcessor::shouldTraverse).anyMatch(it -> JMoleculesProcessor.hasMetaAnnotation((ElementWrapper<? extends Element>)it.asTypeMirror().getTypeElement().get(), fqn));
    }

    private static boolean shouldTraverse(AnnotationMirrorWrapper annotation) {
        String name = annotation.asTypeMirror().getQualifiedName();
        return name != null && !name.startsWith("java") && !name.startsWith("jakarta") && !name.startsWith("kotlin");
    }

    private void detectStereotype(ElementWrapper<?> wrapper) {
        wrapper.getAnnotation(org.jmolecules.stereotype.Stereotype.class).ifPresent(it -> {
            TypeMirrorWrapper type = wrapper.asType();
            String typeName = type.getQualifiedName();
            Stereotype of = AnnotationConfiguredStereotype.of((String)typeName, (org.jmolecules.stereotype.Stereotype)it);
            StereotypeDefinition.Assignment.Type assignmentType = wrapper.isAnnotation() ? StereotypeDefinition.Assignment.Type.IS_ANNOTATED : StereotypeDefinition.Assignment.Type.IMPLEMENTS;
            StereotypeDefinition.Assignment assignment = StereotypeDefinition.Assignment.of((String)typeName, (StereotypeDefinition.Assignment.Type)assignmentType);
            this.definitions.add((StereotypeDefinition)DefaultStereotypeDefinition.of((Stereotype)of, (StereotypeDefinition.Assignment)assignment, (Object)type));
        });
    }

    private void writeStereotypeFile() throws IOException {
        if (this.definitions.isEmpty()) {
            return;
        }
        Map<String, Map> stereotypes = this.definitions.stream().collect(Collectors.toMap(it -> it.getStereotype().getIdentifier(), JMoleculesProcessor::toMap));
        String content = JSONObject.toJSONString(Map.of("stereotypes", stereotypes));
        ToolingProvider tooling = ToolingProvider.getTooling();
        tooling.getMessager().printMessage(Diagnostic.Kind.NOTE, "Writing jMolecules stereotype metadata to META-INF/jmolecules-stereotypes.json: " + this.definitions.stream().map(StereotypeDefinition::getStereotype).map(Stereotype::getIdentifier).collect(Collectors.joining(", ", "[ ", " ]")));
        Filer filer = tooling.getFiler();
        FileObject resource = filer.createResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/jmolecules-stereotypes.json", new Element[0]);
        try (Writer writer = resource.openWriter();){
            writer.append(content);
        }
    }

    private static Map<String, Object> toMap(StereotypeDefinition definition) {
        Stereotype stereotype = definition.getStereotype();
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("targets", definition.getAssignments().stream().map(StereotypeDefinition.Assignment::getTarget).toArray());
        result.put("groups", stereotype.getGroups());
        result.put("priority", stereotype.getPriority());
        return result;
    }

    private static class JMoleculesDddVerification
    implements Verification {
        private static final String PACKAGE = "org.jmolecules.ddd";
        private static final String IDENTITY_TYPE_NAME = "org.jmolecules.ddd.annotation.Identity";
        private final TypeMirror AGGREGATE_TYPE = JMoleculesProcessor.getTypeMirror("org.jmolecules.ddd.types.AggregateRoot");
        private final TypeMirror AGGREGATE_ANNOTATION = JMoleculesProcessor.getTypeMirror("org.jmolecules.ddd.annotation.AggregateRoot");
        private final TypeMirror ASSOCIATION = JMoleculesProcessor.getTypeMirror("org.jmolecules.ddd.types.Association");
        private final TypeMirror ENTITY_ANNOTATION = JMoleculesProcessor.getTypeMirror("org.jmolecules.ddd.annotation.Entity");
        private final TypeMirror IDENTIFIABLE_TYPE = JMoleculesProcessor.getTypeMirror("org.jmolecules.ddd.types.Identifiable");
        private final TypeMirror IDENTIFIER_TYPE = JMoleculesProcessor.getTypeMirror("org.jmolecules.ddd.types.Identifier");
        private final TypeMirror VALUE_OBJECT_ANNOTATION = JMoleculesProcessor.getTypeMirror("org.jmolecules.ddd.annotation.ValueObject");
        private final TypeMirror VALUE_OBJECT_TYPE = JMoleculesProcessor.getTypeMirror("org.jmolecules.ddd.types.ValueObject");

        private JMoleculesDddVerification() {
        }

        public static boolean isAvailable() {
            return JMoleculesProcessor.getTypeMirror("org.jmolecules.ddd.types.AggregateRoot") != null;
        }

        @Override
        public void verify(TypeElementWrapper element) {
            if (this.isIdentifiable(element)) {
                JMoleculesDddVerification.verifyFields(element, it -> !this.isAggregate((TypeMirrorWrapper)it), "Invalid aggregate root reference! Use identifier reference or Association instead!", new Object[0]);
            }
            if (this.isAnnotatedIdentifiable(element.asType())) {
                element.validate().asError().withCustomMessage("${0} needs identity declaration on either field or method!", element.asType().getSimpleName()).check(__ -> JMoleculesDddVerification.hasIdentityMethodOrField(element)).validateAndIssueMessages();
            }
            if (this.isValueObjectOrIdentifier(element)) {
                JMoleculesDddVerification.verifyFields(element, it -> this.isAssociation((TypeMirrorWrapper)it) || !this.isIdentifiable((TypeMirrorWrapper)it), "Value object or identifier must not refer to identifiables!", new Object[0]);
            }
        }

        private static void verifyFields(TypeElementWrapper element, Predicate<TypeMirrorWrapper> check, String message, Object ... args) {
            element.getFields(new Modifier[0]).forEach(it -> it.validate().asError().withCustomMessage(message, args).check(inner -> check.test(inner.asType())).validateAndIssueMessages());
        }

        private static boolean hasIdentityMethodOrField(TypeElementWrapper element) {
            return JMoleculesDddVerification.hasMethodOrFieldMatching(element, it -> JMoleculesProcessor.hasMetaAnnotation((ElementWrapper<? extends Element>)it, IDENTITY_TYPE_NAME));
        }

        private static boolean hasMethodOrFieldMatching(TypeElementWrapper element, Predicate<ElementWrapper<? extends Element>> predicate) {
            List<VariableElementWrapper> fields = element.getFields(new Modifier[0]);
            List<ExecutableElementWrapper> methods = element.getMethods(new Modifier[0]);
            return Stream.concat(fields.stream(), methods.stream()).anyMatch(predicate);
        }

        private boolean isValueObjectOrIdentifier(TypeElementWrapper mirror) {
            TypeMirrorWrapper type = mirror.asType();
            return this.isValueObject(type) || type.isAssignableTo(this.IDENTIFIER_TYPE);
        }

        private boolean isValueObject(TypeMirrorWrapper mirror) {
            return mirror.isAssignableTo(this.VALUE_OBJECT_TYPE) || JMoleculesProcessor.hasMetaAnnotation(mirror, this.VALUE_OBJECT_ANNOTATION);
        }

        private boolean isAggregate(TypeMirrorWrapper mirror) {
            return mirror.isAssignableTo(this.AGGREGATE_TYPE) || JMoleculesProcessor.hasMetaAnnotation(mirror, this.AGGREGATE_ANNOTATION);
        }

        private boolean isAssociation(TypeMirrorWrapper mirror) {
            return mirror.isAssignableTo(this.ASSOCIATION);
        }

        private boolean isIdentifiable(TypeMirrorWrapper mirror) {
            return mirror.isAssignableTo(this.IDENTIFIABLE_TYPE) || this.isAnnotatedIdentifiable(mirror);
        }

        private boolean isIdentifiable(TypeElementWrapper element) {
            return this.isIdentifiable(element.asType());
        }

        private boolean isAnnotatedIdentifiable(TypeMirrorWrapper mirror) {
            return JMoleculesProcessor.hasMetaAnnotation(mirror, this.ENTITY_ANNOTATION) || JMoleculesProcessor.hasMetaAnnotation(mirror, this.AGGREGATE_ANNOTATION);
        }
    }

    private static interface Verification {
        public void verify(TypeElementWrapper var1);
    }
}

