/*
 * Decompiled with CFR 0.152.
 */
package org.jmolecules.annotation.processor.aptk.templating;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.jmolecules.annotation.processor.aptk.templating.exceptions.InvalidPathException;

public class ModelPathResolver {
    public static ThreadLocal<Map<String, Object>> modelMapThreadLocal = new ThreadLocal<Map<String, Object>>(){

        @Override
        protected Map<String, Object> initialValue() {
            return new HashMap<String, Object>();
        }
    };

    public static ResolvedModelPathResult resolveModelPath(String path) {
        return ModelPathResolver.resolveModelPath(modelMapThreadLocal.get(), path);
    }

    public static ResolvedModelPathResult resolveModelPath(Map<String, Object> model, String path) {
        if (model == null || path == null) {
            return null;
        }
        String[] pathTokens = path.split("[.]");
        Object currentNode = model;
        Class<?> currentNodeType = null;
        for (String currentPathToken : pathTokens) {
            if (currentNode == null) {
                throw new InvalidPathException("Path cannot be resolved. Encountered null value in path '" + path + "'  so token '" + currentPathToken + "' cannot be applied.");
            }
            if (currentNode.getClass().isArray()) {
                throw new InvalidPathException("Path cannot be resolved. Encountered array in path '" + path + "' so token '" + currentPathToken + "' cannot be applied.");
            }
            if (currentNode instanceof Map) {
                if (!currentNode.containsKey(currentPathToken)) {
                    throw new InvalidPathException("Path cannot be resolved. Encountered Map in path '" + path + "' which has no key " + currentPathToken + ".");
                }
                if ((currentNode = currentNode.get(currentPathToken)) == null) continue;
                currentNodeType = currentNode.getClass();
                continue;
            }
            String getterName = ModelPathResolver.getGetter(currentNode, currentPathToken);
            if (getterName == null) {
                throw new InvalidPathException("Path '" + path + "' cannot be resolved. Path token " + currentPathToken + " not resolvable");
            }
            try {
                Method getterMethodToCall = currentNode.getClass().getMethod(getterName, new Class[0]);
                currentNode = getterMethodToCall.invoke(currentNode, new Object[0]);
                currentNodeType = getterMethodToCall.getReturnType();
            }
            catch (NoSuchMethodException getterMethodToCall) {
            }
            catch (Exception e) {
                throw new InvalidPathException("Path '" + path + "' cannot be resolved. Cannot invoke getter method of token '" + currentPathToken + "'", e);
            }
        }
        return new ResolvedModelPathResult(currentNodeType, currentNode);
    }

    protected static String getGetter(Object instance, String fieldNameOrGetter) {
        String trimmedFieldNameOrGetter;
        String[] GETTER_PREFIXES = new String[]{"get", "is", "has"};
        String string = trimmedFieldNameOrGetter = fieldNameOrGetter != null ? fieldNameOrGetter.trim() : null;
        if (instance == null || trimmedFieldNameOrGetter == null || trimmedFieldNameOrGetter.length() == 0) {
            return null;
        }
        try {
            Method method = instance.getClass().getMethod(trimmedFieldNameOrGetter.trim(), new Class[0]);
            if (Modifier.isPublic(method.getModifiers())) {
                return trimmedFieldNameOrGetter;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        for (String getterPrefix : GETTER_PREFIXES) {
            String getterName = getterPrefix + trimmedFieldNameOrGetter.substring(0, 1).toUpperCase() + trimmedFieldNameOrGetter.substring(1);
            try {
                Method method = instance.getClass().getMethod(getterName, new Class[0]);
                if (!Modifier.isPublic(method.getModifiers())) continue;
                return getterName;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return null;
    }

    public static class ResolvedModelPathResult {
        private final Object value;
        private final Class type;

        public ResolvedModelPathResult(Class type, Object value) {
            this.value = value;
            this.type = type;
        }

        public Object getValue() {
            return this.value;
        }

        public Class getType() {
            return this.type;
        }
    }
}

