/*
 * Decompiled with CFR 0.152.
 */
package org.jmolecules.annotation.processor.aptk.tools.wrapper;

import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.PackageElement;
import org.jmolecules.annotation.processor.aptk.common.ToolingProvider;
import org.jmolecules.annotation.processor.aptk.tools.wrapper.ElementWrapper;

public class PackageElementWrapper
extends ElementWrapper<PackageElement> {
    private PackageElementWrapper(PackageElement packageElement) {
        super(packageElement);
    }

    public String getQualifiedName() {
        return ((PackageElement)this.element).getQualifiedName().toString();
    }

    public boolean isUnnamed() {
        return ((PackageElement)this.element).isUnnamed();
    }

    public Optional<PackageElementWrapper> getParentPackage() {
        String qualifiedPackageName = this.getQualifiedName();
        String[] packageToken = qualifiedPackageName.split("[.]");
        if (packageToken.length == 1) {
            return Optional.empty();
        }
        String parentPackageName = Arrays.stream(packageToken, 0, packageToken.length - 1).collect(Collectors.joining("."));
        return PackageElementWrapper.getByFqn(parentPackageName);
    }

    public static PackageElementWrapper wrap(PackageElement element) {
        return new PackageElementWrapper(element);
    }

    public static Optional<PackageElementWrapper> getByFqn(String fqn) {
        PackageElement packageElement = ToolingProvider.getTooling().getElements().getPackageElement(fqn);
        return packageElement != null ? Optional.of(PackageElementWrapper.wrap(packageElement)) : Optional.empty();
    }
}

