/*
 * Decompiled with CFR 0.152.
 */
package org.jmolecules.archunit;

import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaField;
import com.tngtech.archunit.core.domain.JavaParameterizedType;
import com.tngtech.archunit.core.domain.JavaType;
import com.tngtech.archunit.core.domain.properties.CanBeAnnotated;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ArchRule;
import com.tngtech.archunit.lang.CompositeArchRule;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.SimpleConditionEvent;
import com.tngtech.archunit.lang.syntax.ArchRuleDefinition;
import com.tngtech.archunit.lang.syntax.elements.GivenClassesConjunction;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;
import java.util.function.Predicate;
import org.jmolecules.archunit.FormatableJavaClass;
import org.jmolecules.ddd.annotation.Identity;
import org.jmolecules.ddd.types.AggregateRoot;
import org.jmolecules.ddd.types.Entity;
import org.jmolecules.ddd.types.Identifiable;
import org.jmolecules.ddd.types.Identifier;
import org.jmolecules.ddd.types.ValueObject;
import org.jmolecules.spring.core.ResolvableType;

public class JMoleculesDddRules {
    private static DescribedPredicate<CanBeAnnotated> IS_ANNOTATED_IDENTIFIABLE = CanBeAnnotated.Predicates.annotatedWith(org.jmolecules.ddd.annotation.AggregateRoot.class).or(CanBeAnnotated.Predicates.annotatedWith(org.jmolecules.ddd.annotation.Entity.class));
    private static DescribedPredicate<CanBeAnnotated> IS_ANNOTATED_VALUE_OBJECT = CanBeAnnotated.Predicates.annotatedWith(org.jmolecules.ddd.annotation.ValueObject.class);
    private static DescribedPredicate<JavaClass> IS_IMPLEMENTING_IDENTIFIABLE = JavaClass.Predicates.implement(Identifiable.class);
    private static DescribedPredicate<JavaClass> IS_IMPLEMENTING_VALUE_OBJECT = JavaClass.Predicates.implement(ValueObject.class);
    private static DescribedPredicate<JavaClass> IS_IDENTIFIABLE = IS_IMPLEMENTING_IDENTIFIABLE.or(IS_ANNOTATED_IDENTIFIABLE);
    private static DescribedPredicate<JavaClass> IS_VALUE_OBJECT = IS_IMPLEMENTING_VALUE_OBJECT.or(IS_ANNOTATED_VALUE_OBJECT);
    private static DescribedPredicate<JavaClass> IS_IDENTIFIER = JavaClass.Predicates.implement(Identifier.class);

    public static ArchRule all() {
        return CompositeArchRule.of((ArchRule)JMoleculesDddRules.entitiesShouldBeDeclaredForUseInSameAggregate()).and(JMoleculesDddRules.aggregateReferencesShouldBeViaIdOrAssociation()).and(JMoleculesDddRules.annotatedEntitiesAndAggregatesNeedToHaveAnIdentifier()).and(JMoleculesDddRules.valueObjectsMustNotReferToIdentifiables()).allowEmptyShould(true);
    }

    public static ArchRule entitiesShouldBeDeclaredForUseInSameAggregate() {
        return ArchRuleDefinition.fields().that((DescribedPredicate)new OwnerMatches(IS_IDENTIFIABLE)).and(JMoleculesDddRules.areAssignableTo(Entity.class).and(DescribedPredicate.not((DescribedPredicate)JMoleculesDddRules.areAssignableTo(AggregateRoot.class)))).should((ArchCondition)JMoleculesDddRules.beDeclaredToBeUsedWithDeclaringAggregate()).allowEmptyShould(true);
    }

    public static ArchRule aggregateReferencesShouldBeViaIdOrAssociation() {
        DescribedPredicate referenceAnAggregateRoot = JMoleculesDddRules.areAssignableTo(AggregateRoot.class).or(JMoleculesDddRules.hasFieldTypeAnnotatedWith(org.jmolecules.ddd.annotation.AggregateRoot.class)).or(JMoleculesDddRules.hasParameterizedFieldOfTypeAnnotatedWith(org.jmolecules.ddd.annotation.AggregateRoot.class));
        return ArchRuleDefinition.fields().that(new OwnerMatches(IS_IDENTIFIABLE).and(referenceAnAggregateRoot)).should((ArchCondition)new ShouldUseIdReferenceOrAssociation()).allowEmptyShould(true);
    }

    public static ArchRule annotatedEntitiesAndAggregatesNeedToHaveAnIdentifier() {
        return ((GivenClassesConjunction)ArchRuleDefinition.classes().that(IS_ANNOTATED_IDENTIFIABLE).and().areNotAnnotations()).should((ArchCondition)new DeclaresAnnotatedFieldOrMethod(Identity.class)).allowEmptyShould(true);
    }

    public static ArchRule valueObjectsMustNotReferToIdentifiables() {
        return ArchRuleDefinition.fields().that((DescribedPredicate)new OwnerMatches((DescribedPredicate<JavaClass>)IS_VALUE_OBJECT.or(IS_IDENTIFIER))).should((ArchCondition)new FieldTypeMustNotMatchCondition(IS_IDENTIFIABLE)).allowEmptyShould(true);
    }

    private static IsDeclaredToUseTheSameAggregate beDeclaredToBeUsedWithDeclaringAggregate() {
        return new IsDeclaredToUseTheSameAggregate();
    }

    private static IsAssignableTypeField areAssignableTo(Class<?> type) {
        return new IsAssignableTypeField(type);
    }

    private static FieldTypeIsAnnotatedWith hasFieldTypeAnnotatedWith(Class<? extends Annotation> type) {
        return new FieldTypeIsAnnotatedWith(type);
    }

    private static DescribedPredicate<? super JavaField> hasParameterizedFieldOfTypeAnnotatedWith(Class<? extends Annotation> type) {
        return new ParameterizedFieldOfTypeAnnotatedWith(type);
    }

    private static class OwnerMatches
    extends DescribedPredicate<JavaField> {
        private final DescribedPredicate<JavaClass> condition;

        public OwnerMatches(DescribedPredicate<JavaClass> condition) {
            super(String.format("are declared in a jMolecules type that %s", condition.getDescription()), new Object[0]);
            this.condition = condition;
        }

        public boolean test(JavaField input) {
            return this.condition.test((Object)input.getOwner());
        }
    }

    private static class IsAssignableTypeField
    extends DescribedPredicate<JavaField> {
        private static final ResolvableType COLLECTION_TYPE = ResolvableType.forClass(Collection.class);
        private static final ResolvableType MAP_TYPE = ResolvableType.forClass(Map.class);
        private final Class<?> type;

        private IsAssignableTypeField(Class<?> type) {
            super("are assignable to %s", new Object[]{type.getName()});
            this.type = type;
        }

        public boolean test(JavaField input) {
            ResolvableType fieldType = ResolvableType.forField(input.reflect());
            ResolvableType domainType = IsAssignableTypeField.unwrapDomainType(fieldType);
            return ResolvableType.forClass(this.type).isAssignableFrom(domainType);
        }

        private static ResolvableType unwrapDomainType(ResolvableType fieldType) {
            if (COLLECTION_TYPE.isAssignableFrom(fieldType)) {
                return fieldType.as(Collection.class).getGeneric(0);
            }
            if (MAP_TYPE.isAssignableFrom(fieldType)) {
                return fieldType.as(Map.class).getGeneric(1);
            }
            return fieldType;
        }
    }

    private static class IsDeclaredToUseTheSameAggregate
    extends ArchCondition<JavaField> {
        private static final ResolvableType COLLECTION_TYPE = ResolvableType.forClass(Collection.class);
        private static final ResolvableType MAP_TYPE = ResolvableType.forClass(Map.class);

        private IsDeclaredToUseTheSameAggregate() {
            super("belong to aggregate the field is declared in", new Object[0]);
        }

        public void check(JavaField item, ConditionEvents events) {
            Field field = item.reflect();
            ResolvableType type = IsDeclaredToUseTheSameAggregate.getActualType(ResolvableType.forField(field));
            ResolvableType expectedAggregateType = type.as(Entity.class).getGeneric(0);
            ResolvableType owningType = ResolvableType.forClass(field.getDeclaringClass());
            ResolvableType owningAggregateType = owningType.as(Entity.class).getGeneric(0);
            boolean entitiesBelongToSameAggregate = expectedAggregateType.isAssignableFrom(owningAggregateType);
            if (owningType.isAssignableFrom(expectedAggregateType) || entitiesBelongToSameAggregate) {
                events.add(SimpleConditionEvent.satisfied((Object)field, (String)"Matches"));
            } else {
                String ownerName = FormatableJavaClass.of(item.getOwner()).getAbbreviatedFullName();
                events.add(SimpleConditionEvent.violated((Object)item, (String)String.format("Field %s.%s is of type %s and declared to be used from aggregate %s!", ownerName, item.getName(), item.getRawType().getSimpleName(), expectedAggregateType.resolve(Object.class).getSimpleName())));
            }
        }

        private static ResolvableType getActualType(ResolvableType type) {
            if (COLLECTION_TYPE.isAssignableFrom(type)) {
                return type.getGeneric(0);
            }
            return MAP_TYPE.isAssignableFrom(type) ? type.getGeneric(1) : type;
        }
    }

    private static class FieldTypeIsAnnotatedWith
    extends DescribedPredicate<JavaField> {
        private final DescribedPredicate<CanBeAnnotated> isAnnotatedWith;

        public FieldTypeIsAnnotatedWith(Class<? extends Annotation> type) {
            super("is of type annotated with %s", new Object[]{type.getSimpleName()});
            this.isAnnotatedWith = CanBeAnnotated.Predicates.annotatedWith(type);
        }

        public boolean test(JavaField input) {
            return this.isAnnotatedWith.test((Object)input.getRawType());
        }
    }

    private static class ShouldUseIdReferenceOrAssociation
    extends ArchCondition<JavaField> {
        public ShouldUseIdReferenceOrAssociation() {
            super("use id reference or Association", new Object[0]);
        }

        public void check(JavaField field, ConditionEvents events) {
            events.add(SimpleConditionEvent.violated((Object)field, (String)String.format("Field %s.%s refers to an aggregate root (%s). Rather use an identifier reference or Association!", FormatableJavaClass.of(field.getOwner()).getAbbreviatedFullName(), field.getName(), FormatableJavaClass.of(field.getRawType()).getAbbreviatedFullName())));
        }
    }

    private static class DeclaresAnnotatedFieldOrMethod
    extends ArchCondition<JavaClass> {
        private final Class<? extends Annotation> annotation;

        DeclaresAnnotatedFieldOrMethod(Class<? extends Annotation> annotation) {
            super("declares field or method  (meta-)annotated with %s", new Object[]{annotation.getName()});
            this.annotation = annotation;
        }

        public void check(JavaClass input, ConditionEvents events) {
            boolean annotatedFieldDeclared = input.getAllFields().stream().anyMatch(it -> it.isAnnotatedWith(this.annotation) || it.isMetaAnnotatedWith(this.annotation));
            boolean annotatedMethodDeclared = input.getAllMethods().stream().anyMatch(it -> it.isAnnotatedWith(this.annotation) || it.isMetaAnnotatedWith(this.annotation));
            if (!annotatedFieldDeclared && !annotatedMethodDeclared) {
                String message = String.format("Type %s must declare a field or a method annotated with %s!", FormatableJavaClass.of(input).getAbbreviatedFullName(), this.annotation.getName());
                events.add(SimpleConditionEvent.violated((Object)input, (String)message));
            }
        }
    }

    private static class FieldTypeMustNotMatchCondition
    extends ArchCondition<JavaField> {
        private final DescribedPredicate<JavaClass> condition;

        public FieldTypeMustNotMatchCondition(DescribedPredicate<JavaClass> condition) {
            super(condition.getDescription(), new Object[0]);
            this.condition = condition;
        }

        public void check(JavaField item, ConditionEvents events) {
            JavaClass type = item.getRawType();
            if (this.condition.test((Object)type)) {
                String ownerName = FormatableJavaClass.of(item.getOwner()).getAbbreviatedFullName();
                String typeName = FormatableJavaClass.of(item.getRawType()).getAbbreviatedFullName();
                String message = String.format("Field %s.%s refers to identifiable %s", ownerName, item.getName(), typeName);
                events.add(SimpleConditionEvent.violated((Object)item, (String)message));
            }
        }
    }

    private static class ParameterizedFieldOfTypeAnnotatedWith
    extends DescribedPredicate<JavaField> {
        private final DescribedPredicate<CanBeAnnotated> isAnnotatedWith;

        public ParameterizedFieldOfTypeAnnotatedWith(Class<? extends Annotation> type) {
            super("is collection of type annotated with %s", new Object[]{type.getSimpleName()});
            this.isAnnotatedWith = CanBeAnnotated.Predicates.annotatedWith(type);
        }

        public boolean test(JavaField input) {
            if (!(input.getType() instanceof JavaParameterizedType)) {
                return false;
            }
            JavaParameterizedType parameterizedType = (JavaParameterizedType)input.getType();
            return parameterizedType.getActualTypeArguments().stream().map(JavaType::toErasure).anyMatch((Predicate<JavaClass>)this.isAnnotatedWith);
        }
    }
}

