/*
 * Decompiled with CFR 0.152.
 */
package org.jmolecules.archunit;

import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.core.domain.JavaAnnotation;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaPackage;
import com.tngtech.archunit.core.domain.properties.HasAnnotations;
import com.tngtech.archunit.core.domain.properties.HasName;
import com.tngtech.archunit.lang.ArchRule;
import com.tngtech.archunit.library.Architectures;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.jmolecules.architecture.hexagonal.Adapter;
import org.jmolecules.architecture.hexagonal.Application;
import org.jmolecules.architecture.hexagonal.Port;
import org.jmolecules.architecture.hexagonal.PrimaryAdapter;
import org.jmolecules.architecture.hexagonal.PrimaryPort;
import org.jmolecules.architecture.hexagonal.SecondaryAdapter;
import org.jmolecules.architecture.hexagonal.SecondaryPort;
import org.jmolecules.architecture.layered.ApplicationLayer;
import org.jmolecules.architecture.layered.DomainLayer;
import org.jmolecules.architecture.layered.InfrastructureLayer;
import org.jmolecules.architecture.layered.InterfaceLayer;
import org.jmolecules.architecture.onion.classical.ApplicationServiceRing;
import org.jmolecules.architecture.onion.classical.DomainModelRing;
import org.jmolecules.architecture.onion.classical.DomainServiceRing;
import org.jmolecules.architecture.onion.classical.InfrastructureRing;
import org.jmolecules.architecture.onion.simplified.ApplicationRing;
import org.jmolecules.architecture.onion.simplified.DomainRing;
import org.jmolecules.spring.util.Assert;

public class JMoleculesArchitectureRules {
    private static final String INTERFACE = "Interface";
    private static final String APPLICATION = "Application";
    private static final String DOMAIN = "Domain";
    private static final String INFRASTRUCTURE = "Infrastructure";
    private static final String ONION_CLASSICAL_DOMAIN_MODEL = "Domain model";
    private static final String ONION_CLASSICAL_DOMAIN_SERVICE = "Domain service";
    private static final String ONION_CLASSICAL_APPLICATION = "Application";
    private static final String ONION_CLASSICAL_INFRASTRUCTURE = "Infrastructure";
    private static final String ONION_SIMPLE_DOMAIN = "Domain";
    private static final String ONION_SIMPLE_APPLICATION = "Application";
    private static final String ONION_SIMPLE_INFRASTRUCTURE = "Infrastructure";
    private static final String HEXAGONAL_APPLICATION = "Application";
    private static final String HEXAGONAL_PORT = "Port";
    private static final String HEXAGONAL_PORT_UNQUALIFIED = "Port (unqualified)";
    private static final String HEXAGONAL_PRIMARY_PORT = "Primary port";
    private static final String HEXAGONAL_SECONDARY_PORT = "Secondary port";
    private static final String HEXAGONAL_ADAPTER = "Adapter";
    private static final String HEXAGONAL_ADAPTER_UNQUALIFIED = "Adapter (unqualified)";
    private static final String HEXAGONAL_PRIMARY_ADAPTER = "Primary adapter";
    private static final String HEXAGONAL_SECONDARY_ADAPTER = "Secondary adapter";
    private static final String UNANNOTATED = "Unannotated";
    private static final String ANNOTATIONS = "Architecture annotations";

    public static Architectures.LayeredArchitecture ensureLayering() {
        return JMoleculesArchitectureRules.ensureLayering(StereotypeLookup.DEFAULT_LOOKUP);
    }

    public static Architectures.LayeredArchitecture ensureLayering(StereotypeLookup lookup) {
        return JMoleculesArchitectureRules.layeredArchitecture(lookup).whereLayer(INTERFACE).mayNotBeAccessedByAnyLayer().whereLayer("Application").mayOnlyBeAccessedByLayers(new String[]{INTERFACE}).whereLayer("Domain").mayOnlyBeAccessedByLayers(new String[]{"Application", INTERFACE}).whereLayer("Infrastructure").mayOnlyBeAccessedByLayers(new String[]{"Domain", "Application", INTERFACE});
    }

    public static Architectures.LayeredArchitecture ensureLayeringStrict() {
        return JMoleculesArchitectureRules.ensureLayeringStrict(StereotypeLookup.defaultLookup());
    }

    public static Architectures.LayeredArchitecture ensureLayeringStrict(StereotypeLookup lookup) {
        return JMoleculesArchitectureRules.layeredArchitecture(lookup).whereLayer(INTERFACE).mayNotBeAccessedByAnyLayer().whereLayer("Application").mayOnlyBeAccessedByLayers(new String[]{INTERFACE}).whereLayer("Domain").mayOnlyBeAccessedByLayers(new String[]{"Application"}).whereLayer("Infrastructure").mayOnlyBeAccessedByLayers(new String[]{"Domain"});
    }

    public static ArchRule ensureOnionSimple() {
        return JMoleculesArchitectureRules.ensureOnionSimple(StereotypeLookup.defaultLookup());
    }

    public static ArchRule ensureOnionSimple(StereotypeLookup lookup) {
        return JMoleculesArchitectureRules.onionArchitectureSimple(lookup).whereLayer("Infrastructure").mayNotBeAccessedByAnyLayer().whereLayer("Application").mayOnlyBeAccessedByLayers(new String[]{"Infrastructure"}).whereLayer("Domain").mayOnlyBeAccessedByLayers(new String[]{"Application", "Infrastructure"});
    }

    public static ArchRule ensureOnionClassical() {
        return JMoleculesArchitectureRules.ensureOnionClassical(StereotypeLookup.defaultLookup());
    }

    public static ArchRule ensureOnionClassical(StereotypeLookup lookup) {
        return JMoleculesArchitectureRules.onionArchitecture(lookup).whereLayer("Infrastructure").mayNotBeAccessedByAnyLayer().whereLayer("Application").mayOnlyBeAccessedByLayers(new String[]{"Infrastructure"}).whereLayer(ONION_CLASSICAL_DOMAIN_SERVICE).mayOnlyBeAccessedByLayers(new String[]{"Application", "Infrastructure"}).whereLayer(ONION_CLASSICAL_DOMAIN_MODEL).mayOnlyBeAccessedByLayers(new String[]{ONION_CLASSICAL_DOMAIN_SERVICE, "Application", "Infrastructure"});
    }

    public static ArchRule ensureHexagonal() {
        return JMoleculesArchitectureRules.ensureHexagonal(VerificationDepth.STRICT);
    }

    public static ArchRule ensureHexagonal(VerificationDepth depth) {
        return JMoleculesArchitectureRules.ensureHexagonal(depth, StereotypeLookup.defaultLookup());
    }

    public static ArchRule ensureHexagonal(StereotypeLookup lookup) {
        return JMoleculesArchitectureRules.ensureHexagonal(VerificationDepth.LENIENT, lookup);
    }

    public static ArchRule ensureHexagonal(VerificationDepth depth, StereotypeLookup lookup) {
        return JMoleculesArchitectureRules.hexagonalArchitecture(lookup).whereLayer(HEXAGONAL_ADAPTER_UNQUALIFIED).mayOnlyAccessLayers(depth.augmentPrimary(ANNOTATIONS, UNANNOTATED, HEXAGONAL_PORT, HEXAGONAL_PRIMARY_ADAPTER, HEXAGONAL_SECONDARY_ADAPTER)).whereLayer(HEXAGONAL_PRIMARY_ADAPTER).mayOnlyBeAccessedByLayers(new String[]{HEXAGONAL_ADAPTER_UNQUALIFIED, UNANNOTATED}).whereLayer(HEXAGONAL_PRIMARY_ADAPTER).mayOnlyAccessLayers(depth.augmentPrimary(ANNOTATIONS, UNANNOTATED, HEXAGONAL_PRIMARY_PORT, HEXAGONAL_PORT_UNQUALIFIED, HEXAGONAL_ADAPTER_UNQUALIFIED)).whereLayer(HEXAGONAL_SECONDARY_ADAPTER).mayOnlyBeAccessedByLayers(new String[]{HEXAGONAL_ADAPTER_UNQUALIFIED, UNANNOTATED}).whereLayer(HEXAGONAL_SECONDARY_ADAPTER).mayOnlyAccessLayers(depth.augmentSecondary(ANNOTATIONS, UNANNOTATED, HEXAGONAL_SECONDARY_PORT, HEXAGONAL_PORT_UNQUALIFIED, HEXAGONAL_ADAPTER_UNQUALIFIED)).whereLayer(HEXAGONAL_PRIMARY_PORT).mayOnlyAccessLayers(depth.augmentPrimary(ANNOTATIONS, UNANNOTATED, HEXAGONAL_PORT_UNQUALIFIED, HEXAGONAL_SECONDARY_PORT)).whereLayer(HEXAGONAL_SECONDARY_PORT).mayOnlyAccessLayers(depth.augmentSecondary(ANNOTATIONS, UNANNOTATED, HEXAGONAL_PORT_UNQUALIFIED)).whereLayer(HEXAGONAL_PORT_UNQUALIFIED).mayOnlyAccessLayers(new String[]{ANNOTATIONS, UNANNOTATED, HEXAGONAL_PORT, HEXAGONAL_PRIMARY_PORT, HEXAGONAL_SECONDARY_PORT}).whereLayer("Application").mayOnlyAccessLayers(new String[]{ANNOTATIONS, UNANNOTATED, HEXAGONAL_PRIMARY_PORT, HEXAGONAL_SECONDARY_PORT, HEXAGONAL_PORT_UNQUALIFIED});
    }

    private static Architectures.LayeredArchitecture layeredArchitecture(StereotypeLookup lookup) {
        return Architectures.layeredArchitecture().consideringOnlyDependenciesInLayers().withOptionalLayers(true).layer("Infrastructure").definedBy((DescribedPredicate)lookup.forAnnotation(InfrastructureLayer.class, JMoleculesLayeredArchitecture.LAYER_ANNOTATIONS)).layer("Domain").definedBy((DescribedPredicate)lookup.forAnnotation(DomainLayer.class, JMoleculesLayeredArchitecture.LAYER_ANNOTATIONS)).layer("Application").definedBy((DescribedPredicate)lookup.forAnnotation(ApplicationLayer.class, JMoleculesLayeredArchitecture.LAYER_ANNOTATIONS)).layer(INTERFACE).definedBy((DescribedPredicate)lookup.forAnnotation(InterfaceLayer.class, JMoleculesLayeredArchitecture.LAYER_ANNOTATIONS));
    }

    private static Architectures.LayeredArchitecture onionArchitecture(StereotypeLookup lookup) {
        return Architectures.layeredArchitecture().consideringOnlyDependenciesInLayers().withOptionalLayers(true).layer("Infrastructure").definedBy((DescribedPredicate)lookup.forAnnotation(InfrastructureRing.class, JMoleculesOnionArchitecture.ONION_CLASSICAL_ANNOTATIONS)).layer("Application").definedBy((DescribedPredicate)lookup.forAnnotation(ApplicationServiceRing.class, JMoleculesOnionArchitecture.ONION_CLASSICAL_ANNOTATIONS)).layer(ONION_CLASSICAL_DOMAIN_SERVICE).definedBy((DescribedPredicate)lookup.forAnnotation(DomainServiceRing.class, JMoleculesOnionArchitecture.ONION_CLASSICAL_ANNOTATIONS)).layer(ONION_CLASSICAL_DOMAIN_MODEL).definedBy((DescribedPredicate)lookup.forAnnotation(DomainModelRing.class, JMoleculesOnionArchitecture.ONION_CLASSICAL_ANNOTATIONS));
    }

    private static Architectures.LayeredArchitecture onionArchitectureSimple(StereotypeLookup lookup) {
        return Architectures.layeredArchitecture().consideringOnlyDependenciesInLayers().withOptionalLayers(true).layer("Infrastructure").definedBy((DescribedPredicate)lookup.forAnnotation(org.jmolecules.architecture.onion.simplified.InfrastructureRing.class, JMoleculesOnionArchitecture.ONION_SIMPLE_ANNOTATIONS)).layer("Application").definedBy((DescribedPredicate)lookup.forAnnotation(ApplicationRing.class, JMoleculesOnionArchitecture.ONION_SIMPLE_ANNOTATIONS)).layer("Domain").definedBy((DescribedPredicate)lookup.forAnnotation(DomainRing.class, JMoleculesOnionArchitecture.ONION_SIMPLE_ANNOTATIONS));
    }

    private static Architectures.LayeredArchitecture hexagonalArchitecture(StereotypeLookup lookup) {
        String hexagonalPackage = Application.class.getPackage().getName();
        return Architectures.layeredArchitecture().consideringOnlyDependenciesInLayers().withOptionalLayers(true).layer(ANNOTATIONS).definedBy(JavaClass.Predicates.resideInAPackage((String)hexagonalPackage)).layer(UNANNOTATED).definedBy(DescribedPredicate.not(lookup.hasAnnotationFromPackageOnItselfOrPackage(hexagonalPackage))).layer("Application").definedBy((DescribedPredicate)lookup.forAnnotation(Application.class, JMoleculesHexagonalArchitecture.HEXAGONAL_ANNOTATIONS)).layer(HEXAGONAL_PORT).definedBy((DescribedPredicate)lookup.forAnnotation(Port.class, JMoleculesHexagonalArchitecture.HEXAGONAL_ANNOTATIONS)).layer(HEXAGONAL_PORT_UNQUALIFIED).definedBy((DescribedPredicate)lookup.forAnnotation(Port.class, JMoleculesHexagonalArchitecture.HEXAGONAL_ANNOTATIONS).withExclusions(PrimaryPort.class, SecondaryPort.class)).layer(HEXAGONAL_PRIMARY_PORT).definedBy((DescribedPredicate)lookup.forAnnotation(PrimaryPort.class)).layer(HEXAGONAL_SECONDARY_PORT).definedBy((DescribedPredicate)lookup.forAnnotation(SecondaryPort.class)).layer(HEXAGONAL_ADAPTER).definedBy((DescribedPredicate)lookup.forAnnotation(Adapter.class, JMoleculesHexagonalArchitecture.HEXAGONAL_ANNOTATIONS)).layer(HEXAGONAL_ADAPTER_UNQUALIFIED).definedBy((DescribedPredicate)lookup.forAnnotation(Adapter.class, JMoleculesHexagonalArchitecture.HEXAGONAL_ANNOTATIONS).withExclusions(PrimaryAdapter.class, SecondaryAdapter.class)).layer(HEXAGONAL_PRIMARY_ADAPTER).definedBy((DescribedPredicate)lookup.forAnnotation(PrimaryAdapter.class, JMoleculesHexagonalArchitecture.HEXAGONAL_ANNOTATIONS).withoutExclusion(Adapter.class)).layer(HEXAGONAL_SECONDARY_ADAPTER).definedBy((DescribedPredicate)lookup.forAnnotation(SecondaryAdapter.class, JMoleculesHexagonalArchitecture.HEXAGONAL_ANNOTATIONS).withoutExclusion(Adapter.class));
    }

    static DescribedPredicate<JavaClass> hasAnnotationFromPackage(final Function<JavaClass, Stream<JavaClass>> markerLookup, final String name) {
        return new DescribedPredicate<JavaClass>("has annotation from package %s", new Object[]{name}){
            private final Map<HasAnnotations<?>, Boolean> CACHE;
            {
                super(description, params);
                this.CACHE = new HashMap();
            }

            public boolean test(JavaClass t) {
                return ((Stream)markerLookup.apply(t)).flatMap(it -> Stream.of(it, it.getPackage())).anyMatch(it -> this.hasAnnotationFromPackage((HasAnnotations<?>)it, name));
            }

            private boolean hasAnnotationFromPackage(HasAnnotations<?> target, String name2) {
                return this.CACHE.computeIfAbsent(target, it -> it.getAnnotations().stream().map(JavaAnnotation::getType).map(HasName::getName).anyMatch(candidate -> candidate.startsWith(name2 + ".")));
            }
        };
    }

    public static class StereotypeLookup {
        private static final String DEFAULT_DESCRIPTION = "(meta-)annotated with %s or residing in package (meta-)annotated with %s";
        private static final Function<JavaClass, Stream<JavaClass>> DEFAULT_MARKER_LOOKUP = it -> Stream.of(it);
        private static final StereotypeLookup DEFAULT_LOOKUP = new StereotypeLookup(DEFAULT_MARKER_LOOKUP, false);
        private final Function<JavaClass, Stream<JavaClass>> markerLookup;
        private final boolean traverseParentPackages;

        private StereotypeLookup(String name) {
            this(name, false);
        }

        private StereotypeLookup(String name, boolean traverseParentPackages) {
            this.markerLookup = type -> StereotypeLookup.markerTypes(type.getPackage(), name);
            this.traverseParentPackages = traverseParentPackages;
        }

        public static StereotypeLookup defaultLookup() {
            return DEFAULT_LOOKUP;
        }

        public static StereotypeLookup onMarkerType(String name) {
            Assert.hasText(name, "Name must not be null or empty!");
            return new StereotypeLookup(name);
        }

        public static StereotypeLookup onMarkerTypeName(Class<?> type) {
            return StereotypeLookup.onMarkerType(type.getSimpleName());
        }

        public StereotypeLookup withParentPackageTraversal() {
            return new StereotypeLookup(this.markerLookup, true);
        }

        IsStereotype forAnnotation(Class<? extends Annotation> annotations) {
            return this.forAnnotation(annotations, Collections.emptySet());
        }

        IsStereotype forAnnotation(Class<? extends Annotation> annotation, Collection<Class<? extends Annotation>> exclusions) {
            return new IsStereotype(annotation, this.markerLookup, this.allBut(exclusions, annotation), this.traverseParentPackages);
        }

        DescribedPredicate<JavaClass> hasAnnotationFromPackageOnItselfOrPackage(String name) {
            return JMoleculesArchitectureRules.hasAnnotationFromPackage(this.markerLookup, name);
        }

        Collection<Class<? extends Annotation>> allBut(Collection<Class<? extends Annotation>> source, Class<? extends Annotation> filter) {
            return source.stream().filter(it -> !this.isEqualOrAnnotated((Class<? extends Annotation>)it, filter)).collect(Collectors.toSet());
        }

        boolean isEqualOrAnnotated(Class<? extends Annotation> candidate, Class<? extends Annotation> reference) {
            if (StereotypeLookup.isJdkType(candidate)) {
                return false;
            }
            return candidate.equals(reference) || candidate.getAnnotation(reference) != null || Arrays.stream(candidate.getAnnotations()).anyMatch(it -> this.isEqualOrAnnotated(it.getClass(), reference));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static boolean isJdkType(Class<?> type) {
            String pkg = type.getName();
            if (pkg == null) return false;
            if (!Stream.of("java", "jdk", "com.sun").anyMatch(pkg::startsWith)) return false;
            return true;
        }

        private static Stream<JavaClass> markerTypes(JavaPackage pkg, String name) {
            Stream result = pkg.containsClassWithSimpleName(name) ? Stream.of(pkg.getClassWithSimpleName(name)) : Stream.empty();
            return pkg.getParent().map(it -> Stream.concat(StereotypeLookup.markerTypes(it, name), result)).orElse(result);
        }

        @Generated
        private StereotypeLookup(Function<JavaClass, Stream<JavaClass>> markerLookup, boolean traverseParentPackages) {
            this.markerLookup = markerLookup;
            this.traverseParentPackages = traverseParentPackages;
        }

        @Generated
        public static StereotypeLookup of(Function<JavaClass, Stream<JavaClass>> markerLookup, boolean traverseParentPackages) {
            return new StereotypeLookup(markerLookup, traverseParentPackages);
        }
    }

    public static enum VerificationDepth {
        LENIENT,
        SEMI_STRICT,
        STRICT;


        String[] augmentPrimary(String ... allowed) {
            switch (this) {
                case LENIENT: {
                    return VerificationDepth.augmentAccess(allowed);
                }
            }
            return allowed;
        }

        String[] augmentSecondary(String ... allowed) {
            switch (this) {
                case LENIENT: 
                case SEMI_STRICT: {
                    return VerificationDepth.augmentAccess(allowed);
                }
            }
            return allowed;
        }

        private static String[] augmentAccess(String ... abstractions) {
            ArrayList<String> result = new ArrayList<String>(Arrays.asList(abstractions));
            result.add("Application");
            if (result.contains(JMoleculesArchitectureRules.HEXAGONAL_PRIMARY_PORT)) {
                result.add(JMoleculesArchitectureRules.HEXAGONAL_SECONDARY_PORT);
            }
            return result.toArray(new String[result.size()]);
        }
    }

    static class JMoleculesLayeredArchitecture {
        static final Collection<Class<? extends Annotation>> LAYER_ANNOTATIONS = Arrays.asList(InfrastructureLayer.class, DomainLayer.class, ApplicationLayer.class, InterfaceLayer.class);

        JMoleculesLayeredArchitecture() {
        }
    }

    static class IsStereotype
    extends DescribedPredicate<JavaClass> {
        private final Class<? extends Annotation> annotation;
        private final String description;
        private final Function<JavaClass, Stream<JavaClass>> markerLookup;
        private final BiPredicate<Class<? extends Annotation>, JavaClass> filter = (it, type) -> type.isMetaAnnotatedWith(it) || this.hasAnnotationOnPackageOrParent(type.getPackage());
        private final Collection<Class<? extends Annotation>> exclusions;
        private final boolean traverseParentPackages;

        IsStereotype(Class<? extends Annotation> annotation, Function<JavaClass, Stream<JavaClass>> markerLookup, Collection<Class<? extends Annotation>> exclusions, boolean traverseParentPackages) {
            super("", new Object[0]);
            Object description = String.format("(meta-)annotated with %s or residing in package (meta-)annotated with %s", annotation.getName(), annotation.getName());
            if (!exclusions.isEmpty()) {
                description = (String)description + String.format(", but not (meta-)annotated with %s.", exclusions.stream().map(Class::getName).collect(Collectors.joining(", ")));
            }
            this.annotation = annotation;
            this.description = description;
            this.exclusions = exclusions;
            this.markerLookup = it -> Stream.concat(Stream.of(it), (Stream)markerLookup.apply((JavaClass)it));
            this.traverseParentPackages = traverseParentPackages;
        }

        public String getDescription() {
            return this.description;
        }

        @SafeVarargs
        public final IsStereotype withExclusions(Class<? extends Annotation> ... exclusions) {
            HashSet<Class<? extends Annotation>> newExclusions = new HashSet<Class<? extends Annotation>>(this.exclusions);
            newExclusions.addAll(Arrays.asList(exclusions));
            return new IsStereotype(this.annotation, this.markerLookup, newExclusions, this.traverseParentPackages);
        }

        public final IsStereotype withoutExclusion(Class<? extends Annotation> exclusion) {
            HashSet<Class<? extends Annotation>> newExclusions = new HashSet<Class<? extends Annotation>>(this.exclusions);
            newExclusions.remove(exclusion);
            return new IsStereotype(this.annotation, this.markerLookup, newExclusions, this.traverseParentPackages);
        }

        public boolean test(JavaClass type) {
            return !this.markerLookup.apply(type).anyMatch(it -> this.exclusions.stream().anyMatch(arg_0 -> ((JavaClass)it).isMetaAnnotatedWith(arg_0))) && this.markerLookup.apply(type).anyMatch(it -> this.filter.test(this.annotation, (JavaClass)it));
        }

        private boolean hasAnnotationOnPackageOrParent(JavaPackage javaPackage) {
            if (this.exclusions.stream().anyMatch(arg_0 -> ((JavaPackage)javaPackage).isMetaAnnotatedWith(arg_0))) {
                return false;
            }
            if (javaPackage.isMetaAnnotatedWith(this.annotation)) {
                return true;
            }
            return this.traverseParentPackages && javaPackage.getParent().map(this::hasAnnotationOnPackageOrParent).orElse(false) != false;
        }
    }

    static class JMoleculesOnionArchitecture {
        static final Collection<Class<? extends Annotation>> ONION_SIMPLE_ANNOTATIONS = Arrays.asList(DomainRing.class, ApplicationRing.class, org.jmolecules.architecture.onion.simplified.InfrastructureRing.class);
        static final Collection<Class<? extends Annotation>> ONION_CLASSICAL_ANNOTATIONS = Arrays.asList(DomainModelRing.class, DomainServiceRing.class, ApplicationServiceRing.class, InfrastructureRing.class);

        JMoleculesOnionArchitecture() {
        }
    }

    static class JMoleculesHexagonalArchitecture {
        static final List<Class<? extends Annotation>> HEXAGONAL_ANNOTATIONS = Arrays.asList(Application.class, Port.class, PrimaryPort.class, SecondaryPort.class, Adapter.class, PrimaryAdapter.class, SecondaryAdapter.class);

        JMoleculesHexagonalArchitecture() {
        }
    }
}

