/*
 * Decompiled with CFR 0.152.
 */
package org.jmolecules.archunit;

import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaPackage;
import com.tngtech.archunit.lang.ArchRule;
import com.tngtech.archunit.library.Architectures;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.jmolecules.architecture.hexagonal.Adapter;
import org.jmolecules.architecture.hexagonal.Application;
import org.jmolecules.architecture.hexagonal.Port;
import org.jmolecules.architecture.hexagonal.PrimaryAdapter;
import org.jmolecules.architecture.hexagonal.PrimaryPort;
import org.jmolecules.architecture.hexagonal.SecondaryAdapter;
import org.jmolecules.architecture.hexagonal.SecondaryPort;
import org.jmolecules.architecture.layered.ApplicationLayer;
import org.jmolecules.architecture.layered.DomainLayer;
import org.jmolecules.architecture.layered.InfrastructureLayer;
import org.jmolecules.architecture.layered.InterfaceLayer;
import org.jmolecules.architecture.onion.classical.ApplicationServiceRing;
import org.jmolecules.architecture.onion.classical.DomainModelRing;
import org.jmolecules.architecture.onion.classical.DomainServiceRing;
import org.jmolecules.architecture.onion.classical.InfrastructureRing;
import org.jmolecules.architecture.onion.simplified.ApplicationRing;
import org.jmolecules.architecture.onion.simplified.DomainRing;

public class JMoleculesArchitectureRules {
    private static final String INTERFACE = "Interface";
    private static final String APPLICATION = "Application";
    private static final String DOMAIN = "Domain";
    private static final String INFRASTRUCTURE = "Infrastructure";
    private static final String ONION_CLASSICAL_DOMAIN_MODEL = "Domain model";
    private static final String ONION_CLASSICAL_DOMAIN_SERVICE = "Domain service";
    private static final String ONION_CLASSICAL_APPLICATION = "Application";
    private static final String ONION_CLASSICAL_INFRASTRUCTURE = "Infrastructure";
    private static final String ONION_SIMPLE_DOMAIN = "Domain";
    private static final String ONION_SIMPLE_APPLICATION = "Application";
    private static final String ONION_SIMPLE_INFRASTRUCTURE = "Infrastructure";
    private static final String HEXAGONAL_APPLICATION = "Application";
    private static final String HEXAGONAL_PORT = "Port";
    private static final String HEXAGONAL_PORT_UNQUALIFIED = "Port (unqualified)";
    private static final String HEXAGONAL_PRIMARY_PORT = "Primary port";
    private static final String HEXAGONAL_SECONDARY_PORT = "Secondary port";
    private static final String HEXAGONAL_ADAPTER = "Adapter";
    private static final String HEXAGONAL_ADAPTER_UNQUALIFIED = "Adapter (unqualified)";
    private static final String HEXAGONAL_PRIMARY_ADAPTER = "Primary adapter";
    private static final String HEXAGONAL_SECONDARY_ADAPTER = "Secondary adapter";

    public static Architectures.LayeredArchitecture ensureLayering() {
        return JMoleculesArchitectureRules.layeredArchitecture().whereLayer(INTERFACE).mayNotBeAccessedByAnyLayer().whereLayer("Application").mayOnlyBeAccessedByLayers(new String[]{INTERFACE}).whereLayer("Domain").mayOnlyBeAccessedByLayers(new String[]{"Application", INTERFACE}).whereLayer("Infrastructure").mayOnlyBeAccessedByLayers(new String[]{"Domain", "Application", INTERFACE});
    }

    public static Architectures.LayeredArchitecture ensureLayeringStrict() {
        return JMoleculesArchitectureRules.layeredArchitecture().whereLayer(INTERFACE).mayNotBeAccessedByAnyLayer().whereLayer("Application").mayOnlyBeAccessedByLayers(new String[]{INTERFACE}).whereLayer("Domain").mayOnlyBeAccessedByLayers(new String[]{"Application"}).whereLayer("Infrastructure").mayOnlyBeAccessedByLayers(new String[]{"Domain"});
    }

    public static ArchRule ensureOnionSimple() {
        return JMoleculesArchitectureRules.onionArchitectureSimple().whereLayer("Infrastructure").mayNotBeAccessedByAnyLayer().whereLayer("Application").mayOnlyBeAccessedByLayers(new String[]{"Infrastructure"}).whereLayer("Domain").mayOnlyBeAccessedByLayers(new String[]{"Application", "Infrastructure"});
    }

    public static ArchRule ensureOnionClassical() {
        return JMoleculesArchitectureRules.onionArchitecture().whereLayer("Infrastructure").mayNotBeAccessedByAnyLayer().whereLayer("Application").mayOnlyBeAccessedByLayers(new String[]{"Infrastructure"}).whereLayer(ONION_CLASSICAL_DOMAIN_SERVICE).mayOnlyBeAccessedByLayers(new String[]{"Application", "Infrastructure"}).whereLayer(ONION_CLASSICAL_DOMAIN_MODEL).mayOnlyBeAccessedByLayers(new String[]{ONION_CLASSICAL_DOMAIN_SERVICE, ONION_CLASSICAL_DOMAIN_SERVICE, "Application", "Infrastructure"});
    }

    public static ArchRule ensureHexagonal() {
        return JMoleculesArchitectureRules.hexagonalArchitecture().whereLayer(HEXAGONAL_PRIMARY_PORT).mayOnlyBeAccessedByLayers(new String[]{"Application", HEXAGONAL_PORT_UNQUALIFIED, HEXAGONAL_ADAPTER_UNQUALIFIED, HEXAGONAL_PRIMARY_ADAPTER}).whereLayer(HEXAGONAL_SECONDARY_PORT).mayOnlyBeAccessedByLayers(new String[]{"Application", HEXAGONAL_PORT_UNQUALIFIED, HEXAGONAL_ADAPTER_UNQUALIFIED, HEXAGONAL_SECONDARY_ADAPTER}).whereLayer(HEXAGONAL_PORT).mayOnlyBeAccessedByLayers(new String[]{"Application", HEXAGONAL_ADAPTER}).whereLayer(HEXAGONAL_ADAPTER_UNQUALIFIED).mayOnlyBeAccessedByLayers(new String[]{HEXAGONAL_PRIMARY_ADAPTER, HEXAGONAL_SECONDARY_ADAPTER}).whereLayer(HEXAGONAL_PRIMARY_ADAPTER).mayOnlyBeAccessedByLayers(new String[]{HEXAGONAL_ADAPTER_UNQUALIFIED}).whereLayer(HEXAGONAL_SECONDARY_ADAPTER).mayOnlyBeAccessedByLayers(new String[]{HEXAGONAL_ADAPTER_UNQUALIFIED}).whereLayer("Application").mayNotBeAccessedByAnyLayer();
    }

    private static Architectures.LayeredArchitecture layeredArchitecture() {
        return Architectures.layeredArchitecture().withOptionalLayers(true).layer("Infrastructure").definedBy((DescribedPredicate)JMoleculesArchitectureRules.layerType(InfrastructureLayer.class)).layer("Domain").definedBy((DescribedPredicate)JMoleculesArchitectureRules.layerType(DomainLayer.class)).layer("Application").definedBy((DescribedPredicate)JMoleculesArchitectureRules.layerType(ApplicationLayer.class)).layer(INTERFACE).definedBy((DescribedPredicate)JMoleculesArchitectureRules.layerType(InterfaceLayer.class));
    }

    private static Architectures.LayeredArchitecture onionArchitecture() {
        return Architectures.layeredArchitecture().withOptionalLayers(true).layer("Infrastructure").definedBy((DescribedPredicate)JMoleculesArchitectureRules.layerType(InfrastructureRing.class)).layer("Application").definedBy((DescribedPredicate)JMoleculesArchitectureRules.layerType(ApplicationServiceRing.class)).layer(ONION_CLASSICAL_DOMAIN_SERVICE).definedBy((DescribedPredicate)JMoleculesArchitectureRules.layerType(DomainServiceRing.class)).layer(ONION_CLASSICAL_DOMAIN_MODEL).definedBy((DescribedPredicate)JMoleculesArchitectureRules.layerType(DomainModelRing.class));
    }

    private static Architectures.LayeredArchitecture onionArchitectureSimple() {
        return Architectures.layeredArchitecture().layer("Infrastructure").definedBy((DescribedPredicate)JMoleculesArchitectureRules.layerType(org.jmolecules.architecture.onion.simplified.InfrastructureRing.class)).layer("Application").definedBy((DescribedPredicate)JMoleculesArchitectureRules.layerType(ApplicationRing.class)).layer("Domain").definedBy((DescribedPredicate)JMoleculesArchitectureRules.layerType(DomainRing.class));
    }

    private static Architectures.LayeredArchitecture hexagonalArchitecture() {
        return Architectures.layeredArchitecture().withOptionalLayers(true).layer("Application").definedBy((DescribedPredicate)JMoleculesArchitectureRules.layerType(Application.class)).layer(HEXAGONAL_PORT).definedBy((DescribedPredicate)JMoleculesArchitectureRules.layerType(Port.class)).layer(HEXAGONAL_PORT_UNQUALIFIED).definedBy((DescribedPredicate)JMoleculesArchitectureRules.layerType(Port.class).withExclusions(PrimaryPort.class, SecondaryPort.class)).layer(HEXAGONAL_PRIMARY_PORT).definedBy((DescribedPredicate)JMoleculesArchitectureRules.layerType(PrimaryPort.class)).layer(HEXAGONAL_SECONDARY_PORT).definedBy((DescribedPredicate)JMoleculesArchitectureRules.layerType(SecondaryPort.class)).layer(HEXAGONAL_ADAPTER).definedBy((DescribedPredicate)JMoleculesArchitectureRules.layerType(Adapter.class)).layer(HEXAGONAL_ADAPTER_UNQUALIFIED).definedBy((DescribedPredicate)JMoleculesArchitectureRules.layerType(Adapter.class).withExclusions(PrimaryAdapter.class, SecondaryAdapter.class)).layer(HEXAGONAL_PRIMARY_ADAPTER).definedBy((DescribedPredicate)JMoleculesArchitectureRules.layerType(PrimaryAdapter.class)).layer(HEXAGONAL_SECONDARY_ADAPTER).definedBy((DescribedPredicate)JMoleculesArchitectureRules.layerType(SecondaryAdapter.class));
    }

    private static IsLayerType layerType(Class<? extends Annotation> annotation) {
        return new IsLayerType(annotation);
    }

    private static class IsLayerType
    extends DescribedPredicate<JavaClass> {
        private final Class<? extends Annotation> annotation;
        private final Collection<Class<? extends Annotation>> exclusions;

        public IsLayerType(Class<? extends Annotation> annotation) {
            this(annotation, Collections.emptySet());
        }

        public IsLayerType(Class<? extends Annotation> annotation, Collection<Class<? extends Annotation>> exclusions) {
            super("(meta-)annotated with %s or residing in package (meta-)annotated with %s", new Object[]{annotation.getTypeName(), annotation.getTypeName()});
            this.annotation = annotation;
            this.exclusions = exclusions;
        }

        @SafeVarargs
        public final IsLayerType withExclusions(Class<? extends Annotation> ... exclusions) {
            HashSet<Class<? extends Annotation>> newExclusions = new HashSet<Class<? extends Annotation>>(this.exclusions);
            newExclusions.addAll(Arrays.asList(exclusions));
            return new IsLayerType(this.annotation, newExclusions);
        }

        public boolean apply(JavaClass type) {
            if (this.exclusions.stream().anyMatch(it -> this.hasDirectOrMetaAnnotation(type, (Class<? extends Annotation>)it))) {
                return false;
            }
            return this.hasDirectOrMetaAnnotation(type, this.annotation) || this.hasAnnotationOnPackageOrParent(type.getPackage());
        }

        private boolean hasDirectOrMetaAnnotation(JavaClass type, Class<? extends Annotation> annotation) {
            return type.isAnnotatedWith(annotation) || type.isMetaAnnotatedWith(annotation);
        }

        private boolean hasAnnotationOnPackageOrParent(JavaPackage javaPackage) {
            boolean excluded = this.exclusions.stream().anyMatch(it -> javaPackage.isAnnotatedWith(it) || javaPackage.isMetaAnnotatedWith(it));
            if (excluded) {
                return false;
            }
            if (javaPackage.isAnnotatedWith(this.annotation) || javaPackage.isMetaAnnotatedWith(this.annotation)) {
                return true;
            }
            return (Boolean)javaPackage.getParent().map(this::hasAnnotationOnPackageOrParent).orElse((Object)false);
        }
    }
}

