/*
 * Decompiled with CFR 0.152.
 */
package org.jmolecules.bytebuddy;

import java.lang.annotation.Annotation;
import java.util.Optional;
import org.jmolecules.bytebuddy.ClassWorld;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Constants;
import org.springframework.util.ClassUtils;

class Jpa {
    private static final Logger log = LoggerFactory.getLogger(Jpa.class);
    private static Optional<Jpa> INSTANCE;
    private final String basePackage;
    private final Provider provider;

    Class<?> getAssociationAttributeConverterBaseType() {
        return this.basePackage.startsWith("javax") ? this.loadClass("org.jmolecules.spring.jpa.JpaAssociationAttributeConverter") : this.loadClass("org.jmolecules.spring.jpa.JakartaPersistenceAssociationAttributeConverter");
    }

    <T> T getCascadeTypeAll() {
        Class<? extends Annotation> annotation = this.loadClass("CascadeType");
        Constants constants = new Constants(annotation);
        return (T)constants.asObject("ALL");
    }

    <T> T getFetchTypeEager() {
        Class<? extends Annotation> fetchTypeType = this.loadClass("FetchType");
        return (T)Enum.valueOf(fetchTypeType, "EAGER");
    }

    <T> T getFetchTypeLazy() {
        Class<? extends Annotation> fetchTypeType = this.loadClass("FetchType");
        return (T)Enum.valueOf(fetchTypeType, "LAZY");
    }

    boolean isHibernate() {
        return Provider.HIBERNATE.equals((Object)this.provider);
    }

    <T extends Annotation> Class<T> getAnnotation(String name) {
        return this.loadClass(name);
    }

    <T> Class<T> getType(String name) {
        return this.loadClass(name);
    }

    public static Optional<Jpa> getJavaPersistence(ClassWorld world) {
        if (world == null) {
            throw new IllegalArgumentException("ClassWorld must not be null!");
        }
        if (INSTANCE == null) {
            INSTANCE = Jpa.createJavaPersistence(world);
        }
        return INSTANCE;
    }

    private static Optional<Jpa> createJavaPersistence(ClassWorld world) {
        Provider provider;
        Provider provider2 = provider = world.isAvailable("org.hibernate.Hibernate") ? Provider.HIBERNATE : Provider.GENERIC;
        if (world.isAvailable("javax.persistence.Entity")) {
            log.info("jMolecules - Detected legacy JPA\u2026");
            return Optional.of(new Jpa("javax.persistence", provider));
        }
        if (world.isAvailable("jakarta.persistence.Entity")) {
            log.info("jMolecules - Detected Jakarta Persistence\u2026");
            return Optional.of(new Jpa("jakarta.persistence", provider));
        }
        return Optional.empty();
    }

    private Class<? extends Annotation> loadClass(String name) {
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException("Type must not be null or empty!");
        }
        name = name.contains(".") ? name : this.basePackage.concat(".").concat(name);
        return ClassUtils.resolveClassName((String)name, (ClassLoader)Jpa.class.getClassLoader());
    }

    public Jpa(String basePackage, Provider provider) {
        this.basePackage = basePackage;
        this.provider = provider;
    }

    private static enum Provider {
        HIBERNATE,
        GENERIC;

    }
}

