/*
 * Decompiled with CFR 0.152.
 */
package org.jmolecules.bytebuddy;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.asm.AsmVisitorWrapper;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.jmolecules.bytebuddy.PluginUtils;

class LifecycleMethods {
    private final DynamicType.Builder<?> builder;
    private final Map<Class<? extends Annotation>, Optional<String>> methods;

    @SafeVarargs
    LifecycleMethods(DynamicType.Builder<?> builder, Class<? extends Annotation> ... annotation) {
        if (builder == null) {
            throw new IllegalArgumentException("Builder must not be null!");
        }
        if (annotation == null) {
            throw new IllegalArgumentException("Lifecycle methods must not be null!");
        }
        this.builder = builder;
        this.methods = LifecycleMethods.detectCallbackMethods(builder.toTypeDescription(), annotation);
    }

    public DynamicType.Builder<?> apply(Supplier<Advice> forExisting, Supplier<Implementation> forNew) {
        DynamicType.Builder result = this.builder;
        HashSet<String> handledMethods = new HashSet<String>();
        forExisting = PluginUtils.memoized(forExisting);
        forNew = PluginUtils.memoized(forNew);
        for (Map.Entry<Class<? extends Annotation>, Optional<String>> entry : this.methods.entrySet()) {
            Class<? extends Annotation> annotationType = entry.getKey();
            String name = entry.getValue().orElse(null);
            if (name != null) {
                if (handledMethods.contains(name)) continue;
                result = result.visit((AsmVisitorWrapper)forExisting.get().on((ElementMatcher)ElementMatchers.hasMethodName((String)name)));
                handledMethods.add(name);
                continue;
            }
            result = result.defineMethod("__jMolecules__" + annotationType.getSimpleName(), Void.TYPE, new ModifierContributor.ForMethod[]{Visibility.PACKAGE_PRIVATE}).intercept(forNew.get()).annotateMethod(new AnnotationDescription[]{PluginUtils.getAnnotation(annotationType)});
        }
        return result;
    }

    @SafeVarargs
    private static Map<Class<? extends Annotation>, Optional<String>> detectCallbackMethods(TypeDescription type, Class<? extends Annotation> ... annotations) {
        HashMap<Class<? extends Annotation>, Optional<String>> result = new HashMap<Class<? extends Annotation>, Optional<String>>();
        type.getDeclaredMethods().forEach(method -> Arrays.stream(annotations).forEach(annotation -> result.compute((Class<? extends Annotation>)annotation, (annotationType, methodName) -> methodName != null && methodName.isPresent() ? methodName : LifecycleMethods.getMethodNameIfAnnotated(method, annotationType))));
        return result;
    }

    private static Optional<String> getMethodNameIfAnnotated(MethodDescription.InDefinedShape method, Class<? extends Annotation> type) {
        return method.getDeclaredAnnotations().isAnnotationPresent(type) ? Optional.of(method.getName()) : Optional.empty();
    }
}

