/*
 * Decompiled with CFR 0.152.
 */
package org.jmolecules.bytebuddy;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.bytebuddy.description.annotation.AnnotationList;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import org.jmolecules.bytebuddy.PluginLogger;
import org.jmolecules.bytebuddy.PluginUtils;
import org.jmolecules.ddd.types.Entity;
import org.jmolecules.ddd.types.ValueObject;

class JMoleculesElementMatchers {
    private static final List<String> PACKAGE_PREFIX_TO_SKIP = Arrays.asList("java", "javax", "kotlin");

    JMoleculesElementMatchers() {
    }

    public static ElementMatcher<TypeDescription> isEntity() {
        return it -> it.isAssignableTo(Entity.class) || JMoleculesElementMatchers.hasAnnotation(it, org.jmolecules.ddd.annotation.Entity.class);
    }

    public static ElementMatcher<? super TypeDescription.Generic> isCollectionOfEntity() {
        return it -> it.asErasure().isAssignableTo(Collection.class) && JMoleculesElementMatchers.isEntity().matches((Object)((TypeDescription.Generic)it.asGenericType().getTypeArguments().get(0)).asErasure());
    }

    public static ElementMatcher<? super TypeDescription.Generic> isCollectionOfValueObject() {
        return it -> it.asErasure().isAssignableTo(Collection.class) && JMoleculesElementMatchers.isValueObject().matches((Object)((TypeDescription.Generic)it.asGenericType().getTypeArguments().get(0)).asErasure());
    }

    static boolean hasAnnotation(TypeDescription type, Class<? extends Annotation> annotation) {
        Objects.requireNonNull(type, "Type must not be null!");
        AnnotationList found = type.getDeclaredAnnotations();
        if (found.isAnnotationPresent(annotation)) {
            return true;
        }
        if (found.isEmpty()) {
            return false;
        }
        return found.asTypeList().stream().filter(Predicate.not(JMoleculesElementMatchers::residesInPlatformPackage)).anyMatch(it -> JMoleculesElementMatchers.hasAnnotation(it, annotation));
    }

    static ElementMatcher<? super MethodDescription> hasAnnotatedMethod(TypeDescription type, Class<? extends Annotation> source, Class<? extends Annotation> target, PluginLogger.Log log) {
        return method -> {
            TypeDefinition owningType = method.getDeclaringType();
            if (!owningType.equals(type) || JMoleculesElementMatchers.residesInPlatformPackage(owningType.asErasure())) {
                return false;
            }
            AnnotationList annotations = method.getDeclaredAnnotations();
            if (annotations.isAnnotationPresent(target)) {
                return false;
            }
            if (!annotations.isAnnotationPresent(source)) {
                return false;
            }
            log.info("Adding @{} to {}.", PluginUtils.abbreviate(target), PluginUtils.abbreviate(method));
            return true;
        };
    }

    static ElementMatcher<? super FieldDescription> hasAnnotatedField(TypeDescription type, Class<? extends Annotation> source, Class<? extends Annotation> target, PluginLogger.Log log) {
        if (type == null) {
            throw new IllegalArgumentException("Type must not be null!");
        }
        return field -> {
            TypeDefinition owningType = field.getDeclaringType();
            if (!owningType.equals(type) || JMoleculesElementMatchers.residesInPlatformPackage(owningType.asErasure())) {
                return false;
            }
            AnnotationList annotations = field.getDeclaredAnnotations();
            String signature = PluginUtils.toLog(field);
            if (annotations.isAnnotationPresent(target)) {
                return false;
            }
            if (!annotations.isAnnotationPresent(source)) {
                return false;
            }
            log.info("Adding @{} to {}.", PluginUtils.abbreviate(target), signature);
            return true;
        };
    }

    public static boolean residesInPlatformPackage(TypeDescription type) {
        return JMoleculesElementMatchers.residesInAnyPackageStartingWith(type, PACKAGE_PREFIX_TO_SKIP);
    }

    private static boolean residesInAnyPackageStartingWith(TypeDescription target, List<String> prefixes) {
        return target.getPackage() != null && prefixes.stream().anyMatch(it -> target.getPackage().getName().startsWith((String)it));
    }

    private static ElementMatcher<TypeDescription> isValueObject() {
        return it -> it.isAssignableTo(ValueObject.class) || JMoleculesElementMatchers.hasAnnotation(it, org.jmolecules.ddd.annotation.ValueObject.class);
    }
}

