/*
 * Decompiled with CFR 0.152.
 */
package org.jmolecules.bytebuddy;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.bytebuddy.build.Plugin;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.DynamicType;
import org.jmolecules.bytebuddy.ClassWorld;
import org.jmolecules.bytebuddy.JMoleculesAxonPlugin;
import org.jmolecules.bytebuddy.JMoleculesAxonSpringPlugin;
import org.jmolecules.bytebuddy.JMoleculesJpaPlugin;
import org.jmolecules.bytebuddy.JMoleculesSpringDataJdbcPlugin;
import org.jmolecules.bytebuddy.JMoleculesSpringDataJpaPlugin;
import org.jmolecules.bytebuddy.JMoleculesSpringDataMongoDbPlugin;
import org.jmolecules.bytebuddy.JMoleculesSpringDataPlugin;
import org.jmolecules.bytebuddy.JMoleculesSpringJpaPlugin;
import org.jmolecules.bytebuddy.JMoleculesSpringPlugin;
import org.jmolecules.bytebuddy.Jpa;
import org.jmolecules.bytebuddy.LoggingPlugin;
import org.jmolecules.bytebuddy.PluginUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMoleculesPlugin
implements LoggingPlugin,
Plugin.WithPreprocessor {
    private static final Logger log = LoggerFactory.getLogger(JMoleculesPlugin.class);
    private final Map<ClassFileLocator, List<LoggingPlugin>> globalPlugins = new HashMap<ClassFileLocator, List<LoggingPlugin>>();
    private final Map<TypeDescription, List<? extends LoggingPlugin>> delegates = new HashMap<TypeDescription, List<? extends LoggingPlugin>>();

    public void onPreprocess(TypeDescription typeDescription, ClassFileLocator classFileLocator) {
        if (PluginUtils.isCglibProxyType((TypeDefinition)typeDescription)) {
            return;
        }
        List plugins = this.globalPlugins.computeIfAbsent(classFileLocator, locator -> {
            ClassWorld world = ClassWorld.of(locator);
            Optional<Jpa> jpa = Jpa.getJavaPersistence(world);
            return Stream.of(JMoleculesPlugin.axonPlugin(world), JMoleculesPlugin.axonSpringPlugin(world), JMoleculesPlugin.jpaPlugin(world, jpa), JMoleculesPlugin.springPlugin(world), JMoleculesPlugin.springJpaPlugin(world, jpa), JMoleculesPlugin.springDataPlugin(world), JMoleculesPlugin.springDataJdbcPlugin(world), JMoleculesPlugin.springDataJpaPlugin(world, jpa), JMoleculesPlugin.springDataMongDbPlugin(world)).flatMap(it -> it).collect(Collectors.toList());
        });
        this.delegates.computeIfAbsent(typeDescription, it -> plugins.stream().filter(plugin -> plugin.matches(it)).collect(Collectors.toList()));
    }

    public boolean matches(TypeDescription target) {
        if (PluginUtils.isCglibProxyType((TypeDefinition)target)) {
            return false;
        }
        List<? extends LoggingPlugin> plugins = this.delegates.get(target);
        return plugins != null && !plugins.isEmpty();
    }

    public DynamicType.Builder<?> apply(DynamicType.Builder<?> builder, TypeDescription typeDescription, ClassFileLocator classFileLocator) {
        return this.delegates.get(typeDescription).stream().reduce(builder, (it, plugin) -> plugin.apply(it, typeDescription, classFileLocator), (left, right) -> right);
    }

    private static Stream<? extends LoggingPlugin> jpaPlugin(ClassWorld world, Optional<Jpa> jpa) {
        return jpa.filter(__ -> {
            boolean jMoleculesJpaAvailable = world.isAvailable("org.jmolecules.jpa.JMoleculesJpa");
            if (!jMoleculesJpaAvailable) {
                log.warn("JMoleculesJpa missing on the classpath! Add org.jmolecules:jmolecules-jpa as dependency!");
            }
            return true;
        }).map(it -> new JMoleculesJpaPlugin((Jpa)it, world)).map(Stream::of).orElseGet(Stream::empty);
    }

    private static Stream<LoggingPlugin> springPlugin(ClassWorld world) {
        return world.isAvailable("org.springframework.stereotype.Component") ? Stream.of(new JMoleculesSpringPlugin()) : Stream.empty();
    }

    private static Stream<LoggingPlugin> springDataPlugin(ClassWorld world) {
        return world.isAvailable("org.springframework.data.repository.Repository") ? Stream.of(new JMoleculesSpringDataPlugin()) : Stream.empty();
    }

    private static Stream<? extends LoggingPlugin> springJpaPlugin(ClassWorld world, Optional<Jpa> jpa) {
        return jpa.filter(__ -> world.isAvailable("org.springframework.stereotype.Component")).filter(__ -> world.isAvailable("org.jmolecules.spring.jpa.AssociationAttributeConverter")).map(it -> new JMoleculesSpringJpaPlugin((Jpa)it)).map(Stream::of).orElseGet(Stream::empty);
    }

    private static Stream<LoggingPlugin> springDataJdbcPlugin(ClassWorld world) {
        return world.isAvailable("org.springframework.data.jdbc.core.mapping.AggregateReference") ? Stream.of(new JMoleculesSpringDataJdbcPlugin()) : Stream.empty();
    }

    private static Stream<? extends LoggingPlugin> springDataJpaPlugin(ClassWorld world, Optional<Jpa> jpa) {
        return jpa.filter(__ -> world.isAvailable("org.springframework.data.jpa.repository.JpaRepository")).map(JMoleculesSpringDataJpaPlugin::new).map(Stream::of).orElseGet(Stream::empty);
    }

    private static Stream<LoggingPlugin> springDataMongDbPlugin(ClassWorld world) {
        return world.isAvailable("org.springframework.data.mongodb.core.mapping.Document") ? Stream.of(new JMoleculesSpringDataMongoDbPlugin()) : Stream.empty();
    }

    private static Stream<LoggingPlugin> axonPlugin(ClassWorld world) {
        return world.isAvailable("org.axonframework.commandhandling.CommandHandler") ? Stream.of(new JMoleculesAxonPlugin()) : Stream.empty();
    }

    private static Stream<LoggingPlugin> axonSpringPlugin(ClassWorld world) {
        return world.isAvailable("org.axonframework.spring.stereotype.Aggregate") ? Stream.of(new JMoleculesAxonSpringPlugin()) : Stream.empty();
    }
}

