/*
 * Decompiled with CFR 0.152.
 */
package org.jmolecules.bytebuddy;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.stream.Collectors;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.NamingStrategy;
import net.bytebuddy.build.Plugin;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.description.type.TypeList;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodCall;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.jmolecules.bytebuddy.ClassWorld;
import org.jmolecules.bytebuddy.JMoleculesType;
import org.jmolecules.bytebuddy.Jpa;
import org.jmolecules.bytebuddy.LoggingPlugin;
import org.jmolecules.bytebuddy.PluginLogger;
import org.jmolecules.bytebuddy.PluginUtils;
import org.jmolecules.bytebuddy.ReferenceTypePackageNamingStrategy;
import org.jmolecules.bytebuddy.Types;
import org.jmolecules.ddd.types.Association;
import org.jmolecules.ddd.types.Entity;

public class JMoleculesSpringJpaPlugin
implements LoggingPlugin,
Plugin.WithPreprocessor {
    private Jpa jpa;

    public boolean matches(TypeDescription target) {
        return !PluginUtils.isCglibProxyType((TypeDefinition)target) && (target.getDeclaredAnnotations().isAnnotationPresent(this.jpa.getAnnotation("Entity")) || target.isAssignableTo(Entity.class));
    }

    public void onPreprocess(TypeDescription typeDescription, ClassFileLocator classFileLocator) {
        ClassWorld world = ClassWorld.of(classFileLocator);
        this.jpa = Jpa.getJavaPersistence(world).get();
    }

    public DynamicType.Builder<?> apply(DynamicType.Builder<?> builder, TypeDescription typeDescription, ClassFileLocator classFileLocator) {
        PluginLogger.Log log = PluginLogger.INSTANCE.getLog(typeDescription, "Spring JPA");
        return JMoleculesType.of(log, builder).map(this::addConvertAnnotationIfNeeded).conclude();
    }

    private DynamicType.Builder<?> addConvertAnnotationIfNeeded(DynamicType.Builder<?> builder, PluginLogger.Log logger) {
        List associationFields = builder.toTypeDescription().getDeclaredFields().stream().filter(field -> field.getType().asErasure().represents(Association.class)).collect(Collectors.toList());
        for (FieldDescription.InDefinedShape field2 : associationFields) {
            if (field2.getDeclaredAnnotations().isAnnotationPresent(this.jpa.getAnnotation("Convert"))) {
                logger.info("Found existing converter registration for field {}.", field2.getName());
                continue;
            }
            builder = this.createConvertAnnotation(field2, builder, logger);
        }
        return builder;
    }

    @Override
    public void close() throws IOException {
    }

    private DynamicType.Builder<?> createConvertAnnotation(FieldDescription.InDefinedShape field, DynamicType.Builder<?> builder, PluginLogger.Log log) {
        TypeList.Generic generic = field.getType().asGenericType().getTypeArguments();
        TypeDescription.Generic aggregateType = (TypeDescription.Generic)generic.get(0);
        TypeDescription.Generic idType = (TypeDescription.Generic)generic.get(1);
        TypeDescription.Generic idPrimitiveType = JMoleculesSpringJpaPlugin.getIdPrimitiveType(idType);
        if (idPrimitiveType == null) {
            log.info("{} - Unable to detect id primitive in {}.", field.getName(), PluginUtils.abbreviate((TypeDefinition)idType));
            return builder;
        }
        TypeDescription.ForLoadedType loadedType = new TypeDescription.ForLoadedType(this.jpa.getAssociationAttributeConverterBaseType());
        TypeDescription.Generic superType = TypeDescription.Generic.Builder.parameterizedType((TypeDescription)loadedType, (TypeDefinition[])new TypeDefinition[]{aggregateType, idType, idPrimitiveType}).build();
        DynamicType.Builder converterBuilder = new ByteBuddy(ClassFileVersion.JAVA_V8).with((NamingStrategy)new ReferenceTypePackageNamingStrategy(field.getDeclaringType())).subclass((TypeDefinition)superType).annotateType(new AnnotationDescription[]{PluginUtils.getAnnotation(this.jpa.getAnnotation("Converter"))});
        if (Types.AT_GENERATED != null) {
            converterBuilder = converterBuilder.annotateType(new AnnotationDescription[]{PluginUtils.getAnnotation(Types.AT_GENERATED)});
        }
        DynamicType.Unloaded converterType = converterBuilder.defineConstructor(new ModifierContributor.ForMethod[]{Visibility.PACKAGE_PRIVATE}).intercept((Implementation)MethodCall.invoke(this.getConverterConstructor()).onSuper().with(new TypeDescription[]{idType.asErasure()})).make();
        builder = builder.require(new DynamicType[]{converterType});
        log.info("{} - Adding @j.p.Convert(converter={}).", field.getName(), PluginUtils.abbreviate((TypeDefinition)converterType.getTypeDescription()));
        return builder.field((ElementMatcher)ElementMatchers.is((FieldDescription.InDefinedShape)field)).annotateField(new AnnotationDescription[]{AnnotationDescription.Builder.ofType(this.jpa.getAnnotation("Convert")).define("converter", converterType.getTypeDescription()).build()});
    }

    private static TypeDescription.Generic getIdPrimitiveType(TypeDescription.Generic idType) {
        List fields = idType.getDeclaredFields().stream().filter(it -> !it.isStatic()).collect(Collectors.toList());
        return fields.isEmpty() ? JMoleculesSpringJpaPlugin.getIdPrimitiveType(idType.getSuperClass()) : ((FieldDescription.InGenericShape)fields.get(0)).getType();
    }

    private Constructor<?> getConverterConstructor() {
        return JMoleculesSpringJpaPlugin.getConstructor(this.jpa.getAssociationAttributeConverterBaseType(), Class.class);
    }

    private static Constructor<?> getConstructor(Class<?> type, Class<?> ... parameters) {
        try {
            return type.getDeclaredConstructor(parameters);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public JMoleculesSpringJpaPlugin() {
    }

    public JMoleculesSpringJpaPlugin(Jpa jpa) {
        this.jpa = jpa;
    }
}

