/*
 * Decompiled with CFR 0.152.
 */
package org.jmolecules.bytebuddy;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.SuperMethodCall;
import org.jmolecules.bytebuddy.JMoleculesElementMatchers;
import org.jmolecules.bytebuddy.LoggingPlugin;
import org.jmolecules.bytebuddy.PluginLogger;
import org.jmolecules.bytebuddy.PluginUtils;
import org.jmolecules.bytebuddy.Types;
import org.jmolecules.ddd.annotation.Factory;
import org.jmolecules.ddd.annotation.Repository;
import org.jmolecules.ddd.annotation.Service;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

public class JMoleculesSpringPlugin
implements LoggingPlugin {
    private static final Map<Class<?>, Class<? extends Annotation>> MAPPINGS;
    private static final Set<Class<?>> TRIGGERS;
    private static final Map<Class<? extends Annotation>, Class<? extends Annotation>> METHOD_ANNOTATIONS;

    public boolean matches(TypeDescription type) {
        if (JMoleculesElementMatchers.residesInPlatformPackage(type)) {
            return false;
        }
        return TRIGGERS.stream().anyMatch(it -> it.isAnnotation() ? PluginUtils.isAnnotatedWith(type, it) : type.isAssignableTo(it));
    }

    public DynamicType.Builder<?> apply(DynamicType.Builder<?> builder, TypeDescription type, ClassFileLocator classFileLocator) {
        PluginLogger.Log log = PluginLogger.INSTANCE.getLog(type, "Spring");
        DynamicType.Builder.MethodDefinition result = PluginUtils.mapAnnotationOrInterfaces(builder, type, MAPPINGS, log);
        for (Map.Entry<Class<? extends Annotation>, Class<? extends Annotation>> entry : METHOD_ANNOTATIONS.entrySet()) {
            Class<? extends Annotation> target = entry.getValue();
            result = result.method(JMoleculesElementMatchers.hasAnnotatedMethod(type, entry.getKey(), target, log)).intercept((Implementation)SuperMethodCall.INSTANCE).annotateMethod(new AnnotationDescription[]{PluginUtils.getAnnotation(target)});
        }
        return result;
    }

    @Override
    public void close() throws IOException {
    }

    static {
        HashMap<Class<org.springframework.stereotype.Repository>, Class<Repository>> types = new HashMap<Class<org.springframework.stereotype.Repository>, Class<Repository>>();
        types.put(Service.class, org.springframework.stereotype.Service.class);
        types.put(Repository.class, org.springframework.stereotype.Repository.class);
        types.put(Factory.class, Component.class);
        types.put(org.springframework.stereotype.Service.class, Service.class);
        types.put(org.springframework.stereotype.Repository.class, Repository.class);
        MAPPINGS = Collections.unmodifiableMap(types);
        HashSet triggers = new HashSet(MAPPINGS.keySet());
        triggers.add(Component.class);
        TRIGGERS = Collections.unmodifiableSet(triggers);
        HashMap<Class<Annotation>, Class> methods = new HashMap<Class<Annotation>, Class>();
        if (Types.DOMAIN_EVENT_HANDLER != null) {
            methods.put(Types.DOMAIN_EVENT_HANDLER, EventListener.class);
            methods.put(EventListener.class, Types.DOMAIN_EVENT_HANDLER);
        }
        METHOD_ANNOTATIONS = Collections.unmodifiableMap(methods);
    }
}

