/*
 * Decompiled with CFR 0.152.
 */
package org.jmolecules.bytebuddy;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.NamingStrategy;
import net.bytebuddy.build.Plugin;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.description.type.TypeList;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodCall;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.jmolecules.bytebuddy.ClassWorld;
import org.jmolecules.bytebuddy.JMoleculesTypeBuilder;
import org.jmolecules.bytebuddy.Jpa;
import org.jmolecules.bytebuddy.LoggingPlugin;
import org.jmolecules.bytebuddy.PluginLogger;
import org.jmolecules.bytebuddy.PluginUtils;
import org.jmolecules.bytebuddy.ReferenceTypePackageNamingStrategy;
import org.jmolecules.ddd.types.Association;
import org.jmolecules.ddd.types.Entity;

public class JMoleculesSpringJpaPlugin
implements LoggingPlugin,
Plugin.WithPreprocessor {
    private Jpa jpa;

    public boolean matches(TypeDescription target) {
        return !PluginUtils.isCglibProxyType((TypeDefinition)target) && (target.getDeclaredAnnotations().isAnnotationPresent(this.jpa.getAnnotation("Entity")) || target.isAssignableTo(Entity.class));
    }

    public void onPreprocess(TypeDescription typeDescription, ClassFileLocator classFileLocator) {
        ClassWorld world = ClassWorld.of(classFileLocator);
        this.jpa = Jpa.getJavaPersistence(world).get();
    }

    public DynamicType.Builder<?> apply(DynamicType.Builder<?> builder, TypeDescription typeDescription, ClassFileLocator classFileLocator) {
        PluginLogger.Log log = PluginLogger.INSTANCE.getLog(typeDescription, "Spring JPA");
        return JMoleculesTypeBuilder.of(log, builder).mapBuilder(this::addConvertAnnotationIfNeeded).conclude();
    }

    private DynamicType.Builder<?> addConvertAnnotationIfNeeded(DynamicType.Builder<?> builder, PluginLogger.Log logger) {
        List associationFields = builder.toTypeDescription().getDeclaredFields().stream().filter(JMoleculesSpringJpaPlugin.isAssociationOrCollectionThereof()).collect(Collectors.toList());
        for (FieldDescription.InDefinedShape field : associationFields) {
            if (field.getDeclaredAnnotations().isAnnotationPresent(this.jpa.getAnnotation("Convert"))) {
                logger.info("Found existing converter registration for field {}.", field.getName());
                continue;
            }
            builder = this.createConvertAnnotation(field, builder, logger);
        }
        return builder;
    }

    @Override
    public void close() throws IOException {
    }

    private DynamicType.Builder<?> createConvertAnnotation(FieldDescription.InDefinedShape field, DynamicType.Builder<?> builder, PluginLogger.Log log) {
        boolean isCollection = field.getType().asErasure().isAssignableTo(Collection.class);
        TypeDescription.Generic associationType = isCollection ? (TypeDescription.Generic)field.getType().getTypeArguments().get(0) : field.getType();
        TypeList.Generic generic = associationType.asGenericType().getTypeArguments();
        TypeDescription.Generic aggregateType = (TypeDescription.Generic)generic.get(0);
        TypeDescription.Generic idType = (TypeDescription.Generic)generic.get(1);
        TypeDescription.Generic idPrimitiveType = JMoleculesSpringJpaPlugin.getIdPrimitiveType(idType);
        if (idPrimitiveType == null) {
            log.info("{} - Unable to detect id primitive in {}.", field.getName(), PluginUtils.abbreviate((TypeDefinition)idType));
            return builder;
        }
        TypeDescription.ForLoadedType loadedType = new TypeDescription.ForLoadedType(this.jpa.getAssociationAttributeConverterBaseType());
        TypeDescription.Generic superType = TypeDescription.Generic.Builder.parameterizedType((TypeDescription)loadedType, (TypeDefinition[])new TypeDefinition[]{aggregateType, idType, idPrimitiveType}).build();
        DynamicType.Builder converterBuilder = new ByteBuddy(ClassFileVersion.JAVA_V8).with((NamingStrategy)new ReferenceTypePackageNamingStrategy(aggregateType.asErasure(), "AssociationConverter")).subclass((TypeDefinition)superType).annotateType(new AnnotationDescription[]{PluginUtils.getAnnotation(this.jpa.getAnnotation("Converter"))});
        DynamicType.Unloaded converterType = PluginUtils.markGenerated(converterBuilder, log).defineConstructor(new ModifierContributor.ForMethod[]{Visibility.PACKAGE_PRIVATE}).intercept((Implementation)MethodCall.invoke(this.getConverterConstructor()).onSuper().with(new TypeDescription[]{idType.asErasure()})).make();
        builder = builder.require(new DynamicType[]{converterType});
        ElementMatcher.Junction fieldMatcher = ElementMatchers.is((FieldDescription.InDefinedShape)field);
        String logMessage = String.format("%s - Adding @j.p.Convert(converter=%s)", field.getName(), PluginUtils.abbreviate((TypeDefinition)converterType.getTypeDescription()));
        ArrayList<AnnotationDescription> annotations = new ArrayList<AnnotationDescription>();
        if (isCollection) {
            Class elementCollectionAnnotation = this.jpa.getAnnotation("ElementCollection");
            logMessage = logMessage + " and " + PluginUtils.abbreviate(elementCollectionAnnotation);
            annotations.add(PluginUtils.getAnnotation(elementCollectionAnnotation));
        }
        log.info(logMessage + ".", field.getName(), PluginUtils.abbreviate((TypeDefinition)converterType.getTypeDescription()));
        annotations.add(AnnotationDescription.Builder.ofType(this.jpa.getAnnotation("Convert")).define("converter", converterType.getTypeDescription()).build());
        return builder.field((ElementMatcher)fieldMatcher).annotateField(annotations);
    }

    private static TypeDescription.Generic getIdPrimitiveType(TypeDescription.Generic idType) {
        List fields = idType.getDeclaredFields().stream().filter(it -> !it.isStatic()).collect(Collectors.toList());
        return fields.isEmpty() ? JMoleculesSpringJpaPlugin.getIdPrimitiveType(idType.getSuperClass()) : ((FieldDescription.InGenericShape)fields.get(0)).getType();
    }

    private Constructor<?> getConverterConstructor() {
        return JMoleculesSpringJpaPlugin.getConstructor(this.jpa.getAssociationAttributeConverterBaseType(), Class.class);
    }

    private static Constructor<?> getConstructor(Class<?> type, Class<?> ... parameters) {
        try {
            return type.getDeclaredConstructor(parameters);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Predicate<? super FieldDescription.InDefinedShape> isAssociationOrCollectionThereof() {
        return it -> {
            TypeDescription.Generic type = it.getType();
            TypeDescription rawType = type.asErasure();
            if (rawType.represents(Association.class)) {
                return true;
            }
            if (!rawType.isAssignableTo(Collection.class)) {
                return false;
            }
            TypeList.Generic arguments = type.getTypeArguments();
            return !arguments.isEmpty() && ((TypeDescription.Generic)arguments.get(0)).asErasure().represents(Association.class);
        };
    }

    public JMoleculesSpringJpaPlugin() {
    }

    public JMoleculesSpringJpaPlugin(Jpa jpa) {
        this.jpa = jpa;
    }
}

