/*
 * Decompiled with CFR 0.152.
 */
package org.jmolecules.bytebuddy;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.bytebuddy.asm.AsmVisitorWrapper;
import net.bytebuddy.asm.MemberAttributeExtension;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.annotation.AnnotationList;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.field.FieldList;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodCall;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.jmolecules.bytebuddy.JMoleculesType;
import org.jmolecules.bytebuddy.PersistableImplementor;
import org.jmolecules.bytebuddy.PersistableOptions;
import org.jmolecules.bytebuddy.PluginLogger;
import org.jmolecules.bytebuddy.PluginUtils;
import org.jmolecules.ddd.annotation.Identity;
import org.jmolecules.ddd.types.AggregateRoot;
import org.jmolecules.ddd.types.Entity;
import org.jmolecules.ddd.types.Identifiable;
import org.jmolecules.ddd.types.Identifier;

class JMoleculesTypeBuilder
extends JMoleculesType {
    private final PluginLogger.Log logger;
    private final DynamicType.Builder<?> builder;

    JMoleculesTypeBuilder(PluginLogger.Log logger, DynamicType.Builder<?> builder) {
        super(builder.toTypeDescription());
        this.logger = logger;
        this.builder = builder;
    }

    public static JMoleculesTypeBuilder of(PluginLogger.Log logger, DynamicType.Builder<?> builder) {
        if (logger == null) {
            throw new IllegalArgumentException("PluginLogger must not be null!");
        }
        if (builder == null) {
            throw new IllegalArgumentException("Builder must not be null!");
        }
        return new JMoleculesTypeBuilder(logger, builder);
    }

    public JMoleculesTypeBuilder implement(Class<?> interfaze) {
        if (this.type.isAssignableTo(interfaze)) {
            return this;
        }
        this.logger.info("{} - Implement {}.", PluginUtils.abbreviate((TypeDefinition)this.type), PluginUtils.abbreviate(interfaze));
        return this.mapBuilder((DynamicType.Builder<?> it, PluginLogger.Log log) -> it.implement(new Type[]{interfaze}));
    }

    public JMoleculesTypeBuilder implement(Class<?> interfaze, TypeDefinition ... generics) {
        TypeDescription loadedType = TypeDescription.Generic.Builder.rawType(interfaze).build().asErasure();
        TypeDescription.Generic build = TypeDescription.Generic.Builder.parameterizedType((TypeDescription)loadedType, (TypeDefinition[])generics).build();
        String types = Arrays.stream(generics).map(PluginUtils::abbreviate).collect(Collectors.joining(", "));
        this.logger.info("Implementing {}.", PluginUtils.abbreviate(interfaze).concat("<").concat(types).concat(">"));
        return this.mapBuilder((DynamicType.Builder<?> builder) -> builder.implement(new TypeDefinition[]{build}));
    }

    @SafeVarargs
    public final JMoleculesTypeBuilder annotateTypeIfMissing(Class<? extends Annotation> annotation, Class<? extends Annotation> ... additionalFilters) {
        return this.addAnnotationIfMissing(annotation, additionalFilters);
    }

    @SafeVarargs
    public final JMoleculesTypeBuilder annotateTypeIfMissing(Function<TypeDescription, Class<? extends Annotation>> producer, Class<? extends Annotation> ... additionalFilters) {
        return this.addAnnotationIfMissing(producer, additionalFilters);
    }

    public JMoleculesTypeBuilder implementPersistable(PersistableOptions options) {
        return PersistableImplementor.of(options).implementPersistable(this, this.logger);
    }

    @SafeVarargs
    public final JMoleculesTypeBuilder annotateIdentifierWith(Class<? extends Annotation> annotation, Class<? extends Annotation> ... filterAnnotations) {
        ElementMatcher.Junction isIdentifierField = ElementMatchers.fieldType((ElementMatcher)ElementMatchers.isSubTypeOf(Identifier.class)).or((ElementMatcher)ElementMatchers.isAnnotatedWith(Identity.class));
        return this.annotateFieldWith(annotation, (ElementMatcher.Junction<FieldDescription>)isIdentifierField, filterAnnotations);
    }

    @SafeVarargs
    public final JMoleculesTypeBuilder annotateTypedIdentifierWith(Class<? extends Annotation> annotation, Class<? extends Annotation> ... filterAnnotations) {
        return this.findIdField().map(FieldDescription::getType).map(TypeDefinition::asErasure).map(ElementMatchers::isSubTypeOf).map(ElementMatchers::fieldType).map((? super T it) -> this.annotateFieldWith(annotation, (ElementMatcher.Junction<FieldDescription>)it, filterAnnotations)).orElse(this);
    }

    @SafeVarargs
    public final JMoleculesTypeBuilder annotateFieldWith(Class<? extends Annotation> annotation, ElementMatcher.Junction<FieldDescription> selector, Class<? extends Annotation> ... filterAnnotations) {
        return this.annotateFieldWith(PluginUtils.getAnnotation(annotation), selector, filterAnnotations);
    }

    @SafeVarargs
    public final JMoleculesTypeBuilder annotateFieldWith(AnnotationDescription annotation, ElementMatcher.Junction<FieldDescription> selector, Class<? extends Annotation> ... filterAnnotations) {
        ElementMatcher.Junction alreadyAnnotated = ElementMatchers.isAnnotatedWith((TypeDescription)annotation.getAnnotationType());
        for (Class<? extends Annotation> filterAnnotation : filterAnnotations) {
            alreadyAnnotated = alreadyAnnotated.or((ElementMatcher)ElementMatchers.isAnnotatedWith(filterAnnotation));
        }
        AsmVisitorWrapper annotationSpec = new MemberAttributeExtension.ForField().annotate(new AnnotationDescription[]{annotation}).on(PluginUtils.defaultMapping(this.logger, (ElementMatcher.Junction<FieldDescription>)selector.and((ElementMatcher)ElementMatchers.not((ElementMatcher)alreadyAnnotated)), annotation));
        return JMoleculesTypeBuilder.of(this.logger, this.builder.visit(annotationSpec));
    }

    @SafeVarargs
    public final JMoleculesTypeBuilder annotateAnnotatedIdentifierWith(Class<? extends Annotation> annotation, Class<? extends Annotation> ... filterAnnotations) {
        return this.annotateFieldWith(annotation, (ElementMatcher.Junction<FieldDescription>)ElementMatchers.isAnnotatedWith(Identity.class), filterAnnotations);
    }

    public JMoleculesTypeBuilder map(Function<JMoleculesTypeBuilder, JMoleculesTypeBuilder> function) {
        return function.apply(this);
    }

    public JMoleculesTypeBuilder map(BiFunction<JMoleculesTypeBuilder, PluginLogger.Log, JMoleculesTypeBuilder> mapper) {
        return mapper.apply(this, this.logger);
    }

    public JMoleculesTypeBuilder mapBuilder(Function<DynamicType.Builder<?>, DynamicType.Builder<?>> mapper) {
        return JMoleculesTypeBuilder.of(this.logger, mapper.apply(this.builder));
    }

    public JMoleculesTypeBuilder mapBuilder(BiFunction<DynamicType.Builder<?>, PluginLogger.Log, DynamicType.Builder<?>> mapper) {
        return JMoleculesTypeBuilder.of(this.logger, mapper.apply(this.builder, this.logger));
    }

    public JMoleculesTypeBuilder mapBuilder(Predicate<JMoleculesTypeBuilder> filter, Function<DynamicType.Builder<?>, DynamicType.Builder<?>> mapper) {
        return filter.test(this) ? JMoleculesTypeBuilder.of(this.logger, mapper.apply(this.builder)) : this;
    }

    public JMoleculesTypeBuilder map(Predicate<JMoleculesTypeBuilder> filter, Function<JMoleculesTypeBuilder, JMoleculesTypeBuilder> mapper) {
        return filter.test(this) ? mapper.apply(this) : this;
    }

    public JMoleculesTypeBuilder mapLogged(Predicate<JMoleculesTypeBuilder> filter, BiFunction<JMoleculesTypeBuilder, PluginLogger.Log, JMoleculesTypeBuilder> mapper) {
        return filter.test(this) ? mapper.apply(this, this.logger) : this;
    }

    public JMoleculesType mapIdField(BiFunction<FieldDescription.InDefinedShape, JMoleculesTypeBuilder, JMoleculesTypeBuilder> mapper) {
        return this.findIdField().map((? super T it) -> (JMoleculesTypeBuilder)mapper.apply((FieldDescription.InDefinedShape)it, this)).orElse(this);
    }

    public JMoleculesTypeBuilder addDefaultConstructorIfMissing() {
        return this.mapBuilder((DynamicType.Builder<?> builder, PluginLogger.Log logger) -> {
            boolean hasDefaultConstructor;
            boolean bl = hasDefaultConstructor = !((MethodList)((MethodList)this.type.getDeclaredMethods().filter(it -> it.isConstructor())).filter(it -> it.getParameters().size() == 0)).isEmpty();
            if (hasDefaultConstructor) {
                logger.info("Default constructor already present.", new Object[0]);
                return builder;
            }
            TypeDescription.Generic superClass = this.type.getSuperClass();
            Iterator superClassConstructors = ((MethodList)((MethodList)superClass.getDeclaredMethods().filter(it -> it.isConstructor())).filter(it -> it.getParameters().size() == 0)).iterator();
            MethodDescription.InGenericShape superClassConstructor = superClassConstructors.hasNext() ? (MethodDescription.InGenericShape)superClassConstructors.next() : null;
            String superClassName = PluginUtils.abbreviate((TypeDefinition)superClass);
            if (superClassConstructor == null) {
                logger.info("No default constructor found on superclass {}. Skipping default constructor creation.", superClassName);
                return builder;
            }
            logger.info("Adding default constructor.", new Object[0]);
            return builder.defineConstructor(new ModifierContributor.ForMethod[]{Visibility.PUBLIC}).intercept((Implementation)MethodCall.invoke((MethodDescription)superClassConstructor));
        });
    }

    public DynamicType.Builder<?> conclude() {
        return this.builder;
    }

    @SafeVarargs
    private final JMoleculesTypeBuilder addAnnotationIfMissing(Class<? extends Annotation> annotation, Class<? extends Annotation> ... exclusions) {
        return this.addAnnotationIfMissing((TypeDescription __) -> annotation, exclusions);
    }

    @SafeVarargs
    private final JMoleculesTypeBuilder addAnnotationIfMissing(Function<TypeDescription, Class<? extends Annotation>> producer, Class<? extends Annotation> ... exclusions) {
        AnnotationList existing = this.type.getDeclaredAnnotations();
        Class<? extends Annotation> annotation = producer.apply(this.type);
        String annotationName = PluginUtils.abbreviate(annotation);
        if (existing.isAnnotationPresent(annotation)) {
            this.logger.info("Not adding @{} because type is already annotated with it.", annotationName);
            return this;
        }
        boolean existingFound = Stream.of(exclusions).anyMatch(it -> {
            boolean found = existing.isAnnotationPresent(it);
            if (found) {
                this.logger.info("Not adding @{} because type is already annotated with @{}.", annotationName, PluginUtils.abbreviate(it));
            }
            return found;
        });
        if (existingFound) {
            return this;
        }
        this.logger.info("Adding @{}.", annotationName);
        return JMoleculesTypeBuilder.of(this.logger, this.builder.annotateType(new AnnotationDescription[]{PluginUtils.getAnnotation(annotation)}));
    }

    public Optional<FieldDescription.InDefinedShape> findIdField() {
        TypeDescription type = this.builder.toTypeDescription();
        TypeDescription.Generic superType = type.getInterfaces().stream().filter(it -> it.asErasure().represents(AggregateRoot.class) || it.asErasure().represents(Entity.class)).findFirst().orElse(null);
        if (superType != null) {
            int index = superType.asErasure().represents(Identifiable.class) ? 0 : 1;
            try {
                TypeDescription.Generic aggregateIdType = (TypeDescription.Generic)superType.asGenericType().getTypeArguments().get(index);
                return type.getDeclaredFields().stream().filter(it -> it.getType().equals(aggregateIdType)).findFirst();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return ((FieldList)type.getDeclaredFields().filter((ElementMatcher)ElementMatchers.isAnnotatedWith(Identity.class))).stream().findFirst();
    }
}

