/*
 * Decompiled with CFR 0.152.
 */
package org.jmolecules.bytebuddy;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.bytebuddy.asm.AsmVisitorWrapper;
import net.bytebuddy.asm.MemberAttributeExtension;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.annotation.AnnotationList;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.field.FieldList;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodCall;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.jmolecules.bytebuddy.JMoleculesElementMatchers;
import org.jmolecules.bytebuddy.PersistableImplementor;
import org.jmolecules.bytebuddy.PersistableOptions;
import org.jmolecules.bytebuddy.PluginLogger;
import org.jmolecules.bytebuddy.PluginUtils;
import org.jmolecules.ddd.annotation.Identity;
import org.jmolecules.ddd.types.AggregateRoot;
import org.jmolecules.ddd.types.Association;
import org.jmolecules.ddd.types.Entity;
import org.jmolecules.ddd.types.Identifier;
import org.jmolecules.ddd.types.ValueObject;
import org.springframework.util.Assert;

class JMoleculesType {
    private final PluginLogger.Log logger;
    private final DynamicType.Builder<?> builder;
    private final TypeDescription type;

    public static JMoleculesType of(PluginLogger.Log logger, DynamicType.Builder<?> builder) {
        Assert.notNull((Object)logger, (String)"PluginLogger must not be null!");
        Assert.notNull(builder, (String)"Builder must not be null!");
        return new JMoleculesType(logger, builder, builder.toTypeDescription());
    }

    public boolean hasOrImplements(Class<?> ... types) {
        return Arrays.stream(types).anyMatch(it -> it.isAnnotation() && this.hasAnnotation((Class<? extends Annotation>)it) || this.isAssignableTo((Class<?>)it));
    }

    public boolean hasAnnotation(Class<? extends Annotation> annotation) {
        return JMoleculesElementMatchers.hasAnnotation(this.type, annotation);
    }

    public boolean hasMethod(ElementMatcher<MethodDescription.InDefinedShape> matcher) {
        return !((MethodList)this.type.getDeclaredMethods().filter(matcher)).isEmpty();
    }

    public boolean hasField(ElementMatcher<? super FieldDescription.InDefinedShape> matcher) {
        return !((FieldList)this.type.getDeclaredFields().filter(matcher)).isEmpty();
    }

    public boolean hasMoreThanOneField(ElementMatcher<? super FieldDescription.InDefinedShape> matcher) {
        return ((FieldList)this.type.getDeclaredFields().filter(matcher)).size() > 1;
    }

    public boolean isAssignableTo(Class<?> candidate) {
        return this.type.isAssignableTo(candidate);
    }

    public boolean isAbstract() {
        return this.type.isAbstract();
    }

    public boolean isAggregateRoot() {
        return this.hasOrImplements(AggregateRoot.class, org.jmolecules.ddd.annotation.AggregateRoot.class);
    }

    public boolean isEntity() {
        return this.hasOrImplements(Entity.class, org.jmolecules.ddd.annotation.Entity.class);
    }

    public boolean isAssociation() {
        return this.isAssignableTo(Association.class);
    }

    public boolean isIdentifier() {
        return this.isAssignableTo(Identifier.class);
    }

    public boolean isValueObject() {
        return this.hasOrImplements(ValueObject.class, org.jmolecules.ddd.annotation.ValueObject.class);
    }

    public TypeDescription getTypeDescription() {
        return this.type;
    }

    public JMoleculesType implement(Class<?> interfaze) {
        if (this.type.isAssignableTo(interfaze)) {
            return this;
        }
        this.logger.info("{} - Implement {}.", PluginUtils.abbreviate((TypeDefinition)this.type), PluginUtils.abbreviate(interfaze));
        return this.map((it, log) -> it.implement(new Type[]{interfaze}));
    }

    public JMoleculesType implement(Class<?> interfaze, TypeDefinition ... generics) {
        TypeDescription loadedType = TypeDescription.Generic.Builder.rawType(interfaze).build().asErasure();
        TypeDescription.Generic build = TypeDescription.Generic.Builder.parameterizedType((TypeDescription)loadedType, (TypeDefinition[])generics).build();
        String types = Arrays.stream(generics).map(PluginUtils::abbreviate).collect(Collectors.joining(", "));
        this.logger.info("Implementing {}.", PluginUtils.abbreviate(interfaze).concat("<").concat(types).concat(">"));
        return this.mapBuilder(builder -> builder.implement(new TypeDefinition[]{build}));
    }

    @SafeVarargs
    public final JMoleculesType annotateTypeIfMissing(Class<? extends Annotation> annotation, Class<? extends Annotation> ... additionalFilters) {
        return this.addAnnotationIfMissing(annotation, additionalFilters);
    }

    @SafeVarargs
    public final JMoleculesType annotateTypeIfMissing(Function<TypeDescription, Class<? extends Annotation>> producer, Class<? extends Annotation> ... additionalFilters) {
        return this.addAnnotationIfMissing(producer, additionalFilters);
    }

    public JMoleculesType implementPersistable(PersistableOptions options) {
        return PersistableImplementor.of(options).implementPersistable(this);
    }

    @SafeVarargs
    public final JMoleculesType annotateIdentifierWith(Class<? extends Annotation> annotation, Class<? extends Annotation> ... filterAnnotations) {
        ElementMatcher.Junction isIdentifierField = ElementMatchers.fieldType((ElementMatcher)ElementMatchers.isSubTypeOf(Identifier.class)).or((ElementMatcher)ElementMatchers.isAnnotatedWith(Identity.class));
        return this.annotateFieldWith(annotation, (ElementMatcher.Junction<FieldDescription>)isIdentifierField, filterAnnotations);
    }

    @SafeVarargs
    public final JMoleculesType annotateTypedIdentifierWith(Class<? extends Annotation> annotation, Class<? extends Annotation> ... filterAnnotations) {
        return this.annotateFieldWith(annotation, (ElementMatcher.Junction<FieldDescription>)ElementMatchers.fieldType((ElementMatcher)ElementMatchers.isSubTypeOf(Identifier.class)), filterAnnotations);
    }

    @SafeVarargs
    public final JMoleculesType annotateFieldWith(Class<? extends Annotation> annotation, ElementMatcher.Junction<FieldDescription> selector, Class<? extends Annotation> ... filterAnnotations) {
        return this.annotateFieldWith(PluginUtils.getAnnotation(annotation), selector, filterAnnotations);
    }

    @SafeVarargs
    public final JMoleculesType annotateFieldWith(AnnotationDescription annotation, ElementMatcher.Junction<FieldDescription> selector, Class<? extends Annotation> ... filterAnnotations) {
        ElementMatcher.Junction alreadyAnnotated = ElementMatchers.isAnnotatedWith((TypeDescription)annotation.getAnnotationType());
        for (Class<? extends Annotation> filterAnnotation : filterAnnotations) {
            alreadyAnnotated = alreadyAnnotated.or((ElementMatcher)ElementMatchers.isAnnotatedWith(filterAnnotation));
        }
        AsmVisitorWrapper annotationSpec = new MemberAttributeExtension.ForField().annotate(new AnnotationDescription[]{annotation}).on(PluginUtils.defaultMapping(this.logger, (ElementMatcher.Junction<FieldDescription>)selector.and((ElementMatcher)ElementMatchers.not((ElementMatcher)alreadyAnnotated)), annotation));
        return JMoleculesType.of(this.logger, this.builder.visit(annotationSpec));
    }

    @SafeVarargs
    public final JMoleculesType annotateAnnotatedIdentifierWith(Class<? extends Annotation> annotation, Class<? extends Annotation> ... filterAnnotations) {
        return this.annotateFieldWith(annotation, (ElementMatcher.Junction<FieldDescription>)ElementMatchers.isAnnotatedWith(Identity.class), filterAnnotations);
    }

    public JMoleculesType map(BiFunction<DynamicType.Builder<?>, PluginLogger.Log, DynamicType.Builder<?>> mapper) {
        return JMoleculesType.of(this.logger, mapper.apply(this.builder, this.logger));
    }

    public JMoleculesType mapBuilder(Function<DynamicType.Builder<?>, DynamicType.Builder<?>> mapper) {
        return JMoleculesType.of(this.logger, mapper.apply(this.builder));
    }

    public JMoleculesType mapBuilder(Predicate<JMoleculesType> filter, Function<DynamicType.Builder<?>, DynamicType.Builder<?>> mapper) {
        return filter.test(this) ? JMoleculesType.of(this.logger, mapper.apply(this.builder)) : this;
    }

    public JMoleculesType map(Predicate<JMoleculesType> filter, Function<JMoleculesType, JMoleculesType> mapper) {
        return filter.test(this) ? mapper.apply(this) : this;
    }

    public JMoleculesType mapIdField(BiFunction<FieldDescription.InDefinedShape, JMoleculesType, JMoleculesType> mapper) {
        return this.findIdField().map((? super T it) -> (JMoleculesType)mapper.apply((FieldDescription.InDefinedShape)it, this)).orElse(this);
    }

    public JMoleculesType addDefaultConstructorIfMissing() {
        return this.map((builder, logger) -> {
            boolean hasDefaultConstructor;
            boolean bl = hasDefaultConstructor = !((MethodList)((MethodList)this.type.getDeclaredMethods().filter(it -> it.isConstructor())).filter(it -> it.getParameters().size() == 0)).isEmpty();
            if (hasDefaultConstructor) {
                logger.info("Default constructor already present.", new Object[0]);
                return builder;
            }
            TypeDescription.Generic superClass = this.type.getSuperClass();
            Iterator superClassConstructors = ((MethodList)((MethodList)superClass.getDeclaredMethods().filter(it -> it.isConstructor())).filter(it -> it.getParameters().size() == 0)).iterator();
            MethodDescription.InGenericShape superClassConstructor = superClassConstructors.hasNext() ? (MethodDescription.InGenericShape)superClassConstructors.next() : null;
            String superClassName = PluginUtils.abbreviate((TypeDefinition)superClass);
            if (superClassConstructor == null) {
                logger.info("No default constructor found on superclass {}. Skipping default constructor creation.", superClassName);
                return builder;
            }
            logger.info("Adding default constructor.", new Object[0]);
            return builder.defineConstructor(new ModifierContributor.ForMethod[]{Visibility.PUBLIC}).intercept((Implementation)MethodCall.invoke((MethodDescription)superClassConstructor));
        });
    }

    public DynamicType.Builder<?> conclude() {
        return this.builder;
    }

    @SafeVarargs
    private final JMoleculesType addAnnotationIfMissing(Class<? extends Annotation> annotation, Class<? extends Annotation> ... exclusions) {
        return this.addAnnotationIfMissing((TypeDescription __) -> annotation, exclusions);
    }

    @SafeVarargs
    private final JMoleculesType addAnnotationIfMissing(Function<TypeDescription, Class<? extends Annotation>> producer, Class<? extends Annotation> ... exclusions) {
        AnnotationList existing = this.type.getDeclaredAnnotations();
        Class<? extends Annotation> annotation = producer.apply(this.type);
        String annotationName = PluginUtils.abbreviate(annotation);
        if (existing.isAnnotationPresent(annotation)) {
            this.logger.info("Not adding @{} because type is already annotated with it.", annotationName);
            return this;
        }
        boolean existingFound = Stream.of(exclusions).anyMatch(it -> {
            boolean found = existing.isAnnotationPresent(it);
            if (found) {
                this.logger.info("Not adding @{} because type is already annotated with @{}.", annotationName, PluginUtils.abbreviate(it));
            }
            return found;
        });
        if (existingFound) {
            return this;
        }
        this.logger.info("Adding @{}.", annotationName);
        return JMoleculesType.of(this.logger, this.builder.annotateType(new AnnotationDescription[]{PluginUtils.getAnnotation(annotation)}));
    }

    public Optional<FieldDescription.InDefinedShape> findIdField() {
        TypeDescription type = this.builder.toTypeDescription();
        TypeDescription.Generic superType = type.getInterfaces().stream().filter(it -> it.asErasure().represents(AggregateRoot.class)).findFirst().orElse(null);
        if (superType != null) {
            TypeDescription.Generic aggregateIdType = (TypeDescription.Generic)superType.asGenericType().getTypeArguments().get(1);
            return type.getDeclaredFields().stream().filter(it -> it.getType().equals(aggregateIdType)).findFirst();
        }
        return ((FieldList)type.getDeclaredFields().filter((ElementMatcher)ElementMatchers.isAnnotatedWith(Identity.class))).stream().findFirst();
    }

    public boolean isRecord() {
        return this.builder.toTypeDescription().isRecord();
    }

    private JMoleculesType(PluginLogger.Log logger, DynamicType.Builder<?> builder, TypeDescription type) {
        this.logger = logger;
        this.builder = builder;
        this.type = type;
    }
}

