/*
 * Decompiled with CFR 0.152.
 */
package org.jmolecules.bytebuddy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.bytebuddy.description.type.TypeDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

enum PluginLogger {
    INSTANCE;

    private static final Logger log;
    private static boolean flushed;
    private final Map<String, List<LogEntry>> logs = new TreeMap<String, List<LogEntry>>();

    public Log getLog(TypeDescription description, String name) {
        Assert.notNull((Object)description, (String)"TypeDescription must not be null!");
        Assert.hasText((String)name, (String)"Module name must not be null or empty!");
        List moduleLogs = this.logs.computeIfAbsent(description.getName(), it -> new ArrayList());
        return (message, parameters) -> moduleLogs.add(new LogEntry(name, message, parameters));
    }

    public void flush() {
        if (flushed) {
            return;
        }
        try {
            if (!this.logs.isEmpty()) {
                log.info("");
            }
            this.logs.forEach((description, moduleLogs) -> {
                if (moduleLogs.isEmpty()) {
                    return;
                }
                Collections.sort(moduleLogs, Comparator.comparing(LogEntry::getModule).thenComparing(LogEntry::getMessage));
                log.info("\u25a1- " + description);
                for (int i = 0; i < moduleLogs.size(); ++i) {
                    LogEntry logEntry = (LogEntry)moduleLogs.get(i);
                    String module = logEntry.getModule();
                    String prefix = i + 1 == moduleLogs.size() ? "\u2514\u2500 " : "\u251c\u2500 ";
                    log.info(String.format("%s%s - %s", prefix, module, logEntry.getMessage()), logEntry.getParameters());
                }
                log.info("");
            });
        }
        finally {
            flushed = true;
        }
    }

    static {
        log = LoggerFactory.getLogger(PluginLogger.class);
        flushed = false;
    }

    public static interface Log {
        public void info(String var1, Object ... var2);
    }

    private static final class LogEntry {
        private final String module;
        private final String message;
        private final Object[] parameters;

        public LogEntry(String module, String message, Object[] parameters) {
            this.module = module;
            this.message = message;
            this.parameters = parameters;
        }

        public String getModule() {
            return this.module;
        }

        public String getMessage() {
            return this.message;
        }

        public Object[] getParameters() {
            return this.parameters;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LogEntry)) {
                return false;
            }
            LogEntry other = (LogEntry)o;
            String this$module = this.getModule();
            String other$module = other.getModule();
            if (this$module == null ? other$module != null : !this$module.equals(other$module)) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
                return false;
            }
            return Arrays.deepEquals(this.getParameters(), other.getParameters());
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $module = this.getModule();
            result = result * 59 + ($module == null ? 43 : $module.hashCode());
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getParameters());
            return result;
        }

        public String toString() {
            return "PluginLogger.LogEntry(module=" + this.getModule() + ", message=" + this.getMessage() + ", parameters=" + Arrays.deepToString(this.getParameters()) + ")";
        }
    }
}

