/*
 * Decompiled with CFR 0.152.
 */
package org.jmolecules.bytebuddy;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.annotation.AnnotationList;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.jmolecules.bytebuddy.PluginLogger;
import org.jmolecules.ddd.types.Identifier;
import org.springframework.util.ClassUtils;

class PluginUtils {
    PluginUtils() {
    }

    static boolean isAnnotatedWith(TypeDescription type, Class<?> annotationType) {
        return type.getDeclaredAnnotations().asTypeList().stream().anyMatch(it -> it.isAssignableTo(annotationType));
    }

    static AnnotationDescription getAnnotation(Class<? extends Annotation> type) {
        return AnnotationDescription.Builder.ofType(type).build();
    }

    static DynamicType.Builder<?> mapAnnotationOrInterfaces(DynamicType.Builder<?> builder, TypeDescription type, Map<Class<?>, Class<? extends Annotation>> mappings, PluginLogger.Log log) {
        for (Map.Entry<Class<?>, Class<Annotation>> entry : mappings.entrySet()) {
            Class<?> source = entry.getKey();
            if (!(source.isAnnotation() ? PluginUtils.isAnnotatedWith(type, source) : type.isAssignableTo(source))) continue;
            builder = PluginUtils.addAnnotationIfMissing(entry.getValue(), builder, type, log);
        }
        return builder;
    }

    static ElementMatcher<FieldDescription> defaultMapping(PluginLogger.Log logger, ElementMatcher.Junction<FieldDescription> source, AnnotationDescription annotation) {
        return it -> {
            boolean matches = source.matches(it);
            if (matches) {
                logger.info("Defaulting {} mapping to {}.", it.getName(), PluginUtils.abbreviate(annotation));
            }
            return matches;
        };
    }

    @SafeVarargs
    static DynamicType.Builder<?> annotateIdentifierWith(PluginLogger.Log logger, DynamicType.Builder<?> builder, Class<? extends Annotation> type, Class<? extends Annotation> ... filterAnnotations) {
        AnnotationDescription idAnnotation = PluginUtils.getAnnotation(type);
        ElementMatcher.Junction alreadyAnnotated = ElementMatchers.isAnnotatedWith(type);
        for (Class<? extends Annotation> filterAnnotation : filterAnnotations) {
            alreadyAnnotated = alreadyAnnotated.or((ElementMatcher)ElementMatchers.isAnnotatedWith(filterAnnotation));
        }
        return builder.field(PluginUtils.defaultMapping(logger, (ElementMatcher.Junction<FieldDescription>)ElementMatchers.fieldType((ElementMatcher)ElementMatchers.isSubTypeOf(Identifier.class)).and((ElementMatcher)ElementMatchers.not((ElementMatcher)alreadyAnnotated)), idAnnotation)).annotateField(new AnnotationDescription[]{idAnnotation});
    }

    static String abbreviate(Class<?> type) {
        return PluginUtils.abbreviate(type.getName());
    }

    static String abbreviate(TypeDefinition type) {
        return PluginUtils.abbreviate(type.getTypeName());
    }

    static String abbreviate(AnnotationDescription annotation) {
        String annotationString = annotation.toString();
        int openParenthesisIndex = annotationString.indexOf("(");
        String annotationName = annotationString.substring(1, openParenthesisIndex);
        return "@".concat(PluginUtils.abbreviate(annotationName)).concat(annotationString.substring(openParenthesisIndex));
    }

    static String abbreviate(String fullyQualifiedTypeName) {
        String abbreviatedPackage = Arrays.stream(ClassUtils.getPackageName((String)fullyQualifiedTypeName).split("\\.")).map(it -> it.substring(0, 1)).collect(Collectors.joining("."));
        return abbreviatedPackage.concat(".").concat(ClassUtils.getShortName((String)fullyQualifiedTypeName));
    }

    @SafeVarargs
    static DynamicType.Builder<?> addAnnotationIfMissing(Class<? extends Annotation> annotation, DynamicType.Builder<?> builder, TypeDescription type, PluginLogger.Log log, Class<? extends Annotation> ... exclusions) {
        return PluginUtils.addAnnotationIfMissing((TypeDescription __) -> annotation, builder, type, log, exclusions);
    }

    @SafeVarargs
    static DynamicType.Builder<?> addAnnotationIfMissing(Function<TypeDescription, Class<? extends Annotation>> producer, DynamicType.Builder<?> builder, TypeDescription type, PluginLogger.Log log, Class<? extends Annotation> ... exclusions) {
        AnnotationList existing = type.getDeclaredAnnotations();
        Class<? extends Annotation> annotation = producer.apply(type);
        String annotationName = PluginUtils.abbreviate(annotation);
        boolean existingFound = Stream.of(exclusions).anyMatch(it -> {
            boolean found = existing.isAnnotationPresent(it);
            if (found) {
                log.info("Not adding @{} because type is already annotated with @{}.", annotationName, PluginUtils.abbreviate(it));
            }
            return found;
        });
        if (existingFound) {
            return builder;
        }
        log.info("Adding @{}.", annotationName);
        return builder.annotateType(new AnnotationDescription[]{PluginUtils.getAnnotation(annotation)});
    }

    static <T> Supplier<T> memoized(final Supplier<T> source) {
        return new Supplier<T>(){
            private T instance;

            @Override
            public T get() {
                if (this.instance == null) {
                    this.instance = source.get();
                }
                return this.instance;
            }
        };
    }

    private static DynamicType.Builder<?> addAnnotationIfMissing(Class<? extends Annotation> annotation, DynamicType.Builder<?> builder, TypeDescription type, PluginLogger.Log log) {
        if (PluginUtils.isAnnotatedWith(type, annotation)) {
            log.info("Not adding @{}, already present.", PluginUtils.abbreviate(annotation));
            return builder;
        }
        log.info("Adding @{}.", PluginUtils.abbreviate(annotation));
        return builder.annotateType(new AnnotationDescription[]{PluginUtils.getAnnotation(annotation)});
    }

    static String toLog(FieldDescription field) {
        TypeDefinition type = field.getDeclaringType();
        return PluginUtils.abbreviate(type).concat(".").concat(field.getName());
    }
}

