/*
 * Decompiled with CFR 0.152.
 */
package org.jmolecules.bytebuddy;

import java.util.stream.Stream;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.description.type.TypeList;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.jmolecules.bytebuddy.EntityImplementor;
import org.jmolecules.bytebuddy.JMoleculesType;
import org.jmolecules.bytebuddy.JMoleculesTypeBuilder;
import org.jmolecules.bytebuddy.LoggingPlugin;
import org.jmolecules.bytebuddy.PluginLogger;
import org.jmolecules.bytebuddy.PluginUtils;

class EntityPlugin
implements LoggingPlugin {
    private static final EntityImplementor ENTITY_IMPLEMENTOR = new EntityImplementor();
    private final String moduleName;

    public EntityPlugin(String moduleName) {
        this.moduleName = moduleName;
    }

    public boolean matches(TypeDescription target) {
        if (target.isAnnotation() || PluginUtils.isCglibProxyType((TypeDefinition)target)) {
            return false;
        }
        boolean implementsJMoleculesInterface = !((TypeList.Generic)target.getInterfaces().filter((ElementMatcher)ElementMatchers.nameStartsWith((String)"org.jmolecules"))).isEmpty();
        boolean hasJMoleculesAnnotation = Stream.concat(target.getDeclaredAnnotations().stream(), target.getInheritedAnnotations().stream()).anyMatch(it -> it.getAnnotationType().getName().startsWith("org.jmolecules"));
        if (implementsJMoleculesInterface || hasJMoleculesAnnotation) {
            return true;
        }
        TypeDescription.Generic superType = target.getSuperClass();
        return superType == null || superType.represents(Object.class) ? false : this.matches(superType.asErasure()) || target.isRecord();
    }

    public DynamicType.Builder<?> apply(DynamicType.Builder<?> builder, TypeDescription type, ClassFileLocator classFileLocator) {
        PluginLogger.Log log = PluginLogger.INSTANCE.getLog(type, this.moduleName);
        return JMoleculesTypeBuilder.of(log, builder).map(JMoleculesType::isEntity, this::handleEntity).conclude();
    }

    private JMoleculesTypeBuilder handleEntity(JMoleculesTypeBuilder type) {
        return type.map(ENTITY_IMPLEMENTOR::implementEntity);
    }
}

