/*
 * Decompiled with CFR 0.152.
 */
package org.jmolecules.bytebuddy;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.function.Function;
import javax.persistence.CascadeType;
import javax.persistence.Embeddable;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.PostLoad;
import javax.persistence.PrePersist;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.annotation.AnnotationSource;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.description.type.TypeList;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.jmolecules.bytebuddy.JMoleculesElementMatchers;
import org.jmolecules.bytebuddy.JMoleculesPluginSupport;
import org.jmolecules.bytebuddy.JMoleculesType;
import org.jmolecules.bytebuddy.PluginLogger;
import org.jmolecules.bytebuddy.PluginUtils;
import org.jmolecules.jpa.JMoleculesJpa;

public class JMoleculesJpaPlugin
extends JMoleculesPluginSupport {
    private static final PluginLogger logger = new PluginLogger("JPA");
    static final String NULLABILITY_METHOD_NAME = "__verifyNullability";

    public boolean matches(TypeDescription target) {
        if (target.isAnnotation()) {
            return false;
        }
        if (!((TypeList.Generic)target.getInterfaces().filter((ElementMatcher)ElementMatchers.nameStartsWith((String)"org.jmolecules"))).isEmpty()) {
            return true;
        }
        TypeDescription.Generic superType = target.getSuperClass();
        return superType == null || superType.represents(Object.class) ? false : this.matches(superType.asErasure());
    }

    public DynamicType.Builder<?> apply(DynamicType.Builder<?> builder, TypeDescription type, ClassFileLocator classFileLocator) {
        return JMoleculesType.of(logger, builder).mapBuilder(JMoleculesType::isAggregateRoot, this::handleAggregateRoot).map(JMoleculesType::isEntity, this::handleEntity).map(JMoleculesType::isAssociation, this::handleAssociation).map(JMoleculesType::isIdentifier, this::handleIdentifier).conclude();
    }

    private static <T extends AnnotationSource> ElementMatcher.Junction<T> hasJpaRelationShipAnnotation() {
        return ElementMatchers.isAnnotatedWith(OneToOne.class).or((ElementMatcher)ElementMatchers.isAnnotatedWith(OneToMany.class)).or((ElementMatcher)ElementMatchers.isAnnotatedWith(ManyToOne.class)).or((ElementMatcher)ElementMatchers.isAnnotatedWith(ManyToMany.class));
    }

    private JMoleculesType handleIdentifier(JMoleculesType type) {
        return type.implement(Serializable.class).addDefaultConstructorIfMissing().annotateTypeIfMissing(Embeddable.class, new Class[0]);
    }

    private JMoleculesType handleAssociation(JMoleculesType type) {
        return type.addDefaultConstructorIfMissing().annotateTypeIfMissing(Embeddable.class, new Class[0]);
    }

    private JMoleculesType handleEntity(JMoleculesType type) {
        Function<TypeDescription, Class<? extends Annotation>> selector = it -> !type.isAggregateRoot() && type.isAbstract() ? MappedSuperclass.class : Entity.class;
        return type.addDefaultConstructorIfMissing().annotateIdentifierWith(EmbeddedId.class, Id.class).annotateTypeIfMissing(selector, Entity.class, MappedSuperclass.class).map(this::declareNullVerificationMethod);
    }

    private DynamicType.Builder<?> handleAggregateRoot(DynamicType.Builder<?> builder) {
        AnnotationDescription oneToOneDescription = JMoleculesJpaPlugin.createCascadingAnnotation(OneToOne.class);
        builder = builder.field(PluginUtils.defaultMapping(logger, (ElementMatcher.Junction<FieldDescription>)ElementMatchers.fieldType(JMoleculesElementMatchers.isEntity()).and((ElementMatcher)ElementMatchers.not(JMoleculesJpaPlugin.hasJpaRelationShipAnnotation())), oneToOneDescription)).annotateField(new AnnotationDescription[]{oneToOneDescription});
        AnnotationDescription oneToManyDescription = JMoleculesJpaPlugin.createCascadingAnnotation(OneToMany.class);
        return builder.field(PluginUtils.defaultMapping(logger, (ElementMatcher.Junction<FieldDescription>)ElementMatchers.genericFieldType(JMoleculesElementMatchers.isCollectionOfEntity()).and((ElementMatcher)ElementMatchers.not(JMoleculesJpaPlugin.hasJpaRelationShipAnnotation())), oneToManyDescription)).annotateField(new AnnotationDescription[]{oneToManyDescription});
    }

    private static AnnotationDescription createCascadingAnnotation(Class<? extends Annotation> type) {
        return AnnotationDescription.Builder.ofType(type).defineEnumerationArray("cascade", CascadeType.class, (Enum[])new CascadeType[]{CascadeType.ALL}).build();
    }

    private DynamicType.Builder<?> declareNullVerificationMethod(DynamicType.Builder<?> builder, PluginLogger logger) {
        TypeDescription type = builder.toTypeDescription();
        String typeName = PluginUtils.abbreviate((TypeDefinition)type);
        if (type.isAbstract()) {
            logger.info("{} - Not generating nullability method for abstract type.", typeName);
            return builder;
        }
        if (((MethodList)type.getDeclaredMethods().filter(it -> it.getName().equals(NULLABILITY_METHOD_NAME))).size() > 0) {
            logger.info("{} - Found existing nullability method.", typeName);
            return builder;
        }
        logger.info("{} - Adding nullability verification method.", typeName);
        return builder.defineMethod(NULLABILITY_METHOD_NAME, Void.TYPE, new ModifierContributor.ForMethod[]{Visibility.PACKAGE_PRIVATE}).intercept((Implementation)MethodDelegation.to(JMoleculesJpa.class)).annotateMethod(new AnnotationDescription[]{PluginUtils.getAnnotation(PrePersist.class)}).annotateMethod(new AnnotationDescription[]{PluginUtils.getAnnotation(PostLoad.class)});
    }
}

