/*
 * Decompiled with CFR 0.152.
 */
package org.jmolecules.bytebuddy;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.bytebuddy.asm.AsmVisitorWrapper;
import net.bytebuddy.asm.MemberAttributeExtension;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.annotation.AnnotationList;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.field.FieldList;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodCall;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.jmolecules.bytebuddy.JMoleculesElementMatchers;
import org.jmolecules.bytebuddy.PersistableImplementor;
import org.jmolecules.bytebuddy.PersistableOptions;
import org.jmolecules.bytebuddy.PluginLogger;
import org.jmolecules.bytebuddy.PluginUtils;
import org.jmolecules.ddd.types.AggregateRoot;
import org.jmolecules.ddd.types.Association;
import org.jmolecules.ddd.types.Entity;
import org.jmolecules.ddd.types.Identifier;
import org.springframework.util.Assert;

class JMoleculesType {
    private final PluginLogger logger;
    private final DynamicType.Builder<?> builder;
    private final TypeDescription type;

    public static JMoleculesType of(PluginLogger logger, DynamicType.Builder<?> builder) {
        Assert.notNull((Object)logger, (String)"PluginLogger must not be null!");
        Assert.notNull(builder, (String)"Builder must not be null!");
        return new JMoleculesType(logger, builder, builder.toTypeDescription());
    }

    public boolean hasOrImplements(Class<?> ... types) {
        return Arrays.stream(types).anyMatch(it -> it.isAnnotation() && this.hasAnnotation((Class<? extends Annotation>)it) || this.isAssignableTo((Class<?>)it));
    }

    public boolean hasAnnotation(Class<? extends Annotation> annotation) {
        return JMoleculesElementMatchers.hasAnnotation(this.type, annotation);
    }

    public boolean hasMethod(ElementMatcher<MethodDescription.InDefinedShape> matcher) {
        return !((MethodList)this.type.getDeclaredMethods().filter(matcher)).isEmpty();
    }

    public boolean hasField(ElementMatcher<FieldDescription.InDefinedShape> matcher) {
        return !((FieldList)this.type.getDeclaredFields().filter(matcher)).isEmpty();
    }

    public boolean isAssignableTo(Class<?> candidate) {
        return this.type.isAssignableTo(candidate);
    }

    public boolean isAbstract() {
        return this.type.isAbstract();
    }

    public boolean isAggregateRoot() {
        return this.hasOrImplements(AggregateRoot.class, org.jmolecules.ddd.annotation.AggregateRoot.class);
    }

    public boolean isEntity() {
        return this.hasOrImplements(Entity.class, org.jmolecules.ddd.annotation.Entity.class);
    }

    public boolean isAssociation() {
        return this.isAssignableTo(Association.class);
    }

    public boolean isIdentifier() {
        return this.isAssignableTo(Identifier.class);
    }

    public String getAbbreviatedName() {
        return PluginUtils.abbreviate((TypeDefinition)this.type);
    }

    public TypeDescription getTypeDescription() {
        return this.type;
    }

    public JMoleculesType implement(Class<?> interfaze) {
        if (this.type.isAssignableTo(interfaze)) {
            return this;
        }
        this.logger.info("{} - Implement {}.", PluginUtils.abbreviate((TypeDefinition)this.type), PluginUtils.abbreviate(interfaze));
        return this.map((it, log) -> it.implement(new Type[]{interfaze}));
    }

    public JMoleculesType implement(Class<?> interfaze, TypeDefinition ... generics) {
        TypeDescription loadedType = TypeDescription.Generic.Builder.rawType(interfaze).build().asErasure();
        TypeDescription.Generic build = TypeDescription.Generic.Builder.parameterizedType((TypeDescription)loadedType, (TypeDefinition[])generics).build();
        String types = Arrays.stream(generics).map(PluginUtils::abbreviate).collect(Collectors.joining(", "));
        this.logger.info("{} - Implementing {}.", this.getAbbreviatedName(), PluginUtils.abbreviate(interfaze).concat("<").concat(types).concat(">"));
        return this.mapBuilder(builder -> builder.implement(new TypeDefinition[]{build}));
    }

    @SafeVarargs
    public final JMoleculesType annotateTypeIfMissing(Class<? extends Annotation> annotation, Class<? extends Annotation> ... additionalFilters) {
        return this.addAnnotationIfMissing(annotation, additionalFilters);
    }

    @SafeVarargs
    public final JMoleculesType annotateTypeIfMissing(Function<TypeDescription, Class<? extends Annotation>> producer, Class<? extends Annotation> ... additionalFilters) {
        return this.addAnnotationIfMissing(producer, additionalFilters);
    }

    public JMoleculesType implementPersistable(PersistableOptions options) {
        return PersistableImplementor.of(options).implementPersistable(this);
    }

    @SafeVarargs
    public final JMoleculesType annotateIdentifierWith(Class<? extends Annotation> annotation, Class<? extends Annotation> ... filterAnnotations) {
        AnnotationDescription idAnnotation = PluginUtils.getAnnotation(annotation);
        ElementMatcher.Junction alreadyAnnotated = ElementMatchers.isAnnotatedWith(annotation);
        for (Class<? extends Annotation> filterAnnotation : filterAnnotations) {
            alreadyAnnotated = alreadyAnnotated.or((ElementMatcher)ElementMatchers.isAnnotatedWith(filterAnnotation));
        }
        AsmVisitorWrapper annotationSpec = new MemberAttributeExtension.ForField().annotate(new AnnotationDescription[]{idAnnotation}).on(PluginUtils.defaultMapping(this.logger, (ElementMatcher.Junction<FieldDescription>)ElementMatchers.fieldType((ElementMatcher)ElementMatchers.isSubTypeOf(Identifier.class)).and((ElementMatcher)ElementMatchers.not((ElementMatcher)alreadyAnnotated)), idAnnotation));
        return JMoleculesType.of(this.logger, this.builder.visit(annotationSpec));
    }

    public JMoleculesType map(BiFunction<DynamicType.Builder<?>, PluginLogger, DynamicType.Builder<?>> mapper) {
        return JMoleculesType.of(this.logger, mapper.apply(this.builder, this.logger));
    }

    public JMoleculesType mapBuilder(Function<DynamicType.Builder<?>, DynamicType.Builder<?>> mapper) {
        return JMoleculesType.of(this.logger, mapper.apply(this.builder));
    }

    public JMoleculesType mapBuilder(Predicate<JMoleculesType> filter, Function<DynamicType.Builder<?>, DynamicType.Builder<?>> mapper) {
        return filter.test(this) ? JMoleculesType.of(this.logger, mapper.apply(this.builder)) : this;
    }

    public JMoleculesType map(Predicate<JMoleculesType> filter, Function<JMoleculesType, JMoleculesType> mapper) {
        return filter.test(this) ? mapper.apply(this) : this;
    }

    public JMoleculesType mapIdField(BiFunction<FieldDescription.InDefinedShape, JMoleculesType, JMoleculesType> mapper) {
        return this.findIdField().map((? super T it) -> (JMoleculesType)mapper.apply((FieldDescription.InDefinedShape)it, this)).orElse(this);
    }

    public JMoleculesType addDefaultConstructorIfMissing() {
        return this.map((builder, logger) -> {
            boolean hasDefaultConstructor;
            String typeName = PluginUtils.abbreviate((TypeDefinition)this.type);
            boolean bl = hasDefaultConstructor = !((MethodList)((MethodList)this.type.getDeclaredMethods().filter(it -> it.isConstructor())).filter(it -> it.getParameters().size() == 0)).isEmpty();
            if (hasDefaultConstructor) {
                logger.info("{} - Default constructor already present.", typeName);
                return builder;
            }
            TypeDescription.Generic superClass = this.type.getSuperClass();
            Iterator superClassConstructors = ((MethodList)((MethodList)superClass.getDeclaredMethods().filter(it -> it.isConstructor())).filter(it -> it.getParameters().size() == 0)).iterator();
            MethodDescription.InGenericShape superClassConstructor = superClassConstructors.hasNext() ? (MethodDescription.InGenericShape)superClassConstructors.next() : null;
            String superClassName = PluginUtils.abbreviate((TypeDefinition)superClass);
            if (superClassConstructor == null) {
                logger.info("{} - No default constructor found on superclass {}. Skipping default constructor creation.", typeName, superClassName);
                return builder;
            }
            logger.info("{} - Adding default constructor.", typeName);
            return builder.defineConstructor(new ModifierContributor.ForMethod[]{Visibility.PUBLIC}).intercept((Implementation)MethodCall.invoke((MethodDescription)superClassConstructor));
        });
    }

    public DynamicType.Builder<?> conclude() {
        return this.builder;
    }

    @SafeVarargs
    private final JMoleculesType addAnnotationIfMissing(Class<? extends Annotation> annotation, Class<? extends Annotation> ... exclusions) {
        return this.addAnnotationIfMissing((TypeDescription __) -> annotation, exclusions);
    }

    @SafeVarargs
    private final JMoleculesType addAnnotationIfMissing(Function<TypeDescription, Class<? extends Annotation>> producer, Class<? extends Annotation> ... exclusions) {
        AnnotationList existing = this.type.getDeclaredAnnotations();
        Class<? extends Annotation> annotation = producer.apply(this.type);
        String typeName = PluginUtils.abbreviate((TypeDefinition)this.type);
        String annotationName = PluginUtils.abbreviate(annotation);
        if (existing.isAnnotationPresent(annotation)) {
            this.logger.info("{} - Not adding @{} because type is already annotated with it.", typeName, annotationName);
            return this;
        }
        boolean existingFound = Stream.of(exclusions).anyMatch(it -> {
            boolean found = existing.isAnnotationPresent(it);
            if (found) {
                this.logger.info("{} - Not adding @{} because type is already annotated with @{}.", typeName, annotationName, PluginUtils.abbreviate(it));
            }
            return found;
        });
        if (existingFound) {
            return this;
        }
        this.logger.info("{} - Adding @{}.", typeName, annotationName);
        return JMoleculesType.of(this.logger, this.builder.annotateType(new AnnotationDescription[]{PluginUtils.getAnnotation(annotation)}));
    }

    public Optional<FieldDescription.InDefinedShape> findIdField() {
        TypeDescription type = this.builder.toTypeDescription();
        TypeDescription.Generic superType = type.getInterfaces().stream().filter(it -> it.asErasure().represents(AggregateRoot.class)).findFirst().orElse(null);
        if (superType == null) {
            return Optional.empty();
        }
        TypeDescription.Generic aggregateIdType = (TypeDescription.Generic)superType.asGenericType().getTypeArguments().get(1);
        return type.getDeclaredFields().stream().filter(it -> it.getType().equals(aggregateIdType)).findFirst();
    }

    private JMoleculesType(PluginLogger logger, DynamicType.Builder<?> builder, TypeDescription type) {
        this.logger = logger;
        this.builder = builder;
        this.type = type;
    }
}

