/*
 * Decompiled with CFR 0.152.
 */
package org.jmolecules.bytebuddy;

import net.bytebuddy.ByteBuddy;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.asm.AsmVisitorWrapper;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.implementation.EqualsMethod;
import net.bytebuddy.implementation.FieldAccessor;
import net.bytebuddy.implementation.HashCodeMethod;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.jmolecules.bytebuddy.JMoleculesType;
import org.jmolecules.bytebuddy.LifecycleMethods;
import org.jmolecules.bytebuddy.PersistableOptions;
import org.jmolecules.bytebuddy.PluginUtils;
import org.jmolecules.spring.data.MutablePersistable;
import org.springframework.data.domain.Persistable;
import org.springframework.stereotype.Component;

class PersistableImplementor {
    static final String IS_NEW_METHOD = "isNew";
    static final String MARK_NOT_NEW_METHOD = "__jMolecules__markNotNew";
    static final String IS_NEW_FIELD = "__jMolecules__isNew";
    private final PersistableOptions options;

    JMoleculesType implementPersistable(JMoleculesType type) {
        if (type.isAssignableTo(Persistable.class)) {
            return type;
        }
        return type.findIdField().map(field -> {
            ElementMatcher isIdField = candidate -> !candidate.getName().equals(field.getName());
            return type.implement(MutablePersistable.class, new TypeDefinition[]{type.getTypeDescription(), field.getType()}).mapBuilder(this::generateCallbacks).mapBuilder(it -> !it.hasField((ElementMatcher<FieldDescription.InDefinedShape>)ElementMatchers.named((String)IS_NEW_FIELD)), this::generateIsNewField).mapBuilder(it -> !it.hasMethod((ElementMatcher<MethodDescription.InDefinedShape>)ElementMatchers.isEquals()), it -> this.generateEquals((DynamicType.Builder<?>)it, (ElementMatcher<? super FieldDescription.InDefinedShape>)isIdField)).mapBuilder(it -> !it.hasMethod((ElementMatcher<MethodDescription.InDefinedShape>)ElementMatchers.isHashCode()), it -> this.generateHashCode((DynamicType.Builder<?>)it, (ElementMatcher<? super FieldDescription.InDefinedShape>)isIdField)).mapBuilder(it -> !it.hasMethod((ElementMatcher<MethodDescription.InDefinedShape>)ElementMatchers.hasMethodName((String)IS_NEW_METHOD)), this::generateIsNewMethod);
        }).orElse(type);
    }

    private DynamicType.Builder<?> generateCallbacks(DynamicType.Builder<?> builder) {
        if (this.options.callbackInterface != null) {
            builder = builder.defineMethod(MARK_NOT_NEW_METHOD, Void.TYPE, new ModifierContributor.ForMethod[]{Visibility.PUBLIC}).intercept((Implementation)FieldAccessor.ofField((String)IS_NEW_FIELD).setsValue((Object)false)).require(new DynamicType[]{this.createCallbackComponent(builder.toTypeDescription())});
        }
        if (this.options.callbackAnnotations.length > 0) {
            builder = new LifecycleMethods(builder, this.options.callbackAnnotations).apply(() -> Advice.to(NotNewSetter.class), () -> FieldAccessor.ofField((String)IS_NEW_FIELD).setsValue((Object)false));
        }
        return builder;
    }

    private DynamicType.Builder<?> generateIsNewField(DynamicType.Builder<?> builder) {
        builder = builder.defineField(IS_NEW_FIELD, Boolean.TYPE, new ModifierContributor.ForField[]{Visibility.PRIVATE}).value(true).annotateField(new AnnotationDescription[]{PluginUtils.getAnnotation(this.options.isNewPropertyAnnotation)});
        return builder.visit((AsmVisitorWrapper)Advice.to(IsNewInitializer.class).on((ElementMatcher)ElementMatchers.isConstructor()));
    }

    private DynamicType.Builder<?> generateIsNewMethod(DynamicType.Builder<?> builder) {
        return builder.defineMethod(IS_NEW_METHOD, Boolean.TYPE, new ModifierContributor.ForMethod[]{Visibility.PUBLIC}).intercept((Implementation)FieldAccessor.ofField((String)IS_NEW_FIELD));
    }

    private DynamicType.Builder<?> generateEquals(DynamicType.Builder<?> builder, ElementMatcher<? super FieldDescription.InDefinedShape> idField) {
        return builder.defineMethod("equals", Boolean.TYPE, new ModifierContributor.ForMethod[]{Visibility.PUBLIC}).withParameter(Object.class).intercept((Implementation)EqualsMethod.isolated().withIgnoredFields(idField));
    }

    private DynamicType.Builder<?> generateHashCode(DynamicType.Builder<?> builder, ElementMatcher<? super FieldDescription.InDefinedShape> idField) {
        return builder.defineMethod("hashCode", Integer.TYPE, new ModifierContributor.ForMethod[]{Visibility.PUBLIC}).intercept((Implementation)HashCodeMethod.usingDefaultOffset().withIgnoredFields(idField));
    }

    private DynamicType createCallbackComponent(TypeDescription typeDescription) {
        TypeDescription.Generic callbackType = TypeDescription.Generic.Builder.parameterizedType((TypeDescription)new TypeDescription.ForLoadedType(this.options.callbackInterface), (TypeDefinition[])new TypeDefinition[]{typeDescription}).build();
        return new ByteBuddy(ClassFileVersion.JAVA_V8).subclass((TypeDefinition)callbackType).name(typeDescription.getName().concat("JMoleculesCallbacks")).annotateType(new AnnotationDescription[]{PluginUtils.getAnnotation(Component.class)}).make();
    }

    private PersistableImplementor(PersistableOptions options) {
        this.options = options;
    }

    public static PersistableImplementor of(PersistableOptions options) {
        return new PersistableImplementor(options);
    }

    public static class IsNewInitializer {
        @Advice.OnMethodExit
        public static void initIsNewAsTrue(@Advice.FieldValue(value="__jMolecules__isNew", readOnly=false) boolean value) {
            value = true;
        }
    }

    public static class NotNewSetter {
        @Advice.OnMethodExit
        public static void initIsNewAsTrue(@Advice.FieldValue(value="__jMolecules__isNew", readOnly=false) boolean value) {
            value = false;
        }
    }
}

