/*
 * Decompiled with CFR 0.152.
 */
package org.jmolecules.bytebuddy;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.bytebuddy.build.Plugin;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.DynamicType;
import org.jmolecules.bytebuddy.ClassWorld;
import org.jmolecules.bytebuddy.JMoleculesJpaPlugin;
import org.jmolecules.bytebuddy.JMoleculesSpringDataJdbcPlugin;
import org.jmolecules.bytebuddy.JMoleculesSpringDataJpaPlugin;
import org.jmolecules.bytebuddy.JMoleculesSpringDataMongoDbPlugin;
import org.jmolecules.bytebuddy.JMoleculesSpringDataPlugin;
import org.jmolecules.bytebuddy.JMoleculesSpringJpaPlugin;
import org.jmolecules.bytebuddy.JMoleculesSpringPlugin;
import org.jmolecules.bytebuddy.Jpa;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMoleculesPlugin
implements Plugin.WithPreprocessor {
    private static final Logger log = LoggerFactory.getLogger(JMoleculesPlugin.class);
    private Map<TypeDescription, List<? extends Plugin>> delegates = new HashMap<TypeDescription, List<? extends Plugin>>();

    public void onPreprocess(TypeDescription typeDescription, ClassFileLocator classFileLocator) {
        this.delegates.computeIfAbsent(typeDescription, it -> {
            ClassWorld world = ClassWorld.of(classFileLocator);
            Optional<Jpa> jpa = Jpa.getJavaPersistence(world);
            return Stream.of(JMoleculesPlugin.jpaPlugin(world, jpa), JMoleculesPlugin.springPlugin(world), JMoleculesPlugin.springJpaPlugin(world, jpa), JMoleculesPlugin.springDataPlugin(world), JMoleculesPlugin.springDataJdbcPlugin(world), JMoleculesPlugin.springDataJpaPlugin(world, jpa), JMoleculesPlugin.springDataMongDbPlugin(world)).flatMap(plugins -> plugins).filter(plugin -> plugin.matches((Object)typeDescription)).collect(Collectors.toList());
        });
    }

    public boolean matches(TypeDescription target) {
        List<? extends Plugin> plugins = this.delegates.get(target);
        return plugins != null && !plugins.isEmpty();
    }

    public DynamicType.Builder<?> apply(DynamicType.Builder<?> builder, TypeDescription typeDescription, ClassFileLocator classFileLocator) {
        return this.delegates.get(typeDescription).stream().reduce(builder, (it, plugin) -> plugin.apply(it, typeDescription, classFileLocator), (left, right) -> right);
    }

    public void close() throws IOException {
    }

    private static Stream<? extends Plugin> jpaPlugin(ClassWorld world, Optional<Jpa> jpa) {
        return jpa.filter(__ -> {
            boolean jMoleculesJpaAvailable = world.isAvailable("org.jmolecules.jpa.JMoleculesJpa");
            if (!jMoleculesJpaAvailable) {
                log.warn("JMoleculesJpa missing on the classpath! Add org.jmolecules:jmolecules-jpa as dependency!");
            }
            return true;
        }).map(it -> new JMoleculesJpaPlugin((Jpa)it)).map(Stream::of).orElseGet(Stream::empty);
    }

    private static Stream<Plugin> springPlugin(ClassWorld world) {
        return world.isAvailable("org.springframework.stereotype.Component") ? Stream.of(new JMoleculesSpringPlugin()) : Stream.empty();
    }

    private static Stream<Plugin> springDataPlugin(ClassWorld world) {
        return world.isAvailable("org.springframework.data.repository.Repository") ? Stream.of(new JMoleculesSpringDataPlugin()) : Stream.empty();
    }

    private static Stream<? extends Plugin> springJpaPlugin(ClassWorld world, Optional<Jpa> jpa) {
        return jpa.filter(__ -> world.isAvailable("org.springframework.stereotype.Component")).filter(__ -> world.isAvailable("org.jmolecules.spring.jpa.AssociationAttributeConverter")).map(JMoleculesSpringJpaPlugin::new).map(Stream::of).orElseGet(Stream::empty);
    }

    private static Stream<Plugin> springDataJdbcPlugin(ClassWorld world) {
        return world.isAvailable("org.springframework.data.jdbc.core.mapping.AggregateReference") ? Stream.of(new JMoleculesSpringDataJdbcPlugin()) : Stream.empty();
    }

    private static Stream<? extends Plugin> springDataJpaPlugin(ClassWorld world, Optional<Jpa> jpa) {
        return jpa.filter(__ -> world.isAvailable("org.springframework.data.jpa.repository.JpaRepository")).map(JMoleculesSpringDataJpaPlugin::new).map(Stream::of).orElseGet(Stream::empty);
    }

    private static Stream<Plugin> springDataMongDbPlugin(ClassWorld world) {
        return world.isAvailable("org.springframework.data.mongodb.core.mapping.Document") ? Stream.of(new JMoleculesSpringDataMongoDbPlugin()) : Stream.empty();
    }
}

